/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverterHolder;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlNamedConverter;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrmEclipseLinkConverter<X extends XmlNamedConverter>
extends AbstractOrmXmlContextNode
implements EclipseLinkConverter {
    protected final X xmlConverter;
    protected String name;

    protected OrmEclipseLinkConverter(XmlContextNode parent, X xmlConverter) {
        super((JpaContextNode)parent);
        this.xmlConverter = xmlConverter;
        this.name = ((XmlNamedConverter)((Object)xmlConverter)).getName();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(((XmlNamedConverter)((Object)this.xmlConverter)).getName());
    }

    public void update() {
        super.update();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.setName_(name);
        ((XmlNamedConverter)((Object)this.xmlConverter)).setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    public X getXmlConverter() {
        return this.xmlConverter;
    }

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    @Override
    public char getEnclosingTypeSeparator() {
        return '$';
    }

    public abstract Iterable<ReplaceEdit> createRenameTypeEdits(IType var1, String var2);

    public abstract Iterable<ReplaceEdit> createMoveTypeEdits(IType var1, IPackageFragment var2);

    public abstract Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment var1, String var2);

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateName(messages);
    }

    protected void validateName(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_NAME_UNDEFINED", EMPTY_STRING_ARRAY, this, this.getNameTextRange()));
            return;
        }
        if (ArrayTools.contains((Object[])EclipseLinkConvert.RESERVED_CONVERTER_NAMES, (Object)this.name)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "RESERVED_CONVERTER_NAME", EMPTY_STRING_ARRAY, this, this.getNameTextRange()));
        }
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlConverter.getValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    public TextRange getNameTextRange() {
        return this.getValidationTextRange(((XmlNamedConverter)((Object)this.xmlConverter)).getNameTextRange());
    }

    @Override
    public boolean isIdentical(EclipseLinkConverter eclipseLinkConverter) {
        return StringTools.stringsAreEqual((String)this.getName(), (String)eclipseLinkConverter.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractAdapter
    implements Adapter {
        @Override
        public OrmEclipseLinkConverter<? extends XmlNamedConverter> buildConverter(XmlConverterHolder xmlConverterContainer, XmlContextNode parent) {
            XmlNamedConverter xmlConverter = this.getXmlConverter(xmlConverterContainer);
            return xmlConverter == null ? null : this.buildConverter(xmlConverter, parent);
        }

        @Override
        public OrmEclipseLinkConverter<? extends XmlNamedConverter> buildConverter(XmlContextNode parent) {
            return this.buildConverter(this.buildXmlConverter(), parent);
        }

        protected abstract XmlNamedConverter buildXmlConverter();

        @Override
        public void removeXmlConverter(XmlConverterHolder xmlConverterContainer) {
            this.setXmlConverter(xmlConverterContainer, null);
        }

        @Override
        public void addXmlConverter(XmlConverterHolder xmlConverterContainer, XmlNamedConverter xmlConverter) {
            this.setXmlConverter(xmlConverterContainer, xmlConverter);
        }

        protected abstract void setXmlConverter(XmlConverterHolder var1, XmlNamedConverter var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Adapter {
        public Class<? extends EclipseLinkConverter> getConverterType();

        public OrmEclipseLinkConverter<? extends XmlNamedConverter> buildConverter(XmlConverterHolder var1, XmlContextNode var2);

        public XmlNamedConverter getXmlConverter(XmlConverterHolder var1);

        public OrmEclipseLinkConverter<? extends XmlNamedConverter> buildConverter(XmlNamedConverter var1, XmlContextNode var2);

        public OrmEclipseLinkConverter<? extends XmlNamedConverter> buildConverter(XmlContextNode var1);

        public void removeXmlConverter(XmlConverterHolder var1);

        public void addXmlConverter(XmlConverterHolder var1, XmlNamedConverter var2);
    }
}

