/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlElement;
import org.eclipse.jpt.jaxb.core.context.XmlElementMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaBasicMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlElement;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlElementWrapper;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlIDREF;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdFeature;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlElementMapping
extends GenericJavaBasicMapping<XmlElementAnnotation>
implements XmlElementMapping {
    protected final XmlElement xmlElement = this.buildXmlElement();
    protected XmlElementWrapper xmlElementWrapper;

    public GenericJavaXmlElementMapping(JaxbPersistentAttribute parent) {
        super(parent);
        this.initializeXmlElementWrapper();
    }

    @Override
    public String getKey() {
        return "xml-element";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlElement";
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.xmlElement.synchronizeWithResourceModel();
        this.syncXmlElementWrapper();
    }

    @Override
    public void update() {
        super.update();
        this.xmlElement.update();
        this.updateXmlElementWrapper();
    }

    @Override
    public XmlElement getXmlElement() {
        return this.xmlElement;
    }

    protected XmlElement buildXmlElement() {
        return new GenericJavaXmlElement(this, new XmlElementContext());
    }

    @Override
    public XmlElementWrapper getXmlElementWrapper() {
        return this.xmlElementWrapper;
    }

    protected XmlElementWrapper buildXmlElementWrapper(XmlElementWrapperAnnotation xmlElementWrapperAnnotation) {
        return new GenericJavaXmlElementWrapper(this, xmlElementWrapperAnnotation);
    }

    @Override
    public XmlElementWrapper addXmlElementWrapper() {
        if (this.xmlElementWrapper != null) {
            throw new IllegalStateException();
        }
        XmlElementWrapperAnnotation annotation = (XmlElementWrapperAnnotation)this.getJavaResourceAttribute().addAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapper xmlElementWrapper = this.buildXmlElementWrapper(annotation);
        this.setXmlElementWrapper_(xmlElementWrapper);
        return xmlElementWrapper;
    }

    @Override
    public void removeXmlElementWrapper() {
        if (this.xmlElementWrapper == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().removeAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        this.setXmlElementWrapper_(null);
    }

    protected void initializeXmlElementWrapper() {
        XmlElementWrapperAnnotation annotation = this.getXmlElementWrapperAnnotation();
        if (annotation != null) {
            this.xmlElementWrapper = this.buildXmlElementWrapper(annotation);
        }
    }

    protected XmlElementWrapperAnnotation getXmlElementWrapperAnnotation() {
        return (XmlElementWrapperAnnotation)this.getJavaResourceAttribute().getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
    }

    protected void syncXmlElementWrapper() {
        XmlElementWrapperAnnotation annotation = this.getXmlElementWrapperAnnotation();
        if (annotation != null) {
            if (this.getXmlElementWrapper() != null) {
                this.getXmlElementWrapper().synchronizeWithResourceModel();
            } else {
                this.setXmlElementWrapper_(this.buildXmlElementWrapper(annotation));
            }
        } else {
            this.setXmlElementWrapper_(null);
        }
    }

    protected void updateXmlElementWrapper() {
        if (this.getXmlElementWrapper() != null) {
            this.getXmlElementWrapper().update();
        }
    }

    protected void setXmlElementWrapper_(XmlElementWrapper xmlElementWrapper) {
        XmlElementWrapper oldXmlElementWrapper = this.xmlElementWrapper;
        this.xmlElementWrapper = xmlElementWrapper;
        this.firePropertyChanged("xmlElementWrapper", oldXmlElementWrapper, xmlElementWrapper);
    }

    @Override
    protected GenericJavaXmlIDREF.Context buildXmlIDREFContext() {
        return new XmlIDREFContext();
    }

    @Override
    public Iterable<String> getReferencedXmlTypeNames() {
        return new CompositeIterable(new Iterable[]{super.getReferencedXmlTypeNames(), this.xmlElement.getReferencedXmlTypeNames()});
    }

    @Override
    public boolean isParticleMapping() {
        return true;
    }

    @Override
    public XsdFeature getXsdFeature() {
        XsdTypeDefinition xsdType = this.getJaxbClassMapping().getXsdTypeDefinition();
        if (xsdType != null) {
            XmlElementWrapper elementWrapper = this.xmlElementWrapper;
            if (elementWrapper == null) {
                return xsdType.getElement(this.xmlElement.getQName().getNamespace(), this.xmlElement.getQName().getName());
            }
            XsdElementDeclaration xsdWrapperElement = elementWrapper.getXsdElementDeclaration();
            if (xsdWrapperElement != null) {
                return xsdWrapperElement.getElement(this.xmlElement.getQName().getNamespace(), this.xmlElement.getQName().getName());
            }
        }
        return null;
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        result = this.xmlElement.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        if (this.xmlElementWrapper != null && !CollectionTools.isEmpty(result = this.xmlElementWrapper.getJavaCompletionProposals(pos, filter, astRoot))) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.xmlElement.validate(messages, reporter, astRoot);
        if (this.getXmlElementWrapper() != null) {
            this.getXmlElementWrapper().validate(messages, reporter, astRoot);
        }
    }

    public class XmlElementContext
    implements GenericJavaXmlElement.Context {
        public XmlElementAnnotation getAnnotation(boolean createIfNull) {
            return createIfNull ? (XmlElementAnnotation)GenericJavaXmlElementMapping.this.getOrCreateAnnotation() : (XmlElementAnnotation)GenericJavaXmlElementMapping.this.getAnnotation();
        }

        public JaxbAttributeMapping getAttributeMapping() {
            return GenericJavaXmlElementMapping.this;
        }

        public String getDefaultType() {
            return GenericJavaXmlElementMapping.this.getPersistentAttribute().getJavaResourceAttributeBaseTypeName();
        }

        public XmlElementWrapper getElementWrapper() {
            return GenericJavaXmlElementMapping.this.getXmlElementWrapper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlIDREFContext
    extends GenericJavaBasicMapping.XmlIDREFContext {
        protected XmlIDREFContext() {
        }

        @Override
        public Iterable<GenericJavaXmlIDREF.ValidatableReference> getReferences() {
            return new SingleElementIterable((Object)new GenericJavaXmlIDREF.ValidatableReference(){

                public String getFullyQualifiedType() {
                    return ((XmlIDREFContext)XmlIDREFContext.this).GenericJavaXmlElementMapping.this.xmlElement.getType();
                }

                public TextRange getTypeTextRange(CompilationUnit astRoot) {
                    return GenericJavaXmlElementMapping.this.getAnnotation() == null ? GenericJavaXmlElementMapping.this.getXmlIDREF().getValidationTextRange(astRoot) : ((XmlIDREFContext)XmlIDREFContext.this).GenericJavaXmlElementMapping.this.xmlElement.getTypeTextRange(astRoot);
                }

                public XsdFeature getXsdFeature() {
                    return GenericJavaXmlElementMapping.this.getXsdFeature();
                }

                public TextRange getXsdFeatureTextRange(CompilationUnit astRoot) {
                    return ((XmlIDREFContext)XmlIDREFContext.this).GenericJavaXmlElementMapping.this.xmlElement.getQName().getNameTextRange(astRoot);
                }
            });
        }
    }
}

