/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaQName;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaTypeAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericJavaXmlSchemaType
extends AbstractJavaContextNode
implements XmlSchemaType {
    protected final XmlSchemaTypeAnnotation annotation;
    protected JaxbQName qName;
    protected String type;

    protected GenericJavaXmlSchemaType(JaxbContextNode parent, XmlSchemaTypeAnnotation annotation) {
        super(parent);
        this.annotation = annotation;
        this.qName = this.buildQName();
        this.type = this.getResourceTypeString();
    }

    protected JaxbQName buildQName() {
        return new XmlSchemaTypeQName(this);
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    @Override
    public XmlSchemaTypeAnnotation getXmlSchemaTypeAnnotation() {
        return this.annotation;
    }

    protected abstract JaxbPackage getJaxbPackage();

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.qName.synchronizeWithResourceModel();
        this.setType_(this.getResourceTypeString());
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String location) {
        this.annotation.setType(location);
        this.setType_(location);
    }

    protected void setType_(String type) {
        String old = this.type;
        this.type = type;
        this.firePropertyChanged("type", old, type);
    }

    protected String getResourceTypeString() {
        return this.annotation.getType();
    }

    public String getFullyQualifiedType() {
        return this.getXmlSchemaTypeAnnotation().getFullyQualifiedType();
    }

    protected XsdTypeDefinition getXsdTypeDefinition_() {
        XsdSchema xsdSchema = this.getJaxbPackage().getXsdSchema();
        if (xsdSchema == null) {
            return null;
        }
        if (!StringTools.stringIsEmpty((String)this.qName.getName())) {
            return xsdSchema.getTypeDefinition(this.qName.getNamespace(), this.qName.getName());
        }
        return null;
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        result = this.qName.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.annotation.getTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.qName.validate(messages, reporter, astRoot);
        XsdTypeDefinition xsdType = this.getXsdTypeDefinition_();
        if (xsdType != null && xsdType.getKind() != XsdTypeDefinition.Kind.SIMPLE) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_SCHEMA_TYPE__NON_SIMPLE_TYPE", new String[]{this.qName.getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }

    protected TextRange getTypeTextRange(CompilationUnit astRoot) {
        return this.getXmlSchemaTypeAnnotation().getTypeTextRange(astRoot);
    }

    protected class QNameAnnotationProxy
    extends AbstractJavaQName.AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            return GenericJavaXmlSchemaType.this.annotation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlSchemaTypeQName
    extends AbstractJavaQName {
        protected XmlSchemaTypeQName(JavaContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        @Override
        protected JaxbPackage getJaxbPackage() {
            return GenericJavaXmlSchemaType.this.getJaxbPackage();
        }

        @Override
        protected String getReferencedComponentTypeDescription() {
            return JptJaxbCoreMessages.XML_TYPE_DESC;
        }

        @Override
        public String getDefaultName() {
            return null;
        }

        @Override
        public String getDefaultNamespace() {
            return "http://www.w3.org/2001/XMLSchema";
        }

        @Override
        protected Iterable<String> getNamespaceProposals(Filter<String> filter) {
            XsdSchema schema = this.getXsdSchema();
            if (schema == null) {
                return EmptyIterable.instance();
            }
            return schema.getNamespaceProposals(filter);
        }

        @Override
        protected Iterable<String> getNameProposals(Filter<String> filter) {
            XsdSchema schema = this.getXsdSchema();
            if (schema == null) {
                return EmptyIterable.instance();
            }
            return schema.getSimpleTypeNameProposals(this.getNamespace(), filter);
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
            XsdTypeDefinition schemaType;
            XsdSchema schema;
            String name = this.getName();
            String namespace = this.getNamespace();
            if (!StringTools.stringIsEmpty((String)name) && (schema = this.getXsdSchema()) != null && (schemaType = schema.getTypeDefinition(namespace, name)) == null) {
                messages.add(this.getUnresolveSchemaComponentMessage(astRoot));
            }
        }
    }
}

