/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.IndexedConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedExpressionConverter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceXmlTypeAnnotation
extends SourceAnnotation
implements XmlTypeAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlType");
    private static final DeclarationAnnotationElementAdapter<String> FACTORY_CLASS_ADAPTER = SourceXmlTypeAnnotation.buildFactoryClassAdapter();
    private final AnnotationElementAdapter<String> factoryClassAdapter;
    private String factoryClass;
    private String fullyQualifiedFactoryClassName;
    private static final DeclarationAnnotationElementAdapter<String> FACTORY_METHOD_ADAPTER = SourceXmlTypeAnnotation.buildFactoryMethodAdapter();
    private final AnnotationElementAdapter<String> factoryMethodAdapter;
    private String factoryMethod;
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = SourceXmlTypeAnnotation.buildNameAdapter();
    private final AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private static final DeclarationAnnotationElementAdapter<String> NAMESPACE_ADAPTER = SourceXmlTypeAnnotation.buildNamespaceAdapter();
    private final AnnotationElementAdapter<String> namespaceAdapter;
    private String namespace;
    private final IndexedDeclarationAnnotationElementAdapter<String> propOrderDeclarationAdapter;
    private final AnnotationElementAdapter<String[]> propOrderAdapter;
    private final Vector<String> propOrder = new Vector();

    public SourceXmlTypeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
        super((JavaResourceNode)parent, annotatedElement, DECLARATION_ANNOTATION_ADAPTER);
        this.factoryClassAdapter = this.buildAnnotationElementAdapter(FACTORY_CLASS_ADAPTER);
        this.factoryMethodAdapter = this.buildAnnotationElementAdapter(FACTORY_METHOD_ADAPTER);
        this.nameAdapter = this.buildAnnotationElementAdapter(NAME_ADAPTER);
        this.namespaceAdapter = this.buildAnnotationElementAdapter(NAMESPACE_ADAPTER);
        this.propOrderDeclarationAdapter = SourceXmlTypeAnnotation.buildArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "propOrder");
        this.propOrderAdapter = this.buildArrayAnnotationElementAdapter((DeclarationAnnotationElementAdapter<String[]>)this.propOrderDeclarationAdapter);
    }

    protected AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private static IndexedDeclarationAnnotationElementAdapter<String> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceXmlTypeAnnotation.buildArrayAnnotationElementAdapter(annotationAdapter, elementName, (IndexedExpressionConverter<String>)AnnotationStringArrayExpressionConverter.forStrings());
    }

    private static IndexedDeclarationAnnotationElementAdapter<String> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, IndexedExpressionConverter<String> converter) {
        return new IndexedConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    private AnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String[]> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlType";
    }

    public void initialize(CompilationUnit astRoot) {
        this.factoryClass = this.buildFactoryClass(astRoot);
        this.fullyQualifiedFactoryClassName = this.buildFullyQualifiedFactoryClassName(astRoot);
        this.factoryMethod = this.buildFactoryMethod(astRoot);
        this.name = this.buildName(astRoot);
        this.namespace = this.buildNamespace(astRoot);
        this.initializePropOrder(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncFactoryClass(this.buildFactoryClass(astRoot));
        this.syncFullyQualifiedFactoryClassName(this.buildFullyQualifiedFactoryClassName(astRoot));
        this.syncFactoryMethod(this.buildFactoryMethod(astRoot));
        this.syncName(this.buildName(astRoot));
        this.syncNamespace(this.buildNamespace(astRoot));
        this.syncPropOrder(astRoot);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getFactoryClass() {
        return this.factoryClass;
    }

    @Override
    public void setFactoryClass(String factoryClass) {
        if (this.attributeValueHasChanged(this.factoryClass, factoryClass)) {
            this.factoryClass = factoryClass;
            this.factoryClassAdapter.setValue((Object)factoryClass);
        }
    }

    private void syncFactoryClass(String astFactoryClass) {
        String old = this.factoryClass;
        this.factoryClass = astFactoryClass;
        this.firePropertyChanged("factoryClass", old, astFactoryClass);
    }

    private String buildFactoryClass(CompilationUnit astRoot) {
        return (String)this.factoryClassAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getFactoryClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(FACTORY_CLASS_ADAPTER, astRoot);
    }

    @Override
    public String getFullyQualifiedFactoryClassName() {
        return this.fullyQualifiedFactoryClassName;
    }

    private void syncFullyQualifiedFactoryClassName(String name) {
        String old = this.fullyQualifiedFactoryClassName;
        this.fullyQualifiedFactoryClassName = name;
        this.firePropertyChanged("fullyQualifiedFactoryClassName", old, name);
    }

    private String buildFullyQualifiedFactoryClassName(CompilationUnit astRoot) {
        return this.factoryClass == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.factoryClassAdapter.getExpression(astRoot));
    }

    @Override
    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    @Override
    public void setFactoryMethod(String factoryMethod) {
        if (this.attributeValueHasChanged(this.factoryMethod, factoryMethod)) {
            this.factoryMethod = factoryMethod;
            this.factoryMethodAdapter.setValue((Object)factoryMethod);
        }
    }

    private void syncFactoryMethod(String astFactoryMethod) {
        String old = this.factoryMethod;
        this.factoryMethod = astFactoryMethod;
        this.firePropertyChanged("factoryMethod", old, astFactoryMethod);
    }

    private String buildFactoryMethod(CompilationUnit astRoot) {
        return (String)this.factoryMethodAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getFactoryMethodTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(FACTORY_METHOD_ADAPTER, astRoot);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(NAME_ADAPTER, astRoot);
    }

    @Override
    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(NAME_ADAPTER, pos, astRoot);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (this.attributeValueHasChanged(this.namespace, namespace)) {
            this.namespace = namespace;
            this.namespaceAdapter.setValue((Object)namespace);
        }
    }

    private void syncNamespace(String astNamespace) {
        String old = this.namespace;
        this.namespace = astNamespace;
        this.firePropertyChanged("namespace", old, astNamespace);
    }

    private String buildNamespace(CompilationUnit astRoot) {
        return (String)this.namespaceAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNamespaceTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(NAMESPACE_ADAPTER, astRoot);
    }

    @Override
    public boolean namespaceTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(NAMESPACE_ADAPTER, pos, astRoot);
    }

    @Override
    public ListIterable<String> getPropOrder() {
        return new LiveCloneListIterable(this.propOrder);
    }

    @Override
    public int getPropOrderSize() {
        return this.propOrder.size();
    }

    @Override
    public void addProp(String prop) {
        this.addProp(this.propOrder.size(), prop);
    }

    @Override
    public void addProp(int index, String prop) {
        this.propOrder.add(index, prop);
        this.writePropOrder();
    }

    @Override
    public void moveProp(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.propOrder, (int)targetIndex, (int)sourceIndex);
        this.writePropOrder();
    }

    @Override
    public void removeProp(String prop) {
        this.propOrder.remove(prop);
        this.writePropOrder();
    }

    @Override
    public void removeProp(int index) {
        this.propOrder.remove(index);
        this.writePropOrder();
    }

    private void writePropOrder() {
        this.propOrderAdapter.setValue((Object)this.propOrder.toArray(new String[this.propOrder.size()]));
    }

    private void initializePropOrder(CompilationUnit astRoot) {
        String[] astPropOrder = (String[])this.propOrderAdapter.getValue(astRoot);
        int i = 0;
        while (i < astPropOrder.length) {
            this.propOrder.add(astPropOrder[i]);
            ++i;
        }
    }

    private void syncPropOrder(CompilationUnit astRoot) {
        String[] astPropOrder = (String[])this.propOrderAdapter.getValue(astRoot);
        this.synchronizeList(Arrays.asList(astPropOrder), this.propOrder, "propOrder");
    }

    @Override
    public TextRange getPropOrderTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange((DeclarationAnnotationElementAdapter)this.propOrderDeclarationAdapter, astRoot);
    }

    @Override
    public boolean propOrderTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches((DeclarationAnnotationElementAdapter)this.propOrderDeclarationAdapter, pos, astRoot);
    }

    @Override
    public TextRange getPropTextRange(int index, CompilationUnit astRoot) {
        return this.getElementTextRange(this.getAnnotationElementSubvalueTextRange(this.propOrderDeclarationAdapter, index, astRoot), astRoot);
    }

    @Override
    public boolean propTouches(int index, int pos, CompilationUnit astRoot) {
        return this.textRangeTouches(this.getAnnotationElementSubvalueTextRange(this.propOrderDeclarationAdapter, index, astRoot), pos);
    }

    private static DeclarationAnnotationElementAdapter<String> buildFactoryClassAdapter() {
        return SourceXmlTypeAnnotation.buildAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "factoryClass", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    private static DeclarationAnnotationElementAdapter<String> buildFactoryMethodAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"factoryMethod");
    }

    private static DeclarationAnnotationElementAdapter<String> buildNameAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"name");
    }

    private static DeclarationAnnotationElementAdapter<String> buildNamespaceAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"namespace");
    }
}

