/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.AbstractExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NameStringExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringArrayExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.TypeStringExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedExpressionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationStringArrayExpressionConverter
extends AbstractExpressionConverter<String[]>
implements IndexedExpressionConverter<String> {
    private final ExpressionConverter<String> elementConverter;
    private final StringArrayExpressionConverter arrayConverter;

    public AnnotationStringArrayExpressionConverter(ExpressionConverter<String> elementConverter) {
        this(elementConverter, true);
    }

    public AnnotationStringArrayExpressionConverter(ExpressionConverter<String> elementConverter, boolean removeArrayInitializerWhenEmpty) {
        this.elementConverter = elementConverter;
        this.arrayConverter = new StringArrayExpressionConverter(elementConverter, removeArrayInitializerWhenEmpty);
    }

    @Override
    protected Expression convertObject(String[] strings, AST ast) {
        return strings.length == 1 ? this.elementConverter.convert(strings[0], ast) : this.arrayConverter.convertObject(strings, ast);
    }

    @Override
    protected String[] convertNull() {
        return this.arrayConverter.convertNull();
    }

    @Override
    protected String[] convertExpression(Expression expression) {
        String[] stringArray;
        if (expression.getNodeType() == 4) {
            return this.arrayConverter.convertArrayInitializer((ArrayInitializer)expression);
        }
        String result = this.elementConverter.convert(expression);
        if (result == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = result;
        }
        return stringArray;
    }

    @Override
    public Expression getSubexpression(int index, Expression expression) {
        if (expression.getNodeType() == 4) {
            return this.arrayConverter.getSubexpression(index, expression);
        }
        if (index > 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return expression;
    }

    public static AnnotationStringArrayExpressionConverter forStrings() {
        return new AnnotationStringArrayExpressionConverter(StringExpressionConverter.instance());
    }

    public static AnnotationStringArrayExpressionConverter forNames() {
        return new AnnotationStringArrayExpressionConverter(NameStringExpressionConverter.instance());
    }

    public static AnnotationStringArrayExpressionConverter forTypes() {
        return new AnnotationStringArrayExpressionConverter(TypeStringExpressionConverter.instance());
    }
}

