/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaJoinColumnRelationshipStrategy
extends AbstractJavaJpaContextNode
implements JavaJoinColumnRelationshipStrategy {
    protected final AbstractJpaNode.ContextListContainer<JavaJoinColumn, JoinColumnAnnotation> specifiedJoinColumnContainer;
    protected final JavaReadOnlyJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();
    protected JavaJoinColumn defaultJoinColumn;

    protected AbstractJavaJoinColumnRelationshipStrategy(JavaJoinColumnRelationship parent) {
        super(parent);
        this.specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedJoinColumns();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedJoinColumns());
        this.updateDefaultJoinColumn();
    }

    @Override
    public ListIterable<JavaJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public ListIterable<JavaJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer.getContextElements();
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.getContextElementsSize();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public JavaJoinColumn getSpecifiedJoinColumn(int index) {
        return this.specifiedJoinColumnContainer.getContextElement(index);
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn() {
        return this.addSpecifiedJoinColumn(this.getSpecifiedJoinColumnsSize());
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn(int index) {
        JoinColumnAnnotation annotation = this.addJoinColumnAnnotation(index);
        return (JavaJoinColumn)this.specifiedJoinColumnContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumnContainer.indexOfContextElement((JavaJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        this.removeJoinColumnAnnotation(index);
        this.specifiedJoinColumnContainer.removeContextElement(index);
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        this.moveJoinColumnAnnotation(targetIndex, sourceIndex);
        this.specifiedJoinColumnContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected void syncSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.synchronizeWithResourceModel();
    }

    protected AbstractJpaNode.ContextListContainer<JavaJoinColumn, JoinColumnAnnotation> buildSpecifiedJoinColumnContainer() {
        SpecifiedJoinColumnContainer container = new SpecifiedJoinColumnContainer();
        container.initialize();
        return container;
    }

    protected abstract JavaReadOnlyJoinColumn.Owner buildJoinColumnOwner();

    @Override
    public JavaJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaJoinColumn joinColumn) {
        JavaJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<JavaJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(this.buildNullJoinColumnAnnotation()));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns() && this.getRelationship().mayHaveDefaultJoinColumn();
    }

    protected abstract ListIterable<JoinColumnAnnotation> getJoinColumnAnnotations();

    protected abstract JoinColumnAnnotation addJoinColumnAnnotation(int var1);

    protected abstract void removeJoinColumnAnnotation(int var1);

    protected abstract void moveJoinColumnAnnotation(int var1, int var2);

    protected abstract JoinColumnAnnotation buildNullJoinColumnAnnotation();

    @Override
    public JavaJoinColumnRelationship getParent() {
        return (JavaJoinColumnRelationship)super.getParent();
    }

    @Override
    public JavaJoinColumnRelationship getRelationship() {
        return this.getParent();
    }

    protected JavaJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnAnnotation) {
        return this.getJpaFactory().buildJavaJoinColumn(this, this.joinColumnOwner, joinColumnAnnotation);
    }

    @Override
    public void initializeFrom(ReadOnlyJoinColumnRelationshipStrategy oldStrategy) {
        for (ReadOnlyJoinColumn joinColumn : oldStrategy.getSpecifiedJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    @Override
    public void initializeFromVirtual(ReadOnlyJoinColumnRelationshipStrategy virtualStrategy) {
        for (ReadOnlyJoinColumn joinColumn : virtualStrategy.getJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFromVirtual(joinColumn);
        }
    }

    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public String getTableName() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.getPrimaryTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping != null && typeMapping.tableNameIsInvalid(tableName);
    }

    public Table getReferencedColumnDbTable() {
        TypeMapping relationshipTarget = this.getRelationshipTarget();
        return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
    }

    protected Iterable<String> getCandidateTableNames() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping != null ? typeMapping.getAllAssociatedTableNames() : EmptyIterable.instance();
    }

    @Override
    public void addStrategy() {
        if (this.getSpecifiedJoinColumnsSize() == 0) {
            this.addSpecifiedJoinColumn();
        }
    }

    @Override
    public void removeStrategy() {
        int i = this.getSpecifiedJoinColumnsSize();
        while (i-- > 0) {
            this.removeSpecifiedJoinColumn(i);
        }
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn joinColumn : this.getJoinColumns()) {
            result = joinColumn.getJavaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        for (JavaJoinColumn joinColumn : this.getJoinColumns()) {
            joinColumn.validate(messages, reporter, astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedJoinColumnContainer
    extends AbstractJpaNode.ContextListContainer<JavaJoinColumn, JoinColumnAnnotation> {
        protected SpecifiedJoinColumnContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedJoinColumns";
        }

        @Override
        protected JavaJoinColumn buildContextElement(JoinColumnAnnotation resourceElement) {
            return AbstractJavaJoinColumnRelationshipStrategy.this.buildJoinColumn(resourceElement);
        }

        @Override
        protected ListIterable<JoinColumnAnnotation> getResourceElements() {
            return AbstractJavaJoinColumnRelationshipStrategy.this.getJoinColumnAnnotations();
        }

        @Override
        protected JoinColumnAnnotation getResourceElement(JavaJoinColumn contextElement) {
            return (JoinColumnAnnotation)contextElement.getColumnAnnotation();
        }
    }
}

