/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.VirtualTable;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualUniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.TableTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaTableTextRangeResolver;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaVirtualTable<T extends ReadOnlyTable>
extends AbstractJavaJpaContextNode
implements VirtualTable,
JavaReadOnlyTable {
    protected final ReadOnlyTable.Owner owner;
    protected final T overriddenTable;
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected final AbstractJpaNode.ContextListContainer<JavaVirtualUniqueConstraint, ReadOnlyUniqueConstraint> uniqueConstraintContainer;

    protected AbstractJavaVirtualTable(JavaJpaContextNode parent, ReadOnlyTable.Owner owner, T overridenTable) {
        super(parent);
        this.owner = owner;
        this.overriddenTable = overridenTable;
        this.uniqueConstraintContainer = this.buildUniqueConstraintContainer();
    }

    @Override
    public void update() {
        super.update();
        this.setSpecifiedName(this.buildSpecifiedName());
        this.setDefaultName(this.buildDefaultName());
        this.setSpecifiedSchema(this.buildSpecifiedSchema());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setSpecifiedCatalog(this.buildSpecifiedCatalog());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.updateUniqueConstraints();
    }

    public T getOverriddenTable() {
        return this.overriddenTable;
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    protected void setSpecifiedName(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        return this.getOverriddenTable().getSpecifiedName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected abstract String buildDefaultName();

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    protected void setSpecifiedSchema(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected String buildSpecifiedSchema() {
        return this.getOverriddenTable().getSchema();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected abstract String buildDefaultSchema();

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    protected void setSpecifiedCatalog(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected String buildSpecifiedCatalog() {
        return this.getOverriddenTable().getCatalog();
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected abstract String buildDefaultCatalog();

    public ListIterable<JavaVirtualUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraintContainer.getContextElements();
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintContainer.getContextElementsSize();
    }

    @Override
    public JavaVirtualUniqueConstraint getUniqueConstraint(int index) {
        return this.uniqueConstraintContainer.getContextElement(index);
    }

    protected void updateUniqueConstraints() {
        this.uniqueConstraintContainer.update();
    }

    protected ListIterable<ReadOnlyUniqueConstraint> getOverriddenUniqueConstraints() {
        return new SuperListIterableWrapper(this.getOverriddenTable().getUniqueConstraints());
    }

    protected void moveUniqueConstraint(int index, JavaVirtualUniqueConstraint constraint) {
        this.uniqueConstraintContainer.moveContextElement(index, constraint);
    }

    protected JavaVirtualUniqueConstraint addUniqueConstraint(int index, ReadOnlyUniqueConstraint uniqueConstraint) {
        return (JavaVirtualUniqueConstraint)this.uniqueConstraintContainer.addContextElement(index, uniqueConstraint);
    }

    protected JavaVirtualUniqueConstraint buildUniqueConstraint(ReadOnlyUniqueConstraint uniqueConstraint) {
        return this.getJpaFactory().buildJavaVirtualUniqueConstraint(this, uniqueConstraint);
    }

    protected void removeUniqueConstraint(JavaVirtualUniqueConstraint constraint) {
        this.uniqueConstraintContainer.removeContextElement(constraint);
    }

    protected AbstractJpaNode.ContextListContainer<JavaVirtualUniqueConstraint, ReadOnlyUniqueConstraint> buildUniqueConstraintContainer() {
        return new UniqueConstraintContainer();
    }

    @Override
    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getName());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public boolean schemaIsResolved() {
        return this.getDbSchema() != null;
    }

    @Override
    public boolean catalogIsResolved() {
        String catalog = this.getCatalog();
        return catalog == null || this.resolveDbCatalog(catalog) != null;
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    protected boolean hasResolvedSchema() {
        return this.getDbSchema() != null;
    }

    protected boolean hasResolvedCatalog() {
        String catalog = this.getCatalog();
        return catalog == null || this.resolveDbCatalog(catalog) != null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.buildTableValidator(astRoot).validate(messages, reporter);
    }

    protected JptValidator buildTableValidator(CompilationUnit astRoot) {
        return this.owner.buildTableValidator(this, this.buildTextRangeResolver(astRoot));
    }

    protected TableTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaTableTextRangeResolver(this, astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getParent().getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(astRoot);
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.buildQualifiedName());
    }

    protected String buildQualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName((String)this.getCatalog(), (String)this.getSchema(), (String)this.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UniqueConstraintContainer
    extends AbstractJpaNode.ContextListContainer<JavaVirtualUniqueConstraint, ReadOnlyUniqueConstraint> {
        protected UniqueConstraintContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "uniqueConstraints";
        }

        @Override
        protected JavaVirtualUniqueConstraint buildContextElement(ReadOnlyUniqueConstraint resourceElement) {
            return AbstractJavaVirtualTable.this.buildUniqueConstraint(resourceElement);
        }

        @Override
        protected ListIterable<ReadOnlyUniqueConstraint> getResourceElements() {
            return AbstractJavaVirtualTable.this.getOverriddenUniqueConstraints();
        }

        @Override
        protected ReadOnlyUniqueConstraint getResourceElement(JavaVirtualUniqueConstraint contextElement) {
            return contextElement.getOverriddenUniqueConstraint();
        }
    }
}

