/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.QueryHint;
import org.eclipse.jpt.jpa.core.context.orm.OrmQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.resource.orm.XmlQueryHint;

public class GenericOrmQueryHint
extends AbstractOrmXmlContextNode
implements OrmQueryHint {
    protected final XmlQueryHint xmlQueryHint;
    protected String name;
    protected String value;

    public GenericOrmQueryHint(OrmQuery parent, XmlQueryHint xmlQueryHint) {
        super(parent);
        this.xmlQueryHint = xmlQueryHint;
        this.name = xmlQueryHint.getName();
        this.value = xmlQueryHint.getValue();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.xmlQueryHint.getName());
        this.setValue_(this.xmlQueryHint.getValue());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.setName_(name);
        this.xmlQueryHint.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.setValue_(value);
        this.xmlQueryHint.setValue(value);
    }

    protected void setValue_(String value) {
        String old = this.value;
        this.value = value;
        this.firePropertyChanged("value", old, value);
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlQueryHint.getValidationTextRange();
        return textRange != null ? textRange : this.getQuery().getValidationTextRange();
    }

    public boolean isIdentical(QueryHint hint) {
        return StringTools.stringsAreEqual((String)this.getName(), (String)hint.getName()) && StringTools.stringsAreEqual((String)this.getValue(), (String)hint.getValue());
    }

    public OrmQuery getParent() {
        return (OrmQuery)super.getParent();
    }

    protected OrmQuery getQuery() {
        return this.getParent();
    }

    public XmlQueryHint getXmlQueryHint() {
        return this.xmlQueryHint;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

