/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.persistence;

import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericClassRef
extends AbstractPersistenceXmlContextNode
implements ClassRef {
    protected final XmlJavaClassRef xmlJavaClassRef;
    protected String className;
    protected JavaPersistentType javaPersistentType;

    public GenericClassRef(PersistenceUnit parent, XmlJavaClassRef xmlJavaClassRef) {
        this(parent, xmlJavaClassRef, xmlJavaClassRef.getJavaClass());
    }

    public GenericClassRef(PersistenceUnit parent, String className) {
        this(parent, null, className);
    }

    protected GenericClassRef(PersistenceUnit parent, XmlJavaClassRef xmlJavaClassRef, String className) {
        super(parent);
        this.xmlJavaClassRef = xmlJavaClassRef;
        this.className = className;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        if (this.isNotVirtual()) {
            this.setClassName_(this.xmlJavaClassRef.getJavaClass());
        }
        if (this.javaPersistentType != null) {
            this.javaPersistentType.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        this.updateJavaPersistentType();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String className) {
        if (this.isVirtual()) {
            throw new IllegalStateException("The name of a virtual class ref cannot be changed: " + this);
        }
        this.setClassName_(className);
        this.xmlJavaClassRef.setJavaClass(className);
    }

    protected void setClassName_(String className) {
        String old = this.className;
        this.className = className;
        this.firePropertyChanged("className", old, className);
    }

    protected String getJavaClassName() {
        return StringTools.stringIsEmpty((String)this.className) ? null : this.className.replace('$', '.');
    }

    @Override
    public JavaPersistentType getJavaPersistentType() {
        return this.javaPersistentType;
    }

    protected void setJavaPersistentType(JavaPersistentType javaPersistentType) {
        JavaPersistentType old = this.javaPersistentType;
        this.javaPersistentType = javaPersistentType;
        this.firePropertyChanged("javaPersistentType", old, javaPersistentType);
    }

    protected void updateJavaPersistentType() {
        JavaResourceType resourceType = this.resolveJavaResourceType();
        if (resourceType == null) {
            if (this.javaPersistentType != null) {
                this.javaPersistentType.dispose();
                this.setJavaPersistentType(null);
            }
        } else if (this.javaPersistentType == null) {
            this.setJavaPersistentType(this.buildJavaPersistentType(resourceType));
        } else if (this.javaPersistentType.getJavaResourceType() == resourceType) {
            this.javaPersistentType.update();
        } else {
            this.javaPersistentType.dispose();
            this.setJavaPersistentType(this.buildJavaPersistentType(resourceType));
        }
    }

    protected JavaResourceType resolveJavaResourceType() {
        String javaClassName = this.getJavaClassName();
        return javaClassName == null ? null : (JavaResourceType)this.getJpaProject().getJavaResourceType(javaClassName, JavaResourceAnnotatedElement.Kind.TYPE);
    }

    protected JavaPersistentType buildJavaPersistentType(JavaResourceType jrpt) {
        return this.getJpaFactory().buildJavaPersistentType(this, jrpt);
    }

    @Override
    public PersistenceUnit getParent() {
        return (PersistenceUnit)super.getParent();
    }

    @Override
    public XmlJavaClassRef getXmlClassRef() {
        return this.xmlJavaClassRef;
    }

    protected boolean isFor(IType type) {
        return this.isFor(type.getFullyQualifiedName('.'));
    }

    @Override
    public boolean isFor(String typeName) {
        return Tools.valuesAreEqual((Object)typeName, (Object)this.getJavaClassName());
    }

    protected boolean isInPackage(IPackageFragment packageFragment) {
        return Tools.valuesAreEqual((Object)this.getPackageName(), (Object)packageFragment.getElementName());
    }

    protected String getPackageName() {
        int lastPeriod = this.className.lastIndexOf(46);
        return lastPeriod == -1 ? null : this.className.substring(0, lastPeriod);
    }

    @Override
    public boolean isVirtual() {
        return this.xmlJavaClassRef == null;
    }

    protected boolean isNotVirtual() {
        return !this.isVirtual();
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.isNotVirtual() && this.xmlJavaClassRef.containsOffset(textOffset);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getJavaClassName());
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.jpa.core.persistence.classRef";
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.isVirtual() ? null : this.xmlJavaClassRef.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        if (this.javaPersistentType != null) {
            this.javaPersistentType.dispose();
        }
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistenceUnit().getDefaultAccess();
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(IType type) {
        if (this.isVirtual()) {
            throw new IllegalStateException();
        }
        return this.isFor(type) ? new SingleElementIterable((Object)this.createDeleteEdit()) : EmptyIterable.instance();
    }

    protected DeleteEdit createDeleteEdit() {
        return this.xmlJavaClassRef.createDeleteEdit();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        if (this.isVirtual()) {
            throw new IllegalStateException();
        }
        return this.isFor(originalType) ? new SingleElementIterable((Object)this.createReplaceEdit(originalType, newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createReplaceEdit(IType originalType, String newName) {
        return this.xmlJavaClassRef.createRenameEdit(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        if (this.isVirtual()) {
            throw new IllegalStateException();
        }
        return this.isFor(originalType) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newPackage.getElementName())) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        if (this.isVirtual()) {
            throw new IllegalStateException();
        }
        return this.isInPackage(originalPackage) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenamePackageEdit(String newName) {
        return this.xmlJavaClassRef.createRenamePackageEdit(newName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.stringIsEmpty((String)this.className)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSPECIFIED_CLASS", this, this.getValidationTextRange()));
            return;
        }
        if (this.javaPersistentType == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_NONEXISTENT_CLASS", new String[]{this.getJavaClassName()}, this, this.getValidationTextRange()));
            return;
        }
        boolean validateJavaPersistentType = true;
        for (MappingFileRef mappingFileRef : this.getPersistenceUnit().getMappingFileRefsContaining(this.getJavaClassName())) {
            validateJavaPersistentType = false;
            messages.add(DefaultJpaValidationMessages.buildMessage(4, "PERSISTENCE_UNIT_REDUNDANT_CLASS", new String[]{this.getJavaClassName(), mappingFileRef.getFileName()}, this, this.getValidationTextRange()));
        }
        if (validateJavaPersistentType) {
            this.validateJavaPersistentType(messages, reporter);
        }
    }

    protected void validateJavaPersistentType(List<IMessage> messages, IReporter reporter) {
        try {
            this.javaPersistentType.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptJpaCorePlugin.log(t);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlValidationTextRange();
        return textRange != null ? textRange : this.getPersistenceUnit().getValidationTextRange();
    }

    public TextRange getXmlValidationTextRange() {
        return this.isVirtual() ? null : this.xmlJavaClassRef.getValidationTextRange();
    }
}

