/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceUniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.BaseTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceBaseTableAnnotation
extends SourceAnnotation
implements BaseTableAnnotation {
    DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    AnnotationElementAdapter<String> nameAdapter;
    String name;
    DeclarationAnnotationElementAdapter<String> schemaDeclarationAdapter;
    AnnotationElementAdapter<String> schemaAdapter;
    String schema;
    DeclarationAnnotationElementAdapter<String> catalogDeclarationAdapter;
    AnnotationElementAdapter<String> catalogAdapter;
    String catalog;
    final UniqueConstraintsAnnotationContainer uniqueConstraintsContainer = new UniqueConstraintsAnnotationContainer();

    protected SourceBaseTableAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        this(parent, element, daa, (AnnotationAdapter)new ElementAnnotationAdapter(element, daa));
    }

    protected SourceBaseTableAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameDeclarationAdapter();
        this.nameAdapter = this.buildNameAdapter();
        this.schemaDeclarationAdapter = this.buildSchemaDeclarationAdapter();
        this.schemaAdapter = this.buildSchemaAdapter();
        this.catalogDeclarationAdapter = this.buildCatalogDeclarationAdapter();
        this.catalogAdapter = this.buildCatalogAdapter();
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.schema = this.buildSchema(astRoot);
        this.catalog = this.buildCatalog(astRoot);
        this.uniqueConstraintsContainer.initialize(this.getAstAnnotation(astRoot));
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.syncSchema(this.buildSchema(astRoot));
        this.syncCatalog(this.buildCatalog(astRoot));
        this.uniqueConstraintsContainer.synchronize(this.getAstAnnotation(astRoot));
    }

    protected abstract String getUniqueConstraintsElementName();

    @Override
    public boolean isSpecified() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.nameDeclarationAdapter, pos, astRoot);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter();

    private AnnotationElementAdapter<String> buildNameAdapter() {
        return this.buildAnnotationElementAdapter(this.nameDeclarationAdapter);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        if (this.attributeValueHasChanged(this.schema, schema)) {
            this.schema = schema;
            this.schemaAdapter.setValue((Object)schema);
        }
    }

    private void syncSchema(String astSchema) {
        String old = this.schema;
        this.schema = astSchema;
        this.firePropertyChanged("schema", old, astSchema);
    }

    private String buildSchema(CompilationUnit astRoot) {
        return (String)this.schemaAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.schemaDeclarationAdapter, astRoot);
    }

    @Override
    public boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.schemaDeclarationAdapter, pos, astRoot);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> buildSchemaDeclarationAdapter();

    private AnnotationElementAdapter<String> buildSchemaAdapter() {
        return this.buildAnnotationElementAdapter(this.schemaDeclarationAdapter);
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) {
        if (this.attributeValueHasChanged(this.catalog, catalog)) {
            this.catalog = catalog;
            this.catalogAdapter.setValue((Object)catalog);
        }
    }

    private void syncCatalog(String astCatalog) {
        String old = this.catalog;
        this.catalog = astCatalog;
        this.firePropertyChanged("catalog", old, astCatalog);
    }

    private String buildCatalog(CompilationUnit astRoot) {
        return (String)this.catalogAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.catalogDeclarationAdapter, astRoot);
    }

    @Override
    public boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.catalogDeclarationAdapter, pos, astRoot);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> buildCatalogDeclarationAdapter();

    private AnnotationElementAdapter<String> buildCatalogAdapter() {
        return this.buildAnnotationElementAdapter(this.catalogDeclarationAdapter);
    }

    @Override
    public ListIterable<UniqueConstraintAnnotation> getUniqueConstraints() {
        return this.uniqueConstraintsContainer.getNestedAnnotations();
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintsContainer.getNestedAnnotationsSize();
    }

    @Override
    public UniqueConstraintAnnotation uniqueConstraintAt(int index) {
        return (UniqueConstraintAnnotation)this.uniqueConstraintsContainer.nestedAnnotationAt(index);
    }

    @Override
    public UniqueConstraintAnnotation addUniqueConstraint(int index) {
        return (UniqueConstraintAnnotation)this.uniqueConstraintsContainer.addNestedAnnotation(index);
    }

    private UniqueConstraintAnnotation buildUniqueConstraint(int index) {
        return new SourceUniqueConstraintAnnotation((JavaResourceNode)this, this.annotatedElement, this.buildUniqueConstraintIndexedDeclarationAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildUniqueConstraintIndexedDeclarationAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, this.getUniqueConstraintsElementName(), index, "javax.persistence.UniqueConstraint");
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.uniqueConstraintsContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeUniqueConstraint(int index) {
        this.uniqueConstraintsContainer.removeNestedAnnotation(index);
    }

    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.schema == null && this.catalog == null && this.uniqueConstraintsContainer.isEmpty();
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UniqueConstraintsAnnotationContainer
    extends SourceAnnotation.AnnotationContainer<UniqueConstraintAnnotation> {
        UniqueConstraintsAnnotationContainer() {
            super((SourceAnnotation)SourceBaseTableAnnotation.this);
        }

        protected String getAnnotationsPropertyName() {
            return "uniqueConstraints";
        }

        protected String getElementName() {
            return SourceBaseTableAnnotation.this.getUniqueConstraintsElementName();
        }

        protected String getNestedAnnotationName() {
            return "javax.persistence.UniqueConstraint";
        }

        protected UniqueConstraintAnnotation buildNestedAnnotation(int index) {
            return SourceBaseTableAnnotation.this.buildUniqueConstraint(index);
        }
    }
}

