/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceBaseTableAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinTableAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceJoinTableAnnotation
extends SourceBaseTableAnnotation
implements JoinTableAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinTable");
    private final JoinColumnsAnnotationContainer joinColumnsContainer = new JoinColumnsAnnotationContainer();
    private final InverseJoinColumnsAnnotationContainer inverseJoinColumnsContainer = new InverseJoinColumnsAnnotationContainer();

    public SourceJoinTableAnnotation(JavaResourceNode parent, AnnotatedElement element) {
        this(parent, element, DECLARATION_ANNOTATION_ADAPTER);
    }

    public SourceJoinTableAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super(parent, element, daa);
    }

    public String getAnnotationName() {
        return "javax.persistence.JoinTable";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.joinColumnsContainer.initialize(this.getAstAnnotation(astRoot));
        this.inverseJoinColumnsContainer.initialize(this.getAstAnnotation(astRoot));
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.joinColumnsContainer.synchronize(this.getAstAnnotation(astRoot));
        this.inverseJoinColumnsContainer.synchronize(this.getAstAnnotation(astRoot));
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"name");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> buildSchemaDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"schema");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> buildCatalogDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"catalog");
    }

    @Override
    protected String getUniqueConstraintsElementName() {
        return "uniqueConstraints";
    }

    @Override
    public ListIterable<JoinColumnAnnotation> getJoinColumns() {
        return this.joinColumnsContainer.getNestedAnnotations();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.joinColumnsContainer.getNestedAnnotationsSize();
    }

    @Override
    public JoinColumnAnnotation joinColumnAt(int index) {
        return (JoinColumnAnnotation)this.joinColumnsContainer.nestedAnnotationAt(index);
    }

    @Override
    public JoinColumnAnnotation addJoinColumn(int index) {
        return (JoinColumnAnnotation)this.joinColumnsContainer.addNestedAnnotation(index);
    }

    private JoinColumnAnnotation buildJoinColumn(int index) {
        return SourceJoinColumnAnnotation.buildNestedSourceJoinColumnAnnotation((JavaResourceNode)this, this.annotatedElement, this.buildJoinColumnIndexedDeclarationAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildJoinColumnIndexedDeclarationAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, "joinColumns", index, "javax.persistence.JoinColumn");
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        this.joinColumnsContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeJoinColumn(int index) {
        this.joinColumnsContainer.removeNestedAnnotation(index);
    }

    @Override
    public ListIterable<JoinColumnAnnotation> getInverseJoinColumns() {
        return this.inverseJoinColumnsContainer.getNestedAnnotations();
    }

    @Override
    public int getInverseJoinColumnsSize() {
        return this.inverseJoinColumnsContainer.getNestedAnnotationsSize();
    }

    @Override
    public JoinColumnAnnotation inverseJoinColumnAt(int index) {
        return (JoinColumnAnnotation)this.inverseJoinColumnsContainer.nestedAnnotationAt(index);
    }

    @Override
    public JoinColumnAnnotation addInverseJoinColumn(int index) {
        return (JoinColumnAnnotation)this.inverseJoinColumnsContainer.addNestedAnnotation(index);
    }

    private JoinColumnAnnotation buildInverseJoinColumn(int index) {
        return SourceJoinColumnAnnotation.buildNestedSourceJoinColumnAnnotation((JavaResourceNode)this, this.annotatedElement, this.buildInverseJoinColumnIndexedDeclarationAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildInverseJoinColumnIndexedDeclarationAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, "inverseJoinColumns", index, "javax.persistence.JoinColumn");
    }

    @Override
    public void moveInverseJoinColumn(int targetIndex, int sourceIndex) {
        this.inverseJoinColumnsContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeInverseJoinColumn(int index) {
        this.inverseJoinColumnsContainer.removeNestedAnnotation(index);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.joinColumnsContainer.isEmpty() && this.inverseJoinColumnsContainer.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InverseJoinColumnsAnnotationContainer
    extends SourceAnnotation.AnnotationContainer<JoinColumnAnnotation> {
        InverseJoinColumnsAnnotationContainer() {
            super((SourceAnnotation)SourceJoinTableAnnotation.this);
        }

        protected String getAnnotationsPropertyName() {
            return "inverseJoinColumns";
        }

        protected String getElementName() {
            return "inverseJoinColumns";
        }

        protected String getNestedAnnotationName() {
            return "javax.persistence.JoinColumn";
        }

        protected JoinColumnAnnotation buildNestedAnnotation(int index) {
            return SourceJoinTableAnnotation.this.buildInverseJoinColumn(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JoinColumnsAnnotationContainer
    extends SourceAnnotation.AnnotationContainer<JoinColumnAnnotation> {
        JoinColumnsAnnotationContainer() {
            super((SourceAnnotation)SourceJoinTableAnnotation.this);
        }

        protected String getAnnotationsPropertyName() {
            return "joinColumns";
        }

        protected String getElementName() {
            return "joinColumns";
        }

        protected String getNestedAnnotationName() {
            return "javax.persistence.JoinColumn";
        }

        protected JoinColumnAnnotation buildNestedAnnotation(int index) {
            return SourceJoinTableAnnotation.this.buildJoinColumn(index);
        }
    }
}

