/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceRelationshipMappingAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.ManyToOne2_0Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceManyToOneAnnotation
extends SourceRelationshipMappingAnnotation
implements ManyToOne2_0Annotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.ManyToOne");
    private static final DeclarationAnnotationElementAdapter<String> TARGET_ENTITY_ADAPTER = SourceManyToOneAnnotation.buildTargetEntityAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceManyToOneAnnotation.buildFetchAdapter();
    private static final DeclarationAnnotationElementAdapter<String[]> CASCADE_ADAPTER = SourceManyToOneAnnotation.buildCascadeAdapter();
    private static final DeclarationAnnotationElementAdapter<Boolean> OPTIONAL_ADAPTER = SourceManyToOneAnnotation.buildOptionalAdapter();
    private final AnnotationElementAdapter<Boolean> optionalAdapter = this.buildBooleanAnnotationElementAdapter(OPTIONAL_ADAPTER);
    private Boolean optional;

    public SourceManyToOneAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super(parent, element, DECLARATION_ANNOTATION_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.persistence.ManyToOne";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.optional = this.buildOptional(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncOptional(this.buildOptional(astRoot));
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.optional == null;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getTargetEntityAdapter() {
        return TARGET_ENTITY_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getFetchAdapter() {
        return FETCH_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String[]> getCascadeAdapter() {
        return CASCADE_ADAPTER;
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        if (this.attributeValueHasChanged(this.optional, optional)) {
            this.optional = optional;
            this.optionalAdapter.setValue((Object)optional);
        }
    }

    private void syncOptional(Boolean astOptional) {
        Boolean old = this.optional;
        this.optional = astOptional;
        this.firePropertyChanged("optional", old, astOptional);
    }

    private Boolean buildOptional(CompilationUnit astRoot) {
        return (Boolean)this.optionalAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getOptionalTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(OPTIONAL_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter() {
        return SourceManyToOneAnnotation.buildTargetEntityAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetEntity");
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return SourceManyToOneAnnotation.buildFetchAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter() {
        return SourceManyToOneAnnotation.buildOptionalAdapter(DECLARATION_ANNOTATION_ADAPTER, "optional");
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildCascadeAdapter() {
        return SourceManyToOneAnnotation.buildEnumArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "cascade");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, BooleanExpressionConverter.instance());
    }
}

