/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceQueryAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceQueryHintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceNamedNativeQueryAnnotation
extends SourceQueryAnnotation
implements NamedNativeQueryAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.NamedNativeQuery");
    private static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.NamedNativeQueries");
    private DeclarationAnnotationElementAdapter<String> resultClassDeclarationAdapter = this.buildResultClassDeclarationAdapter();
    private AnnotationElementAdapter<String> resultClassAdapter = this.buildResultClassAdapter();
    private String resultClass;
    private String fullyQualifiedResultClassName;
    private boolean fqResultClassNameStale = true;
    private DeclarationAnnotationElementAdapter<String> resultSetMappingDeclarationAdapter;
    private AnnotationElementAdapter<String> resultSetMappingAdapter;
    private String resultSetMapping;

    public static SourceNamedNativeQueryAnnotation buildSourceNamedNativeQueryAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, int index) {
        IndexedDeclarationAnnotationAdapter idaa = SourceNamedNativeQueryAnnotation.buildNamedNativeQueryDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = SourceNamedNativeQueryAnnotation.buildNamedNativeQueryAnnotationAdapter(element, idaa);
        return new SourceNamedNativeQueryAnnotation(parent, element, idaa, iaa);
    }

    private SourceNamedNativeQueryAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter daa, IndexedAnnotationAdapter annotationAdapter) {
        super((JavaResourceNode)parent, element, (DeclarationAnnotationAdapter)daa, (AnnotationAdapter)annotationAdapter);
        this.resultSetMappingDeclarationAdapter = this.buildResultSetMappingAdapter((DeclarationAnnotationAdapter)daa);
        this.resultSetMappingAdapter = this.buildResultSetMappingAdapter();
    }

    public String getAnnotationName() {
        return "javax.persistence.NamedNativeQuery";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.resultClass = this.buildResultClass(astRoot);
        this.resultSetMapping = this.buildResultSetMapping(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncResultClass(this.buildResultClass(astRoot));
        this.syncResultSetMapping(this.buildResultSetMapping(astRoot));
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    String getQueryElementName() {
        return "query";
    }

    @Override
    String getHintsElementName() {
        return "hints";
    }

    @Override
    QueryHintAnnotation buildHint(int index) {
        return SourceQueryHintAnnotation.buildNamedNativeQueryQueryHint((JavaResourceNode)this, this.annotatedElement, this.daa, index);
    }

    @Override
    public String getResultClass() {
        return this.resultClass;
    }

    @Override
    public void setResultClass(String resultClass) {
        if (this.attributeValueHasChanged(this.resultClass, resultClass)) {
            this.resultClass = resultClass;
            this.fqResultClassNameStale = true;
            this.resultClassAdapter.setValue((Object)resultClass);
        }
    }

    private void syncResultClass(String astResultClass) {
        if (this.attributeValueHasChanged(this.resultClass, astResultClass)) {
            this.syncResultClass_(astResultClass);
        }
    }

    private void syncResultClass_(String astResultClass) {
        String old = this.resultClass;
        this.resultClass = astResultClass;
        this.fqResultClassNameStale = true;
        this.firePropertyChanged("resultClass", old, astResultClass);
    }

    private String buildResultClass(CompilationUnit astRoot) {
        return (String)this.resultClassAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getResultClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.resultClassDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildResultClassDeclarationAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, "resultClass", SimpleTypeStringExpressionConverter.instance());
    }

    private AnnotationElementAdapter<String> buildResultClassAdapter() {
        return this.buildStringElementAdapter(this.resultClassDeclarationAdapter);
    }

    @Override
    public String getFullyQualifiedResultClassName() {
        if (this.fqResultClassNameStale) {
            this.fullyQualifiedResultClassName = this.buildFullyQualifiedResultClassName();
            this.fqResultClassNameStale = false;
        }
        return this.fullyQualifiedResultClassName;
    }

    private String buildFullyQualifiedResultClassName() {
        return this.resultClass == null ? null : this.buildFullyQualifiedResultClassName_();
    }

    private String buildFullyQualifiedResultClassName_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.resultClassAdapter.getExpression(this.buildASTRoot()));
    }

    @Override
    public String getResultSetMapping() {
        return this.resultSetMapping;
    }

    @Override
    public void setResultSetMapping(String resultSetMapping) {
        if (this.attributeValueHasChanged(this.resultSetMapping, resultSetMapping)) {
            this.resultSetMapping = resultSetMapping;
            this.resultSetMappingAdapter.setValue((Object)resultSetMapping);
        }
    }

    private void syncResultSetMapping(String astResultSetMapping) {
        String old = this.resultSetMapping;
        this.resultSetMapping = astResultSetMapping;
        this.firePropertyChanged("resultSetMapping", old, astResultSetMapping);
    }

    private String buildResultSetMapping(CompilationUnit astRoot) {
        return (String)this.resultSetMappingAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getResultSetMappingTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.resultSetMappingDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildResultSetMappingAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"resultSetMapping");
    }

    private AnnotationElementAdapter<String> buildResultSetMappingAdapter() {
        return this.buildStringElementAdapter(this.resultSetMappingDeclarationAdapter);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.resultClass == null && this.resultSetMapping == null;
    }

    private static IndexedAnnotationAdapter buildNamedNativeQueryAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    private static IndexedDeclarationAnnotationAdapter buildNamedNativeQueryDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "javax.persistence.NamedNativeQuery");
        return idaa;
    }
}

