/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.details.orm;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.OrmEclipseLinkConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkCustomConverterComposite;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkObjectTypeConverterComposite;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkStructConverterComposite;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkTypeConverterComposite;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.orm.EclipseLinkConverterDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmEclipseLinkConvertersComposite
extends Pane<OrmEclipseLinkConverterContainer> {
    private AddRemoveListPane<OrmEclipseLinkConverterContainer> listPane;
    private EclipseLinkCustomConverterComposite converterComposite;
    private EclipseLinkObjectTypeConverterComposite objectTypeConverterComposite;
    private EclipseLinkStructConverterComposite structConverterComposite;
    private EclipseLinkTypeConverterComposite typeConverterComposite;
    private WritablePropertyValueModel<EclipseLinkConverter> selectedConverterHolder;

    public OrmEclipseLinkConvertersComposite(Pane<?> parentPane, PropertyValueModel<? extends OrmEclipseLinkConverterContainer> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent, false);
    }

    protected void initialize() {
        super.initialize();
        this.selectedConverterHolder = this.buildSelectedConverterHolder();
    }

    private WritablePropertyValueModel<EclipseLinkConverter> buildSelectedConverterHolder() {
        return new SimplePropertyValueModel();
    }

    protected void initializeLayout(Composite container) {
        this.listPane = this.addListPane(container);
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.converterComposite = new EclipseLinkCustomConverterComposite(this.buildCustomConverterHolder(), (Composite)pageBook, this.getWidgetFactory());
        this.registerSubPane(this.converterComposite);
        this.objectTypeConverterComposite = new EclipseLinkObjectTypeConverterComposite(this.buildObjectTypeConverterHolder(), (Composite)pageBook, this.getWidgetFactory());
        this.registerSubPane(this.objectTypeConverterComposite);
        this.structConverterComposite = new EclipseLinkStructConverterComposite(this.buildStructConverterHolder(), (Composite)pageBook, this.getWidgetFactory());
        this.registerSubPane(this.structConverterComposite);
        this.typeConverterComposite = new EclipseLinkTypeConverterComposite(this.buildTypeConverterHolder(), (Composite)pageBook, this.getWidgetFactory());
        this.registerSubPane(this.typeConverterComposite);
        this.installPaneSwitcher(pageBook);
    }

    private AddRemoveListPane<OrmEclipseLinkConverterContainer> addListPane(Composite container) {
        return new AddRemoveListPane<OrmEclipseLinkConverterContainer>((Pane)this, container, this.buildConvertersAdapter(), this.buildDisplayableConvertersListHolder(), this.selectedConverterHolder, this.buildConvertersListLabelProvider(), null){

            public void enableWidgets(boolean enabled) {
                super.enableWidgets(true);
            }
        };
    }

    private void installPaneSwitcher(PageBook pageBook) {
        new ControlSwitcher(this.selectedConverterHolder, this.buildPaneTransformer(), pageBook);
    }

    private AddRemovePane.Adapter buildConvertersAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                OrmEclipseLinkConvertersComposite.this.addConverter();
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (((EclipseLinkConverter)item).getType() == EclipseLinkCustomConverter.class) {
                        ((OrmEclipseLinkConverterContainer)OrmEclipseLinkConvertersComposite.this.getSubject()).removeCustomConverter((EclipseLinkCustomConverter)item);
                    } else if (((EclipseLinkConverter)item).getType() == EclipseLinkObjectTypeConverter.class) {
                        ((OrmEclipseLinkConverterContainer)OrmEclipseLinkConvertersComposite.this.getSubject()).removeObjectTypeConverter((EclipseLinkObjectTypeConverter)item);
                    } else if (((EclipseLinkConverter)item).getType() == EclipseLinkStructConverter.class) {
                        ((OrmEclipseLinkConverterContainer)OrmEclipseLinkConvertersComposite.this.getSubject()).removeStructConverter((EclipseLinkStructConverter)item);
                    } else if (((EclipseLinkConverter)item).getType() == EclipseLinkTypeConverter.class) {
                        ((OrmEclipseLinkConverterContainer)OrmEclipseLinkConvertersComposite.this.getSubject()).removeTypeConverter((EclipseLinkTypeConverter)item);
                    }
                    ++n2;
                }
            }
        };
    }

    private void addConverter() {
        this.addEclipseLinkConverterFromDialog(this.buildEclipseLinkConverterDialog());
    }

    protected EclipseLinkConverterDialog buildEclipseLinkConverterDialog() {
        return new EclipseLinkConverterDialog(this.getShell(), (EclipseLinkPersistenceUnit)((OrmEclipseLinkConverterContainer)this.getSubject()).getPersistenceUnit());
    }

    protected void addEclipseLinkConverterFromDialog(EclipseLinkConverterDialog dialog) {
        EclipseLinkCustomConverter converter;
        if (dialog.open() != 0) {
            return;
        }
        Class<? extends EclipseLinkConverter> converterType = dialog.getConverterType();
        if (converterType == EclipseLinkCustomConverter.class) {
            converter = ((OrmEclipseLinkConverterContainer)this.getSubject()).addCustomConverter(((OrmEclipseLinkConverterContainer)this.getSubject()).getCustomConvertersSize());
        } else if (converterType == EclipseLinkObjectTypeConverter.class) {
            converter = ((OrmEclipseLinkConverterContainer)this.getSubject()).addObjectTypeConverter(((OrmEclipseLinkConverterContainer)this.getSubject()).getObjectTypeConvertersSize());
        } else if (converterType == EclipseLinkStructConverter.class) {
            converter = ((OrmEclipseLinkConverterContainer)this.getSubject()).addStructConverter(((OrmEclipseLinkConverterContainer)this.getSubject()).getStructConvertersSize());
        } else if (converterType == EclipseLinkTypeConverter.class) {
            converter = ((OrmEclipseLinkConverterContainer)this.getSubject()).addTypeConverter(((OrmEclipseLinkConverterContainer)this.getSubject()).getTypeConvertersSize());
        } else {
            throw new IllegalArgumentException();
        }
        converter.setName(dialog.getName());
        this.selectedConverterHolder.setValue((Object)converter);
    }

    private Transformer<EclipseLinkConverter, Control> buildPaneTransformer() {
        return new Transformer<EclipseLinkConverter, Control>(){

            public Control transform(EclipseLinkConverter converter) {
                if (converter == null) {
                    return null;
                }
                if (converter.getType() == EclipseLinkCustomConverter.class) {
                    return OrmEclipseLinkConvertersComposite.this.converterComposite.getControl();
                }
                if (converter.getType() == EclipseLinkObjectTypeConverter.class) {
                    return OrmEclipseLinkConvertersComposite.this.objectTypeConverterComposite.getControl();
                }
                if (converter.getType() == EclipseLinkStructConverter.class) {
                    return OrmEclipseLinkConvertersComposite.this.structConverterComposite.getControl();
                }
                if (converter.getType() == EclipseLinkTypeConverter.class) {
                    return OrmEclipseLinkConvertersComposite.this.typeConverterComposite.getControl();
                }
                return null;
            }
        };
    }

    private ListValueModel<EclipseLinkConverter> buildDisplayableConvertersListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildEclipseLinkConvertersHolder(), new String[]{"name"});
    }

    private ListValueModel<EclipseLinkConverter> buildEclipseLinkConvertersHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildCustomConvertersListHolder());
        list.add(this.buildObjectTypeConvertersListHolder());
        list.add(this.buildStructConvertersListHolder());
        list.add(this.buildTypeConvertersListHolder());
        return new CompositeListValueModel(list);
    }

    private ListValueModel<EclipseLinkCustomConverter> buildCustomConvertersListHolder() {
        return new ListAspectAdapter<OrmEclipseLinkConverterContainer, EclipseLinkCustomConverter>(this.getSubjectHolder(), new String[]{"customConverters"}){

            protected ListIterable<EclipseLinkCustomConverter> getListIterable() {
                return new SuperListIterableWrapper(((OrmEclipseLinkConverterContainer)this.subject).getCustomConverters());
            }

            protected int size_() {
                return ((OrmEclipseLinkConverterContainer)this.subject).getCustomConvertersSize();
            }
        };
    }

    private ListValueModel<EclipseLinkObjectTypeConverter> buildObjectTypeConvertersListHolder() {
        return new ListAspectAdapter<OrmEclipseLinkConverterContainer, EclipseLinkObjectTypeConverter>(this.getSubjectHolder(), new String[]{"objectTypeConverters"}){

            protected ListIterable<EclipseLinkObjectTypeConverter> getListIterable() {
                return new SuperListIterableWrapper(((OrmEclipseLinkConverterContainer)this.subject).getObjectTypeConverters());
            }

            protected int size_() {
                return ((OrmEclipseLinkConverterContainer)this.subject).getObjectTypeConvertersSize();
            }
        };
    }

    private ListValueModel<EclipseLinkStructConverter> buildStructConvertersListHolder() {
        return new ListAspectAdapter<OrmEclipseLinkConverterContainer, EclipseLinkStructConverter>(this.getSubjectHolder(), new String[]{"structConverters"}){

            protected ListIterable<EclipseLinkStructConverter> getListIterable() {
                return new SuperListIterableWrapper(((OrmEclipseLinkConverterContainer)this.subject).getStructConverters());
            }

            protected int size_() {
                return ((OrmEclipseLinkConverterContainer)this.subject).getStructConvertersSize();
            }
        };
    }

    private ListValueModel<EclipseLinkTypeConverter> buildTypeConvertersListHolder() {
        return new ListAspectAdapter<OrmEclipseLinkConverterContainer, EclipseLinkTypeConverter>(this.getSubjectHolder(), new String[]{"typeConverters"}){

            protected ListIterable<EclipseLinkTypeConverter> getListIterable() {
                return new SuperListIterableWrapper(((OrmEclipseLinkConverterContainer)this.subject).getTypeConverters());
            }

            protected int size_() {
                return ((OrmEclipseLinkConverterContainer)this.subject).getTypeConvertersSize();
            }
        };
    }

    private PropertyValueModel<EclipseLinkCustomConverter> buildCustomConverterHolder() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, EclipseLinkCustomConverter>(this.selectedConverterHolder){

            protected EclipseLinkCustomConverter transform_(EclipseLinkConverter value) {
                return value.getType() == EclipseLinkCustomConverter.class ? (EclipseLinkCustomConverter)value : null;
            }
        };
    }

    private PropertyValueModel<EclipseLinkObjectTypeConverter> buildObjectTypeConverterHolder() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, EclipseLinkObjectTypeConverter>(this.selectedConverterHolder){

            protected EclipseLinkObjectTypeConverter transform_(EclipseLinkConverter value) {
                return value.getType() == EclipseLinkObjectTypeConverter.class ? (EclipseLinkObjectTypeConverter)value : null;
            }
        };
    }

    private PropertyValueModel<EclipseLinkStructConverter> buildStructConverterHolder() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, EclipseLinkStructConverter>(this.selectedConverterHolder){

            protected EclipseLinkStructConverter transform_(EclipseLinkConverter value) {
                return value.getType() == EclipseLinkStructConverter.class ? (EclipseLinkStructConverter)value : null;
            }
        };
    }

    private PropertyValueModel<EclipseLinkTypeConverter> buildTypeConverterHolder() {
        return new TransformationPropertyValueModel<EclipseLinkConverter, EclipseLinkTypeConverter>(this.selectedConverterHolder){

            protected EclipseLinkTypeConverter transform_(EclipseLinkConverter value) {
                return value.getType() == EclipseLinkTypeConverter.class ? (EclipseLinkTypeConverter)value : null;
            }
        };
    }

    private ILabelProvider buildConvertersListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((EclipseLinkConverter)element).getName();
            }
        };
    }

    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.listPane.enableWidgets(enabled);
    }

    private Iterator<String> converterNames() {
        return new TransformationIterator<EclipseLinkCustomConverter, String>((Iterable)((OrmEclipseLinkConverterContainer)this.getSubject()).getCustomConverters()){

            protected String transform(EclipseLinkCustomConverter next) {
                return next.getName();
            }
        };
    }
}

