/*******************************************************************************
 * Copyright (c) 2008 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.common.ui.jface;

/**
 * Marker interface used in conjunction with DelegatingContentProvider to return 
 * content information for a particular item.
 * @see DelegatingContentProvider
 * @see ItemContentProviderFactory
 * 
 * Provisional API: This interface is part of an interim API that is still
 * under development and expected to change significantly before reaching
 * stability. It is available at this early stage to solicit feedback from
 * pioneering adopters on the understanding that any code that uses this API
 * will almost certainly be broken (repeatedly) as the API evolves.
 */
public interface ItemContentProvider
{
	/**
	 * Return the elements of the represented item.
	 * Note that when this is called, the represented item is an input element.
	 */
	Object[] getElements();
	
	/**
	 * Dispose of this content provider, cleaning up all references, listeners, etc.
	 */
	void dispose();
}
