/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature;

import java.util.Date;
import java.util.List;
import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RefactorAttributeTypeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RefactorAttributeTypeFeatureTest {
    private IJPAEditorFeatureProvider featureProvider;
    private ICustomContext context;
    final String TEST_PROJECT = "Test" + new Date().getTime();
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    private IFile entity;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject(String.valueOf(this.TEST_PROJECT) + "_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        this.entity = this.factory.createEntity(this.jpaProject, "org.eclipse.Ent");
        Thread.sleep(2000L);
        this.factory.addAttributes(this.entity, "att", "java.lang.String", "", "att", false);
    }

    @Test
    public void testRefactorAttributeTypeFeature() {
        PictogramElement[] elements = new PictogramElement[1];
        PictogramElement element = (PictogramElement)EasyMock.createNiceMock(PictogramElement.class);
        EasyMock.replay((Object[])new Object[]{element});
        elements[0] = element;
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement(element)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.featureProvider});
        this.context = (ICustomContext)EasyMock.createMock(ICustomContext.class);
        EasyMock.expect((Object)this.context.getPictogramElements()).andReturn((Object)elements);
        EasyMock.replay((Object[])new Object[]{this.context});
        RefactorAttributeTypeFeature feature = new RefactorAttributeTypeFeature((IFeatureProvider)this.featureProvider);
        feature.execute(this.context);
    }

    @Test
    public void testAttributeUtils() {
        PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(this.jpaProject);
        JavaPersistentType jpt = (JavaPersistentType)pu.getPersistentType("org.eclipse.Ent");
        JavaPersistentAttribute at = jpt.getAttributeNamed("id");
        List lst = JpaArtifactFactory.instance().getAnnotationStrings(at);
        Assert.assertEquals((long)1L, (long)lst.size());
        Assert.assertTrue((boolean)lst.contains("@Id"));
        String typeName1 = JPAEditorUtil.getAttributeTypeName((JavaPersistentAttribute)at);
        Assert.assertEquals((Object)"int", (Object)typeName1);
        String typeName2 = JPAEditorUtil.getAttributeTypeName((JavaResourceAttribute)at.getResourceAttribute());
        Assert.assertEquals((Object)"int", (Object)typeName2);
    }
}

