/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.provider;

import org.easymock.EasyMock;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ClickRemoveAttributeButtonFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.DeleteJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.DeleteRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJpaSolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JPAEditorFeatureProviderTest {
    private IJpaSolver solver;
    private String businessObjectKey;

    @Before
    public void setUp() throws Exception {
        this.solver = (IJpaSolver)EasyMock.createMock(IJpaSolver.class);
        this.businessObjectKey = "someValue";
    }

    @Test
    public void testAttributesGroupDeleteFeature() {
        PictogramElement pe = this.replayPictogramElement();
        EasyMock.expect((Object)this.solver.getBusinessObjectForKey(this.businessObjectKey)).andReturn(new Object());
        IJPAEditorFeatureProvider provider = this.createFeatureProvider();
        IDeleteContext context = this.replayDeleteContext(pe);
        Assert.assertNull((Object)provider.getDeleteFeature(context));
    }

    @Test
    public void testAttributeDeleteFeature() {
        PictogramElement pe = this.replayPictogramElement();
        JavaPersistentAttribute jpa = this.replayAttribute();
        EasyMock.expect((Object)this.solver.getBusinessObjectForKey(this.businessObjectKey)).andStubReturn((Object)jpa);
        IJPAEditorFeatureProvider provider = this.createFeatureProvider();
        IDeleteContext context = this.replayDeleteContext(pe);
        Assert.assertNotNull((Object)provider.getDeleteFeature(context));
        IDeleteFeature feature = provider.getDeleteFeature(context);
        Assert.assertTrue((boolean)(feature instanceof ClickRemoveAttributeButtonFeature));
    }

    @Test
    public void testEntityDeleteFeature() {
        PictogramElement pe = this.replayPictogramElement();
        JavaPersistentType jpt = this.replayJPT("TestEntity");
        EasyMock.expect((Object)this.solver.getBusinessObjectForKey(this.businessObjectKey)).andStubReturn((Object)jpt);
        IJPAEditorFeatureProvider provider = this.createFeatureProvider();
        IDeleteContext context = this.replayDeleteContext(pe);
        Assert.assertNotNull((Object)provider.getDeleteFeature(context));
        IDeleteFeature deleteFeature = provider.getDeleteFeature(context);
        Assert.assertTrue((boolean)(deleteFeature instanceof DeleteJPAEntityFeature));
    }

    @Test
    public void testRelationDeleteFeature() {
        PictogramElement pe = this.replayPictogramElement();
        JavaPersistentType jpt1 = this.replayJPT("TestEntity1");
        JavaPersistentType jpt2 = this.replayJPT("TestEntity2");
        IJPAEditorFeatureProvider provider = this.createFeatureProvider();
        ManyToManyUniDirRelation relation = new ManyToManyUniDirRelation(provider, jpt1, jpt2, "attribute1", false, null, null);
        EasyMock.expect((Object)this.solver.getBusinessObjectForKey(this.businessObjectKey)).andStubReturn((Object)relation);
        IDeleteContext context = this.replayDeleteContext(pe);
        Assert.assertNotNull((Object)provider.getDeleteFeature(context));
        IDeleteFeature deleteFeature = provider.getDeleteFeature(context);
        Assert.assertTrue((boolean)(deleteFeature instanceof DeleteRelationFeature));
    }

    private JavaPersistentType replayJPT(String name) {
        JavaPersistentType jpt = (JavaPersistentType)EasyMock.createMock(JavaPersistentType.class);
        EasyMock.expect((Object)jpt.getName()).andReturn((Object)name);
        EasyMock.replay((Object[])new Object[]{jpt});
        return jpt;
    }

    private JavaPersistentAttribute replayAttribute() {
        JavaPersistentAttribute attribute = (JavaPersistentAttribute)EasyMock.createMock(JavaPersistentAttribute.class);
        EasyMock.expect((Object)attribute.getName()).andReturn((Object)"attribute");
        EasyMock.replay((Object[])new Object[]{attribute});
        return attribute;
    }

    private PictogramElement replayPictogramElement() {
        PictogramElement pe = (PictogramElement)EasyMock.createMock(PictogramElement.class);
        Resource r = (Resource)EasyMock.createMock(Resource.class);
        EasyMock.expect((Object)pe.eResource()).andStubReturn((Object)r);
        EList properties = (EList)EasyMock.createMock(EList.class);
        Property prop = (Property)EasyMock.createMock(Property.class);
        EasyMock.expect((Object)prop.getKey()).andStubReturn((Object)"independentObject");
        EasyMock.expect((Object)prop.getValue()).andStubReturn((Object)this.businessObjectKey);
        EasyMock.replay((Object[])new Object[]{prop, r});
        properties.add((Object)prop);
        EasyMock.expect((Object)pe.getProperties()).andStubReturn((Object)properties);
        EasyMock.replay((Object[])new Object[]{pe});
        return pe;
    }

    private IJPAEditorFeatureProvider createFeatureProvider() {
        IDiagramTypeProvider dtp = (IDiagramTypeProvider)EasyMock.createMock(IDiagramTypeProvider.class);
        EasyMock.replay((Object[])new Object[]{dtp});
        this.solver.setFeatureProvider((IJPAEditorFeatureProvider)EasyMock.isA(IJPAEditorFeatureProvider.class));
        EasyMock.replay((Object[])new Object[]{this.solver});
        IJPAEditorFeatureProvider provider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)provider.getDiagramTypeProvider()).andStubReturn((Object)dtp);
        EasyMock.replay((Object[])new Object[]{provider});
        return provider;
    }

    private IDeleteContext replayDeleteContext(PictogramElement pe) {
        IDeleteContext context = (IDeleteContext)EasyMock.createMock(IDeleteContext.class);
        EasyMock.expect((Object)context.getPictogramElement()).andStubReturn((Object)pe);
        EasyMock.replay((Object[])new Object[]{context});
        return context;
    }
}

