/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.provider;

import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.JPAEditorToolBehaviorProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IStaticIDE;
import org.eclipse.ui.PartInitException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JPAEditorToolBehaviorProviderTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testGetRenderingDecoratorsPictogramElementError() throws Exception {
        PictogramElement pe = this.replayPictogramElement(100, 100);
        IMarker marker = this.replayMarker(2, "Error message");
        JavaPersistentType jpt = this.replayJptWithMarker(new IMarker[]{marker});
        IDiagramTypeProvider dtp = this.replayDiagramProvider(pe, jpt);
        JPAEditorToolBehaviorProvider provider = new JPAEditorToolBehaviorProvider(dtp);
        IDecorator[] decorators = provider.getDecorators(pe);
        Assert.assertEquals((long)1L, (long)decorators.length);
        Assert.assertEquals((Object)"Error message", (Object)decorators[0].getMessage());
    }

    @Test
    public void testGetRenderingDecoratorsPictogramElementWarning() throws Exception {
        PictogramElement pe = this.replayPictogramElement(100, 100);
        IMarker marker = this.replayMarker(1, "Warning message");
        JavaPersistentType jpt = this.replayJptWithMarker(new IMarker[]{marker});
        IDiagramTypeProvider dtp = this.replayDiagramProvider(pe, jpt);
        JPAEditorToolBehaviorProvider provider = new JPAEditorToolBehaviorProvider(dtp);
        IDecorator[] decorators = provider.getDecorators(pe);
        Assert.assertEquals((long)1L, (long)decorators.length);
        Assert.assertEquals((Object)"Warning message", (Object)decorators[0].getMessage());
    }

    @Test
    public void testGetRenderingDecoratorsPictogramElementInfo() throws Exception {
        PictogramElement pe = this.replayPictogramElement(100, 100);
        IMarker marker = this.replayMarker(0, "Info message");
        JavaPersistentType jpt = this.replayJptWithMarker(new IMarker[]{marker});
        IDiagramTypeProvider dtp = this.replayDiagramProvider(pe, jpt);
        JPAEditorToolBehaviorProvider provider = new JPAEditorToolBehaviorProvider(dtp);
        IDecorator[] decorators = provider.getDecorators(pe);
        Assert.assertEquals((long)1L, (long)decorators.length);
        Assert.assertEquals((Object)"Info message", (Object)decorators[0].getMessage());
    }

    @Test
    public void testGetRenderingDecoratorsPictogramElementNoMarkers() throws Exception {
        PictogramElement pe = this.replayPictogramElement(100, 100);
        JavaPersistentType jpt = this.replayJptWithMarker(new IMarker[0]);
        IDiagramTypeProvider dtp = this.replayDiagramProvider(pe, jpt);
        JPAEditorToolBehaviorProvider provider = new JPAEditorToolBehaviorProvider(dtp);
        IDecorator[] decorators = provider.getDecorators(pe);
        Assert.assertEquals((long)0L, (long)decorators.length);
    }

    @Test
    public void testGetRenderingDecoratorsPictogramElementTwoMarkers() throws Exception {
        PictogramElement pe = this.replayPictogramElement(100, 100);
        IMarker warningMarker = this.replayMarker(1, "warning");
        IMarker errorMarker = this.replayMarker(2, "error");
        JavaPersistentType jpt = this.replayJptWithMarker(new IMarker[]{errorMarker, warningMarker});
        IDiagramTypeProvider dtp = this.replayDiagramProvider(pe, jpt);
        JPAEditorToolBehaviorProvider provider = new JPAEditorToolBehaviorProvider(dtp);
        IDecorator[] decorators = provider.getDecorators(pe);
        Assert.assertEquals((long)1L, (long)decorators.length);
        Assert.assertEquals((Object)"error", (Object)decorators[0].getMessage());
    }

    @Test
    public void testGetRenderingDecoratorsPictogramElementLocation() throws Exception {
        PictogramElement pe = this.replayPictogramElement(100, 100);
        IMarker marker = this.replayMarker(2, "Error message");
        JavaPersistentType jpt = this.replayJptWithMarker(new IMarker[]{marker});
        IDiagramTypeProvider dtp = this.replayDiagramProvider(pe, jpt);
        JPAEditorToolBehaviorProvider provider = new JPAEditorToolBehaviorProvider(dtp);
        IDecorator[] decorators = provider.getDecorators(pe);
        Assert.assertEquals((long)1L, (long)decorators.length);
        Assert.assertEquals((long)80L, (long)((ImageDecorator)decorators[0]).getX());
        Assert.assertEquals((long)80L, (long)((ImageDecorator)decorators[0]).getY());
    }

    @Test
    public void testGetDoubleClickOnJptFeature() throws PartInitException, CoreException {
        PictogramElement pe = this.replayPictogramElement(100, 100);
        IFile file = this.replayResource();
        JavaPersistentType jpt = this.replayJpt(pe, file);
        IDiagramTypeProvider dtp = this.replayDiagramProvider(pe, jpt);
        IEclipseFacade facade = (IEclipseFacade)EasyMock.createMock(IEclipseFacade.class);
        IStaticIDE ide = (IStaticIDE)EasyMock.createMock(IStaticIDE.class);
        EasyMock.expect((Object)facade.getIDE()).andStubReturn((Object)ide);
        ide.openEditor(file);
        EasyMock.replay((Object[])new Object[]{facade, ide});
        JPAEditorToolBehaviorProvider provider = new JPAEditorToolBehaviorProvider(dtp, facade);
        IDoubleClickContext context = this.replayDoubleClickContext(pe);
        provider.getDoubleClickFeature(context);
        EasyMock.verify((Object[])new Object[]{ide});
    }

    @Test
    public void testGetDoubleClickOnJpaFeature() throws Exception {
        PictogramElement pe = this.replayPictogramElement(100, 100);
        IFile file = this.replayResource();
        JavaPersistentAttribute jpa = this.replayJpa(pe, file);
        IDiagramTypeProvider dtp = this.replayDiagramProviderForJpa(pe, jpa);
        IEclipseFacade eclipseFacade = (IEclipseFacade)EasyMock.createMock(IEclipseFacade.class);
        IStaticIDE ide = (IStaticIDE)EasyMock.createMock(IStaticIDE.class);
        EasyMock.expect((Object)eclipseFacade.getIDE()).andStubReturn((Object)ide);
        ide.openEditor(file);
        EasyMock.replay((Object[])new Object[]{eclipseFacade, ide});
        JPAEditorToolBehaviorProvider provider = new JPAEditorToolBehaviorProvider(dtp, eclipseFacade);
        IDoubleClickContext context = this.replayDoubleClickContext(pe);
        provider.getDoubleClickFeature(context);
        EasyMock.verify((Object[])new Object[]{ide});
    }

    private IDiagramTypeProvider replayDiagramProvider(PictogramElement pe, JavaPersistentType jpt) {
        IFeatureProvider featureProvider = (IFeatureProvider)EasyMock.createMock(IFeatureProvider.class);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement(pe)).andStubReturn((Object)jpt);
        IDiagramTypeProvider dtp = (IDiagramTypeProvider)EasyMock.createMock(IDiagramTypeProvider.class);
        EasyMock.expect((Object)dtp.getFeatureProvider()).andStubReturn((Object)featureProvider);
        EasyMock.replay((Object[])new Object[]{dtp, featureProvider});
        return dtp;
    }

    private IMarker replayMarker(int severity, String message) throws CoreException {
        IMarker marker = (IMarker)EasyMock.createMock(IMarker.class);
        EasyMock.expect((Object)marker.getAttribute("severity")).andStubReturn((Object)severity);
        EasyMock.expect((Object)marker.getAttribute("message")).andStubReturn((Object)message);
        EasyMock.replay((Object[])new Object[]{marker});
        return marker;
    }

    private JavaPersistentType replayJptWithMarker(IMarker[] markers) throws CoreException {
        JavaPersistentType jpt = (JavaPersistentType)EasyMock.createMock(JavaPersistentType.class);
        IFile file = (IFile)EasyMock.createMock(IFile.class);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        EasyMock.expect((Object)file.findMarkers(null, true, 2)).andStubReturn((Object)markers);
        EasyMock.expect((Object)jpt.getResource()).andStubReturn((Object)file);
        EasyMock.replay((Object[])new Object[]{file, jpt});
        return jpt;
    }

    private IFile replayResource() throws CoreException {
        IFile file = (IFile)EasyMock.createMock(IFile.class);
        file.setSessionProperty(new QualifiedName(null, "DOUBLE_CLICK"), (Object)"true");
        EasyMock.expectLastCall().asStub();
        EasyMock.expect((Object)file.getType()).andStubReturn((Object)1);
        EasyMock.replay((Object[])new Object[]{file});
        return file;
    }

    private IDoubleClickContext replayDoubleClickContext(PictogramElement pe) {
        IDoubleClickContext context = (IDoubleClickContext)EasyMock.createMock(IDoubleClickContext.class);
        EasyMock.expect((Object)context.getPictogramElements()).andStubReturn((Object)new PictogramElement[]{pe});
        EasyMock.replay((Object[])new Object[]{context});
        return context;
    }

    private JavaPersistentType replayJpt(PictogramElement pe, IFile file) {
        IFeatureProvider featureProvider = (IFeatureProvider)EasyMock.createMock(IFeatureProvider.class);
        JavaPersistentType jpt = (JavaPersistentType)EasyMock.createMock(JavaPersistentType.class);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement(pe)).andStubReturn((Object)jpt);
        EasyMock.expect((Object)jpt.getResource()).andReturn((Object)file);
        EasyMock.replay((Object[])new Object[]{jpt, featureProvider});
        return jpt;
    }

    private JavaPersistentAttribute replayJpa(PictogramElement pe, IFile file) {
        IFeatureProvider featureProvider = (IFeatureProvider)EasyMock.createMock(IFeatureProvider.class);
        JavaPersistentAttribute jpa = (JavaPersistentAttribute)EasyMock.createMock(JavaPersistentAttribute.class);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement(pe)).andStubReturn((Object)jpa);
        EasyMock.expect((Object)jpa.getResource()).andReturn((Object)file);
        EasyMock.replay((Object[])new Object[]{jpa, featureProvider});
        return jpa;
    }

    private IDiagramTypeProvider replayDiagramProviderForJpa(PictogramElement pe, JavaPersistentAttribute jpa) {
        IFeatureProvider featureProvider = (IFeatureProvider)EasyMock.createMock(IFeatureProvider.class);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement(pe)).andStubReturn((Object)jpa);
        IDiagramTypeProvider dtp = (IDiagramTypeProvider)EasyMock.createMock(IDiagramTypeProvider.class);
        EasyMock.expect((Object)dtp.getFeatureProvider()).andStubReturn((Object)featureProvider);
        EasyMock.replay((Object[])new Object[]{dtp, featureProvider});
        return dtp;
    }

    private PictogramElement replayPictogramElement(int width, int height) {
        PictogramElement pe = (PictogramElement)EasyMock.createMock(PictogramElement.class);
        GraphicsAlgorithm algo = (GraphicsAlgorithm)EasyMock.createMock(GraphicsAlgorithm.class);
        EasyMock.expect((Object)algo.getWidth()).andStubReturn((Object)width);
        EasyMock.expect((Object)algo.getHeight()).andStubReturn((Object)height);
        EasyMock.expect((Object)pe.getGraphicsAlgorithm()).andStubReturn((Object)algo);
        EasyMock.replay((Object[])new Object[]{pe, algo});
        return pe;
    }
}

