/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.QueryHint;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaNamedQueryTests
extends ContextModelTestCase {
    private static final String QUERY_NAME = "QUERY_NAME";
    private static final String QUERY_QUERY = "MY_QUERY";

    private ICompilationUnit createTestEntityWithNamedQuery() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.NamedQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedQuery(name=\"QUERY_NAME\", query=\"MY_QUERY\")");
            }
        });
    }

    public JavaNamedQueryTests(String name) {
        super(name);
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedQuery namedQuery = (NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation javaNamedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        JavaNamedQueryTests.assertEquals((String)QUERY_NAME, (String)javaNamedQuery.getName());
        JavaNamedQueryTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
        javaNamedQuery.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedQueryTests.assertNull((Object)javaNamedQuery.getName());
        JavaNamedQueryTests.assertNull((Object)namedQuery.getName());
        javaNamedQuery.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaNamedQueryTests.assertEquals((String)"foo", (String)javaNamedQuery.getName());
        JavaNamedQueryTests.assertEquals((String)"foo", (String)namedQuery.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedQuery namedQuery = (NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation javaNamedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        JavaNamedQueryTests.assertEquals((String)QUERY_NAME, (String)javaNamedQuery.getName());
        JavaNamedQueryTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
        namedQuery.setName(null);
        JavaNamedQueryTests.assertNull((Object)javaNamedQuery.getName());
        JavaNamedQueryTests.assertNull((Object)namedQuery.getName());
        namedQuery.setName("foo");
        JavaNamedQueryTests.assertEquals((String)"foo", (String)javaNamedQuery.getName());
        JavaNamedQueryTests.assertEquals((String)"foo", (String)namedQuery.getName());
    }

    public void testUpdateQuery() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedQuery namedQuery = (NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation javaNamedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        JavaNamedQueryTests.assertEquals((String)QUERY_QUERY, (String)javaNamedQuery.getQuery());
        JavaNamedQueryTests.assertEquals((String)QUERY_QUERY, (String)namedQuery.getQuery());
        javaNamedQuery.setQuery(null);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedQueryTests.assertNull((Object)javaNamedQuery.getQuery());
        JavaNamedQueryTests.assertNull((Object)namedQuery.getQuery());
        javaNamedQuery.setQuery("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaNamedQueryTests.assertEquals((String)"foo", (String)javaNamedQuery.getQuery());
        JavaNamedQueryTests.assertEquals((String)"foo", (String)namedQuery.getQuery());
    }

    public void testModifyQuery() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedQuery namedQuery = (NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation javaNamedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        JavaNamedQueryTests.assertEquals((String)QUERY_QUERY, (String)javaNamedQuery.getQuery());
        JavaNamedQueryTests.assertEquals((String)QUERY_QUERY, (String)namedQuery.getQuery());
        namedQuery.setQuery(null);
        JavaNamedQueryTests.assertNull((Object)javaNamedQuery.getQuery());
        JavaNamedQueryTests.assertNull((Object)namedQuery.getQuery());
        namedQuery.setQuery("foo");
        JavaNamedQueryTests.assertEquals((String)"foo", (String)javaNamedQuery.getQuery());
        JavaNamedQueryTests.assertEquals((String)"foo", (String)namedQuery.getQuery());
    }

    public void testAddHint() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedQuery namedQuery = (NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation javaNamedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        QueryHint queryHint = namedQuery.addHint(0);
        queryHint.setName("FOO");
        JavaNamedQueryTests.assertEquals((String)"FOO", (String)javaNamedQuery.hintAt(0).getName());
        QueryHint queryHint2 = namedQuery.addHint(0);
        queryHint2.setName("BAR");
        JavaNamedQueryTests.assertEquals((String)"BAR", (String)javaNamedQuery.hintAt(0).getName());
        JavaNamedQueryTests.assertEquals((String)"FOO", (String)javaNamedQuery.hintAt(1).getName());
        QueryHint queryHint3 = namedQuery.addHint(1);
        queryHint3.setName("BAZ");
        JavaNamedQueryTests.assertEquals((String)"BAR", (String)javaNamedQuery.hintAt(0).getName());
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)javaNamedQuery.hintAt(1).getName());
        JavaNamedQueryTests.assertEquals((String)"FOO", (String)javaNamedQuery.hintAt(2).getName());
        ListIterator hints = namedQuery.getHints().iterator();
        JavaNamedQueryTests.assertEquals((Object)queryHint2, hints.next());
        JavaNamedQueryTests.assertEquals((Object)queryHint3, hints.next());
        JavaNamedQueryTests.assertEquals((Object)queryHint, hints.next());
        hints = namedQuery.getHints().iterator();
        JavaNamedQueryTests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
    }

    public void testRemoveHint() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedQuery namedQuery = (NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation javaNamedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        namedQuery.addHint(0).setName("FOO");
        namedQuery.addHint(1).setName("BAR");
        namedQuery.addHint(2).setName("BAZ");
        JavaNamedQueryTests.assertEquals((int)3, (int)javaNamedQuery.getHintsSize());
        namedQuery.removeHint(0);
        JavaNamedQueryTests.assertEquals((int)2, (int)javaNamedQuery.getHintsSize());
        JavaNamedQueryTests.assertEquals((String)"BAR", (String)javaNamedQuery.hintAt(0).getName());
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)javaNamedQuery.hintAt(1).getName());
        namedQuery.removeHint(0);
        JavaNamedQueryTests.assertEquals((int)1, (int)javaNamedQuery.getHintsSize());
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)javaNamedQuery.hintAt(0).getName());
        namedQuery.removeHint(0);
        JavaNamedQueryTests.assertEquals((int)0, (int)javaNamedQuery.getHintsSize());
    }

    public void testMoveHint() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedQuery namedQuery = (NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation javaNamedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        namedQuery.addHint(0).setName("FOO");
        namedQuery.addHint(1).setName("BAR");
        namedQuery.addHint(2).setName("BAZ");
        JavaNamedQueryTests.assertEquals((int)3, (int)javaNamedQuery.getHintsSize());
        namedQuery.moveHint(2, 0);
        ListIterator hints = namedQuery.getHints().iterator();
        JavaNamedQueryTests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"BAR", (String)javaNamedQuery.hintAt(0).getName());
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)javaNamedQuery.hintAt(1).getName());
        JavaNamedQueryTests.assertEquals((String)"FOO", (String)javaNamedQuery.hintAt(2).getName());
        namedQuery.moveHint(0, 1);
        hints = namedQuery.getHints().iterator();
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)javaNamedQuery.hintAt(0).getName());
        JavaNamedQueryTests.assertEquals((String)"BAR", (String)javaNamedQuery.hintAt(1).getName());
        JavaNamedQueryTests.assertEquals((String)"FOO", (String)javaNamedQuery.hintAt(2).getName());
    }

    public void testUpdateHints() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedQuery namedQuery = (NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation namedQueryAnnotation = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        namedQueryAnnotation.addHint(0).setName("FOO");
        namedQueryAnnotation.addHint(1).setName("BAR");
        namedQueryAnnotation.addHint(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator hints = namedQuery.getHints().iterator();
        JavaNamedQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertFalse((boolean)hints.hasNext());
        namedQueryAnnotation.moveHint(2, 0);
        this.getJpaProject().synchronizeContextModel();
        hints = namedQuery.getHints().iterator();
        JavaNamedQueryTests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertFalse((boolean)hints.hasNext());
        namedQueryAnnotation.moveHint(0, 1);
        this.getJpaProject().synchronizeContextModel();
        hints = namedQuery.getHints().iterator();
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertFalse((boolean)hints.hasNext());
        namedQueryAnnotation.removeHint(1);
        this.getJpaProject().synchronizeContextModel();
        hints = namedQuery.getHints().iterator();
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertFalse((boolean)hints.hasNext());
        namedQueryAnnotation.removeHint(1);
        this.getJpaProject().synchronizeContextModel();
        hints = namedQuery.getHints().iterator();
        JavaNamedQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedQueryTests.assertFalse((boolean)hints.hasNext());
        namedQueryAnnotation.removeHint(0);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedQueryTests.assertFalse((boolean)namedQuery.getHints().iterator().hasNext());
    }

    public void testHintsSize() throws Exception {
        this.createTestEntityWithNamedQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedQuery namedQuery = (NamedQuery)entity.getQueryContainer().getNamedQueries().iterator().next();
        JavaNamedQueryTests.assertEquals((int)0, (int)namedQuery.getHintsSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQueryAnnotation javaNamedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        javaNamedQuery.addHint(0);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedQueryTests.assertEquals((int)1, (int)namedQuery.getHintsSize());
        javaNamedQuery.addHint(0);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedQueryTests.assertEquals((int)2, (int)namedQuery.getHintsSize());
        javaNamedQuery.removeHint(0);
        javaNamedQuery.removeHint(0);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedQueryTests.assertEquals((int)0, (int)namedQuery.getHintsSize());
    }
}

