/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.MappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneRelationship;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.PrimaryKeyJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaOneToOneMappingTests
extends ContextModelTestCase {
    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithCollectionOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Collection address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithGenericizedCollectionOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    public JavaOneToOneMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaOneToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
    }

    public void testUpdateSpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation oneToOneAnnotation = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedTargetEntity());
        JavaOneToOneMappingTests.assertNull((Object)oneToOneAnnotation.getTargetEntity());
        oneToOneAnnotation.setTargetEntity("newTargetEntity");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOneMapping.getSpecifiedTargetEntity());
        JavaOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOneAnnotation.getTargetEntity());
        oneToOneAnnotation.setTargetEntity(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedTargetEntity());
        JavaOneToOneMappingTests.assertNull((Object)oneToOneAnnotation.getTargetEntity());
    }

    public void testModifySpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedTargetEntity());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity("newTargetEntity");
        JavaOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOneMapping.getSpecifiedTargetEntity());
        JavaOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOne.getTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedTargetEntity());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
    }

    public void testUpdateMappedBy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        MappedByRelationshipStrategy mappedBy = oneToOneMapping.getRelationship().getMappedByStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)mappedBy.getMappedByAttribute());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
        oneToOne.setMappedBy("newMappedBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertEquals((String)"newMappedBy", (String)mappedBy.getMappedByAttribute());
        JavaOneToOneMappingTests.assertEquals((String)"newMappedBy", (String)oneToOne.getMappedBy());
        oneToOne.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)mappedBy.getMappedByAttribute());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        MappedByRelationshipStrategy mappedBy = oneToOneMapping.getRelationship().getMappedByStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)mappedBy.getMappedByAttribute());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
        mappedBy.setMappedByAttribute("newTargetEntity");
        JavaOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)mappedBy.getMappedByAttribute());
        JavaOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOne.getMappedBy());
        mappedBy.setMappedByAttribute(null);
        JavaOneToOneMappingTests.assertNull((Object)mappedBy.getMappedByAttribute());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
    }

    public void testUpdateSpecifiedOptional() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getOptional());
        oneToOne.setOptional(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOptional());
        oneToOne.setOptional(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOne.getOptional());
        oneToOne.setOptional(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getOptional());
    }

    public void testModifySpecifiedOptional() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getOptional());
        oneToOneMapping.setSpecifiedOptional(Boolean.TRUE);
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOptional());
        oneToOneMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOne.getOptional());
        oneToOneMapping.setSpecifiedOptional(null);
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getOptional());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getFetch());
        oneToOne.setFetch(org.eclipse.jpt.jpa.core.resource.java.FetchType.EAGER);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.EAGER, (Object)oneToOne.getFetch());
        oneToOne.setFetch(org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)oneToOne.getFetch());
        oneToOne.setFetch(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getFetch());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        JavaOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.EAGER, (Object)oneToOne.getFetch());
        oneToOneMapping.setSpecifiedFetch(FetchType.LAZY);
        JavaOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)oneToOne.getFetch());
        oneToOneMapping.setSpecifiedFetch(null);
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getFetch());
    }

    public void testSpecifiedJoinColumns() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        ListIterator specifiedJoinColumns = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        joinColumn.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        joinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        joinColumn.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        joinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        joinColumn.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
    }

    public void testGetDefaultJoin() {
    }

    public void testSpecifiedJoinColumnsSize() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaOneToOneMappingTests.assertEquals((int)0, (int)joinColumns.getSpecifiedJoinColumnsSize());
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)1, (int)joinColumns.getSpecifiedJoinColumnsSize());
        joinColumns.removeSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)0, (int)joinColumns.getSpecifiedJoinColumnsSize());
    }

    public void testJoinColumnsSize() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaOneToOneMappingTests.assertEquals((int)1, (int)joinColumns.getJoinColumnsSize());
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)1, (int)joinColumns.getJoinColumnsSize());
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)2, (int)joinColumns.getJoinColumnsSize());
        joinColumns.removeSpecifiedJoinColumn(0);
        joinColumns.removeSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)1, (int)joinColumns.getJoinColumnsSize());
        oneToOneMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("foo");
        JavaOneToOneMappingTests.assertEquals((int)0, (int)joinColumns.getJoinColumnsSize());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("BAR");
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator joinColumnsIterator = resourceField.getAnnotations("javax.persistence.JoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testAddSpecifiedJoinColumn2() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinColumns.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinColumns.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator joinColumnsIterator = resourceField.getAnnotations("javax.persistence.JoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinColumns.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinColumns.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaOneToOneMappingTests.assertEquals((int)3, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        joinColumns.removeSpecifiedJoinColumn(1);
        ListIterator joinColumnResources = resourceField.getAnnotations("javax.persistence.JoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        ListIterator joinColumnsIterator = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        joinColumns.removeSpecifiedJoinColumn(1);
        joinColumnResources = resourceField.getAnnotations("javax.persistence.JoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumnsIterator = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        joinColumns.removeSpecifiedJoinColumn(0);
        joinColumnResources = resourceField.getAnnotations("javax.persistence.JoinColumn").iterator();
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumnsIterator = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinColumns.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinColumns.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator javaJoinColumns = resourceField.getAnnotations("javax.persistence.JoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaJoinColumns));
        joinColumns.moveSpecifiedJoinColumn(2, 0);
        ListIterator primaryKeyJoinColumns = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaJoinColumns = resourceField.getAnnotations("javax.persistence.JoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        joinColumns.moveSpecifiedJoinColumn(0, 1);
        primaryKeyJoinColumns = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaJoinColumns = resourceField.getAnnotations("javax.persistence.JoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
    }

    public void testUpdateSpecifiedJoinColumns() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ((JoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.JoinColumn")).setName("FOO");
        ((JoinColumnAnnotation)resourceField.addAnnotation(1, "javax.persistence.JoinColumn")).setName("BAR");
        ((JoinColumnAnnotation)resourceField.addAnnotation(2, "javax.persistence.JoinColumn")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator joinColumnsIterator = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.moveAnnotation(2, 0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.moveAnnotation(0, 1, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = joinColumns.getSpecifiedJoinColumns().iterator();
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testJoinColumnIsVirtual() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        JavaOneToOneMappingTests.assertTrue((boolean)joinColumns.getDefaultJoinColumn().isDefault());
        joinColumns.addSpecifiedJoinColumn(0);
        JoinColumn specifiedJoinColumn = (JoinColumn)joinColumns.getSpecifiedJoinColumns().iterator().next();
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumn.isDefault());
        JavaOneToOneMappingTests.assertNull((Object)joinColumns.getDefaultJoinColumn());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        JavaOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        JavaOneToOneMappingTests.assertNull((Object)stateFooMapping);
    }

    public void testDefaultTargetEntity() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaOneToOneMappingTests.assertEquals((String)"test.Address", (String)oneToOneMapping.getDefaultTargetEntity());
        this.addXmlClassRef("test.Address");
        JavaOneToOneMappingTests.assertEquals((String)"test.Address", (String)oneToOneMapping.getDefaultTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        JavaOneToOneMappingTests.assertEquals((String)"test.Address", (String)oneToOneMapping.getDefaultTargetEntity());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaPersistentType addressPersistentType = addressClassRef.getJavaPersistentType();
        addressPersistentType.setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaOneToOneMappingTests.assertEquals((String)"test.Address", (String)oneToOneMapping.getDefaultTargetEntity());
    }

    public void testDefaultTargetEntityCollectionType() throws Exception {
        this.createTestEntityWithCollectionOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getDefaultTargetEntity());
    }

    public void testDefaultTargetEntityGenericizedCollectionType() throws Exception {
        this.createTestEntityWithGenericizedCollectionOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getDefaultTargetEntity());
    }

    public void testTargetEntity() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaOneToOneMappingTests.assertEquals((String)"test.Address", (String)oneToOneMapping.getTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        JavaOneToOneMappingTests.assertEquals((String)"foo", (String)oneToOneMapping.getTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        JavaOneToOneMappingTests.assertEquals((String)"test.Address", (String)oneToOneMapping.getTargetEntity());
    }

    public void testResolvedTargetEntity() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getResolvedTargetEntity());
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.Address");
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaTypeMapping addressTypeMapping = addressClassRef.getJavaPersistentType().getMapping();
        JavaOneToOneMappingTests.assertEquals((Object)addressTypeMapping, (Object)oneToOneMapping.getResolvedTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getResolvedTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity("test.Address");
        JavaOneToOneMappingTests.assertEquals((Object)addressTypeMapping, (Object)oneToOneMapping.getResolvedTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        JavaOneToOneMappingTests.assertEquals((Object)addressTypeMapping, (Object)oneToOneMapping.getResolvedTargetEntity());
    }

    public void testPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnRelationshipStrategy strategy = oneToOneMapping.getRelationship().getPrimaryKeyJoinColumnStrategy();
        ListIterator primaryKeyJoinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        PrimaryKeyJoinColumnAnnotation joinColumn = (PrimaryKeyJoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        joinColumn.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        joinColumn = (PrimaryKeyJoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        joinColumn.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        joinColumn = (PrimaryKeyJoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        joinColumn.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
    }

    public void testPrimaryKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnRelationshipStrategy strategy = oneToOneMapping.getRelationship().getPrimaryKeyJoinColumnStrategy();
        JavaOneToOneMappingTests.assertEquals((int)0, (int)strategy.getPrimaryKeyJoinColumnsSize());
        strategy.addPrimaryKeyJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)1, (int)strategy.getPrimaryKeyJoinColumnsSize());
        strategy.removePrimaryKeyJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)0, (int)strategy.getPrimaryKeyJoinColumnsSize());
    }

    public void testAddPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnRelationshipStrategy strategy = oneToOneMapping.getRelationship().getPrimaryKeyJoinColumnStrategy();
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator joinColumns = resourceField.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
    }

    public void testAddPrimaryKeyJoinColumn2() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnRelationshipStrategy strategy = oneToOneMapping.getRelationship().getPrimaryKeyJoinColumnStrategy();
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        strategy.addPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        strategy.addPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator joinColumns = resourceField.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
    }

    public void testRemovePrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnRelationshipStrategy strategy = oneToOneMapping.getRelationship().getPrimaryKeyJoinColumnStrategy();
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        strategy.addPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        strategy.addPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaOneToOneMappingTests.assertEquals((int)3, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        strategy.removePrimaryKeyJoinColumn(1);
        ListIterator joinColumnResources = resourceField.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        ListIterator joinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        strategy.removePrimaryKeyJoinColumn(1);
        joinColumnResources = resourceField.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        strategy.removePrimaryKeyJoinColumn(0);
        joinColumnResources = resourceField.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
    }

    public void testMovePrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnRelationshipStrategy strategy = oneToOneMapping.getRelationship().getPrimaryKeyJoinColumnStrategy();
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        strategy.addPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        strategy.addPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator javaJoinColumns = resourceField.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaJoinColumns));
        strategy.movePrimaryKeyJoinColumn(2, 0);
        ListIterator primaryKeyJoinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaJoinColumns = resourceField.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)javaJoinColumns.next()).getName());
        strategy.movePrimaryKeyJoinColumn(0, 1);
        primaryKeyJoinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaJoinColumns = resourceField.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)javaJoinColumns.next()).getName());
    }

    public void testUpdatePrimaryKeyJoinColumns() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnRelationshipStrategy strategy = oneToOneMapping.getRelationship().getPrimaryKeyJoinColumnStrategy();
        ((PrimaryKeyJoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn")).setName("FOO");
        ((PrimaryKeyJoinColumnAnnotation)resourceField.addAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn")).setName("BAR");
        ((PrimaryKeyJoinColumnAnnotation)resourceField.addAnnotation(2, "javax.persistence.PrimaryKeyJoinColumn")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator joinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        resourceField.moveAnnotation(2, 0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        resourceField.moveAnnotation(0, 1, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = strategy.getPrimaryKeyJoinColumns().iterator();
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping mapping = (OneToOneMapping)contextAttribute.getMapping();
        OneToOneRelationship rel = mapping.getRelationship();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToPrimaryKeyJoinColumn();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinColumn();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping mapping = (OneToOneMapping)contextAttribute.getMapping();
        OneToOneRelationship rel = mapping.getRelationship();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceField.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceField.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceField.removeAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }
}

