/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.ListIterator;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEmbedded;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEmbeddedId;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlId;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOneToMany;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTransient;
import org.eclipse.jpt.jpa.core.resource.orm.XmlVersion;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class GenericOrmPersistentTypeTests
extends ContextModelTestCase {
    public static final String MODEL_TYPE_NAME = "Model";
    public static final String FULLY_QUALIFIED_MODEL_TYPE_NAME = "test.Model";
    public static final String EMPLOYEE_TYPE_NAME = "Employee";
    public static final String FULLY_QUALIFIED_EMPLOYEE_TYPE_NAME = "test.Employee";

    public GenericOrmPersistentTypeTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private void createModelType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public abstract class ").append(GenericOrmPersistentTypeTests.MODEL_TYPE_NAME).append(" {");
                sb.append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Model.java", sourceWriter);
    }

    private void createEmployeeType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append(GenericOrmPersistentTypeTests.EMPLOYEE_TYPE_NAME).append(" extends ").append(GenericOrmPersistentTypeTests.MODEL_TYPE_NAME).append(" {");
                sb.append(CR);
                sb.append("    private String department;").append(CR);
                sb.append(CR);
                sb.append("    private java.util.Date startDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    public void testMorphXmlTypeMapping() throws Exception {
        GenericOrmPersistentTypeTests.assertFalse((boolean)this.getEntityMappings().getPersistentTypes().iterator().hasNext());
        GenericOrmPersistentTypeTests.assertTrue((boolean)this.getXmlEntityMappings().getMappedSuperclasses().isEmpty());
        GenericOrmPersistentTypeTests.assertTrue((boolean)this.getXmlEntityMappings().getEntities().isEmpty());
        GenericOrmPersistentTypeTests.assertTrue((boolean)this.getXmlEntityMappings().getEmbeddables().isEmpty());
        OrmPersistentType embeddablePersistentType = this.getEntityMappings().addPersistentType("embeddable", "model.Foo");
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        OrmPersistentType mappedSuperclassPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "model.Foo3");
        OrmPersistentType ormPersistentType = (OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next();
        GenericOrmPersistentTypeTests.assertEquals((Object)mappedSuperclassPersistentType, (Object)ormPersistentType);
        GenericOrmPersistentTypeTests.assertEquals((String)"mappedSuperclass", (String)ormPersistentType.getMapping().getKey());
        ormPersistentType.setMappingKey("embeddable");
        GenericOrmPersistentTypeTests.assertEquals((int)0, (int)this.getXmlEntityMappings().getMappedSuperclasses().size());
        GenericOrmPersistentTypeTests.assertEquals((int)1, (int)this.getXmlEntityMappings().getEntities().size());
        GenericOrmPersistentTypeTests.assertEquals((int)2, (int)this.getXmlEntityMappings().getEmbeddables().size());
        ListIterator ormPersistentTypes = this.getEntityMappings().getPersistentTypes().iterator();
        GenericOrmPersistentTypeTests.assertEquals(ormPersistentTypes.next(), (Object)entityPersistentType);
        GenericOrmPersistentTypeTests.assertEquals(ormPersistentTypes.next(), (Object)embeddablePersistentType);
        GenericOrmPersistentTypeTests.assertEquals(ormPersistentTypes.next(), (Object)mappedSuperclassPersistentType);
        GenericOrmPersistentTypeTests.assertEquals((String)"model.Foo", (String)((XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(0)).getClassName());
        GenericOrmPersistentTypeTests.assertEquals((String)"model.Foo3", (String)((XmlEmbeddable)this.getXmlEntityMappings().getEmbeddables().get(1)).getClassName());
    }

    public void testAddSpecifiedPersistentAttribute() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        entityPersistentType.addSpecifiedAttribute("basic", "basicAttribute");
        XmlEntity entity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic basic = (XmlBasic)entity.getAttributes().getBasics().get(0);
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)basic.getName());
        entityPersistentType.addSpecifiedAttribute("embedded", "embeddedAttribute");
        XmlEmbedded embedded = (XmlEmbedded)entity.getAttributes().getEmbeddeds().get(0);
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)embedded.getName());
        entityPersistentType.addSpecifiedAttribute("transient", "transientAttribute");
        XmlTransient transientResource = (XmlTransient)entity.getAttributes().getTransients().get(0);
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)transientResource.getName());
        entityPersistentType.addSpecifiedAttribute("version", "versionAttribute");
        XmlVersion version = (XmlVersion)entity.getAttributes().getVersions().get(0);
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)version.getName());
        entityPersistentType.addSpecifiedAttribute("id", "idAttribute");
        XmlId id = (XmlId)entity.getAttributes().getIds().get(0);
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)id.getName());
        ListIterator persistentAttributes = entityPersistentType.getSpecifiedAttributes().iterator();
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)((OrmPersistentAttribute)persistentAttributes.next()).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)((OrmPersistentAttribute)persistentAttributes.next()).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)((OrmPersistentAttribute)persistentAttributes.next()).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)((OrmPersistentAttribute)persistentAttributes.next()).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((OrmPersistentAttribute)persistentAttributes.next()).getName());
        GenericOrmPersistentTypeTests.assertFalse((boolean)persistentAttributes.hasNext());
    }

    public void testRemoveSpecifiedPersistentAttribute() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        entityPersistentType.addSpecifiedAttribute("basic", "basicAttribute");
        entityPersistentType.addSpecifiedAttribute("embedded", "embeddedAttribute");
        entityPersistentType.addSpecifiedAttribute("version", "versionAttribute");
        entityPersistentType.addSpecifiedAttribute("id", "idAttribute");
        entityPersistentType.addSpecifiedAttribute("transient", "transientAttribute");
        XmlEntity entity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)((XmlBasic)entity.getAttributes().getBasics().get(0)).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)((XmlEmbedded)entity.getAttributes().getEmbeddeds().get(0)).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)((XmlVersion)entity.getAttributes().getVersions().get(0)).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)((XmlId)entity.getAttributes().getIds().get(0)).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((XmlTransient)entity.getAttributes().getTransients().get(0)).getName());
        ((OrmPersistentAttribute)entityPersistentType.getAttributeNamed("basicAttribute")).convertToVirtual();
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)((XmlEmbedded)entity.getAttributes().getEmbeddeds().get(0)).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)((XmlVersion)entity.getAttributes().getVersions().get(0)).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)((XmlId)entity.getAttributes().getIds().get(0)).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((XmlTransient)entity.getAttributes().getTransients().get(0)).getName());
        ((OrmPersistentAttribute)entityPersistentType.getAttributeNamed("embeddedAttribute")).convertToVirtual();
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)((XmlVersion)entity.getAttributes().getVersions().get(0)).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)((XmlId)entity.getAttributes().getIds().get(0)).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((XmlTransient)entity.getAttributes().getTransients().get(0)).getName());
        ((OrmPersistentAttribute)entityPersistentType.getAttributeNamed("versionAttribute")).convertToVirtual();
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)((XmlId)entity.getAttributes().getIds().get(0)).getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((XmlTransient)entity.getAttributes().getTransients().get(0)).getName());
        ((OrmPersistentAttribute)entityPersistentType.getAttributeNamed("idAttribute")).convertToVirtual();
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((XmlTransient)entity.getAttributes().getTransients().get(0)).getName());
        ((OrmPersistentAttribute)entityPersistentType.getAttributeNamed("transientAttribute")).convertToVirtual();
        GenericOrmPersistentTypeTests.assertNull((Object)entity.getAttributes());
    }

    public void testRemoveId() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        XmlEntity entity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityPersistentType.addSpecifiedAttribute("id", "idAttribute");
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)((XmlId)entity.getAttributes().getIds().get(0)).getName());
        ((OrmPersistentAttribute)entityPersistentType.getAttributeNamed("idAttribute")).convertToVirtual();
        GenericOrmPersistentTypeTests.assertNull((Object)entity.getAttributes());
    }

    public void testRemoveBasic() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        XmlEntity entity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityPersistentType.addSpecifiedAttribute("basic", "basicAttribute");
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)((XmlBasic)entity.getAttributes().getBasics().get(0)).getName());
        ((OrmPersistentAttribute)entityPersistentType.getAttributeNamed("basicAttribute")).convertToVirtual();
        GenericOrmPersistentTypeTests.assertNull((Object)entity.getAttributes());
    }

    public void testRemoveVersion() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        XmlEntity entity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityPersistentType.addSpecifiedAttribute("version", "versionAttribute");
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)((XmlVersion)entity.getAttributes().getVersions().get(0)).getName());
        ((OrmPersistentAttribute)entityPersistentType.getAttributeNamed("versionAttribute")).convertToVirtual();
        GenericOrmPersistentTypeTests.assertNull((Object)entity.getAttributes());
    }

    public void testRemoveEmbedded() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        XmlEntity entity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityPersistentType.addSpecifiedAttribute("embedded", "embeddedAttribute");
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)((XmlEmbedded)entity.getAttributes().getEmbeddeds().get(0)).getName());
        ((OrmPersistentAttribute)entityPersistentType.getAttributeNamed("embeddedAttribute")).convertToVirtual();
        GenericOrmPersistentTypeTests.assertNull((Object)entity.getAttributes());
    }

    public void testRemoveTransient() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        XmlEntity entity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityPersistentType.addSpecifiedAttribute("transient", "transientAttribute");
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)((XmlTransient)entity.getAttributes().getTransients().get(0)).getName());
        ((OrmPersistentAttribute)entityPersistentType.getAttributeNamed("transientAttribute")).convertToVirtual();
        GenericOrmPersistentTypeTests.assertNull((Object)entity.getAttributes());
    }

    public void testUpdateSpecifiedPersistentAttributes() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo2");
        XmlEntity entity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entity.setAttributes(OrmFactory.eINSTANCE.createAttributes());
        XmlBasic basic = OrmFactory.eINSTANCE.createXmlBasic();
        entity.getAttributes().getBasics().add((Object)basic);
        basic.setName("basicAttribute");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)entityPersistentType.getAttributes().iterator().next();
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        XmlEmbedded embedded = OrmFactory.eINSTANCE.createXmlEmbedded();
        entity.getAttributes().getEmbeddeds().add((Object)embedded);
        embedded.setName("embeddedAttribute");
        ListIterator attributes = entityPersistentType.getAttributes().iterator();
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        GenericOrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlVersion version = OrmFactory.eINSTANCE.createXmlVersion();
        entity.getAttributes().getVersions().add((Object)version);
        version.setName("versionAttribute");
        attributes = entityPersistentType.getAttributes().iterator();
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        GenericOrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlId id = OrmFactory.eINSTANCE.createXmlId();
        entity.getAttributes().getIds().add((Object)id);
        id.setName("idAttribute");
        attributes = entityPersistentType.getAttributes().iterator();
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        GenericOrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlTransient transientResource = OrmFactory.eINSTANCE.createXmlTransient();
        entity.getAttributes().getTransients().add((Object)transientResource);
        transientResource.setName("transientAttribute");
        attributes = entityPersistentType.getAttributes().iterator();
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getKey());
        GenericOrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlManyToOne manyToOneResource = OrmFactory.eINSTANCE.createXmlManyToOne();
        entity.getAttributes().getManyToOnes().add((Object)manyToOneResource);
        manyToOneResource.setName("manyToOneAttribute");
        attributes = entityPersistentType.getAttributes().iterator();
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToOneAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getKey());
        GenericOrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlManyToMany manyToManyResource = OrmFactory.eINSTANCE.createXmlManyToMany();
        entity.getAttributes().getManyToManys().add((Object)manyToManyResource);
        manyToManyResource.setName("manyToManyAttribute");
        attributes = entityPersistentType.getAttributes().iterator();
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToOneAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToManyAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getKey());
        GenericOrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlOneToMany oneToManyResource = OrmFactory.eINSTANCE.createXmlOneToMany();
        entity.getAttributes().getOneToManys().add((Object)oneToManyResource);
        oneToManyResource.setName("oneToManyAttribute");
        attributes = entityPersistentType.getAttributes().iterator();
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToOneAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"oneToManyAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToManyAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getKey());
        GenericOrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlOneToOne oneToOneResource = OrmFactory.eINSTANCE.createXmlOneToOne();
        entity.getAttributes().getOneToOnes().add((Object)oneToOneResource);
        oneToOneResource.setName("oneToOneAttribute");
        attributes = entityPersistentType.getAttributes().iterator();
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToOneAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"oneToManyAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"oneToOneAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToManyAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getKey());
        GenericOrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        XmlEmbeddedId embeddedIdResource = OrmFactory.eINSTANCE.createXmlEmbeddedId();
        entity.getAttributes().getEmbeddedIds().add((Object)embeddedIdResource);
        embeddedIdResource.setName("embeddedIdAttribute");
        attributes = entityPersistentType.getAttributes().iterator();
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"idAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedIdAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"basicAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"versionAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToOneAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"oneToManyAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"oneToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"oneToOneAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToManyAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"embeddedAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        GenericOrmPersistentTypeTests.assertEquals((String)"transientAttribute", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getKey());
        GenericOrmPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
        entity.getAttributes().getBasics().remove(0);
        entity.getAttributes().getEmbeddeds().remove(0);
        entity.getAttributes().getTransients().remove(0);
        entity.getAttributes().getIds().remove(0);
        entity.getAttributes().getVersions().remove(0);
        entity.getAttributes().getManyToOnes().remove(0);
        entity.getAttributes().getManyToManys().remove(0);
        entity.getAttributes().getOneToManys().remove(0);
        entity.getAttributes().getOneToOnes().remove(0);
        entity.getAttributes().getEmbeddedIds().remove(0);
        GenericOrmPersistentTypeTests.assertFalse((boolean)entityPersistentType.getAttributes().iterator().hasNext());
        GenericOrmPersistentTypeTests.assertNotNull((Object)entity.getAttributes());
    }

    public void testInheritedAttributesResolve() throws Exception {
        this.createModelType();
        this.createEmployeeType();
        OrmPersistentType employeePersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_EMPLOYEE_TYPE_NAME);
        employeePersistentType.addSpecifiedAttribute("id", "id");
        employeePersistentType.addSpecifiedAttribute("basic", "name");
        OrmPersistentAttribute startDateAttribute = employeePersistentType.addSpecifiedAttribute("basic", "startDate");
        ((OrmBasicMapping)startDateAttribute.getMapping()).setConverter(TemporalConverter.class);
        ((TemporalConverter)((OrmBasicMapping)startDateAttribute.getMapping()).getConverter()).setTemporalType(TemporalType.DATE);
        OrmReadOnlyPersistentAttribute idAttribute = employeePersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = idAttribute.getJavaPersistentAttribute();
        GenericOrmPersistentTypeTests.assertNotNull((Object)javaPersistentAttribute);
        GenericOrmPersistentTypeTests.assertEquals((String)"id", (String)javaPersistentAttribute.getName());
        GenericOrmPersistentTypeTests.assertEquals((String)FULLY_QUALIFIED_EMPLOYEE_TYPE_NAME, (String)javaPersistentAttribute.getOwningPersistentType().getName());
        GenericOrmPersistentTypeTests.assertEquals((String)FULLY_QUALIFIED_MODEL_TYPE_NAME, (String)javaPersistentAttribute.getResourceAttribute().getParent().getQualifiedName());
    }
}

