/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaEmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmEmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEmbeddedId;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmEmbeddedIdMappingTests
extends ContextModelTestCase {
    private static final String ATTRIBUTE_OVERRIDE_NAME = "city";
    private static final String ATTRIBUTE_OVERRIDE_COLUMN_NAME = "E_CITY";

    public OrmEmbeddedIdMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityEmbeddedIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.EmbeddedId", "javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @EmbeddedId");
                sb.append(CR);
                sb.append("    @AttributeOverride(name=\"city\", column=@Column(name=\"E_CITY\"))");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Column");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Column(name=\"A_STATE\")").append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    public void testEmbeddedIdMorphToIdMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setMappingKey("id");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToVersionMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setMappingKey("version");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToTransientMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setMappingKey("transient");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToBasicMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setMappingKey("basic");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embedded");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
        attributeOverride = (AttributeOverride)((EmbeddedMapping)ormPersistentAttribute.getMapping()).getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"override", (String)attributeOverride.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"OVERRIDE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
    }

    public void testEmbeddedIdMorphToOneToOneMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToOne");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToOneToManyMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToMany");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToManyToOneMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToOne");
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedIdMorphToManyToManyMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedId");
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedIdMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToMany");
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmEmbeddedIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmEmbeddedIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedId", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedMapping");
        OrmEmbeddedIdMapping ormEmbeddedMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        XmlEmbeddedId embeddedResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedMapping", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedMapping", (String)embeddedResource.getName());
        embeddedResource.setName("newName");
        OrmEmbeddedIdMappingTests.assertEquals((String)"newName", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"newName", (String)embeddedResource.getName());
        embeddedResource.setName(null);
        OrmEmbeddedIdMappingTests.assertNull((Object)ormEmbeddedMapping.getName());
        OrmEmbeddedIdMappingTests.assertNull((Object)embeddedResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedMapping");
        OrmEmbeddedIdMapping ormEmbeddedMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        XmlEmbeddedId embeddedResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedMapping", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"embeddedMapping", (String)embeddedResource.getName());
        ormEmbeddedMapping.setName("newName");
        OrmEmbeddedIdMappingTests.assertEquals((String)"newName", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"newName", (String)embeddedResource.getName());
        ormEmbeddedMapping.setName(null);
        OrmEmbeddedIdMappingTests.assertNull((Object)ormEmbeddedMapping.getName());
        OrmEmbeddedIdMappingTests.assertNull((Object)embeddedResource.getName());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedMapping");
        OrmEmbeddedIdMapping ormEmbeddedIdMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedIdMapping.getAttributeOverrideContainer();
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(2)).setName("BAZ");
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)embeddedIdResource.getAttributeOverrides().size());
        attributeOverrideContainer.moveSpecifiedOverride(2, 0);
        ListIterator attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(0)).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(1)).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(2)).getName());
        attributeOverrideContainer.moveSpecifiedOverride(0, 1);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(0)).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(1)).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(2)).getName());
    }

    public void testUpdateAttributeOverrides() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embeddedId", "embeddedMapping");
        OrmEmbeddedIdMapping ormEmbeddedIdMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedIdMapping.getAttributeOverrideContainer();
        XmlEmbeddedId embeddedIdResource = (XmlEmbeddedId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddedIds().get(0);
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedIdResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)embeddedIdResource.getAttributeOverrides().get(2)).setName("BAZ");
        ListIterator attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedIdResource.getAttributeOverrides().move(2, 0);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedIdResource.getAttributeOverrides().move(0, 1);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedIdResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedIdResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        OrmEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedIdResource.getAttributeOverrides().remove(0);
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrideContainer.getSpecifiedOverrides().iterator().hasNext());
    }

    public void testEmbeddedMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedAttribute("embeddedId", "foo");
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)ormPersistentType.getVirtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmEmbeddedIdMapping ormEmbeddedIdMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedIdMapping.getAttributeOverrideContainer();
        OrmEmbeddedIdMappingTests.assertEquals((String)"foo", (String)ormEmbeddedIdMapping.getName());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrideContainer.getSpecifiedOverrides().iterator().hasNext());
        OrmEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrideContainer.getVirtualOverrides().iterator().hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType embeddableAddressType = this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = persistentType.getAttributeNamed("address");
        JavaEmbeddedIdMapping embeddedIdMapping = (JavaEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedIdMapping.getAttributeOverrideContainer();
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        AttributeOverride specifiedAttributeOverride = (AttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)specifiedAttributeOverride.getName());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        JavaVirtualAttributeOverride virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"state", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"zip", (String)virtualAttributeOverride.getName());
        JavaEmbeddedIdMapping javaEmbeddedIdMapping = (JavaEmbeddedIdMapping)ormPersistentAttribute.resolveJavaPersistentAttribute().getMapping();
        JavaColumn javaAttributeOverrideColumn = ((JavaAttributeOverride)javaEmbeddedIdMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next()).getColumn();
        javaAttributeOverrideColumn.setSpecifiedName("FOO_COLUMN");
        javaAttributeOverrideColumn.setSpecifiedTable("FOO_TABLE");
        javaAttributeOverrideColumn.setColumnDefinition("COLUMN_DEF");
        javaAttributeOverrideColumn.setSpecifiedInsertable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUpdatable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUnique(Boolean.TRUE);
        javaAttributeOverrideColumn.setSpecifiedNullable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedLength(Integer.valueOf(5));
        javaAttributeOverrideColumn.setSpecifiedPrecision(Integer.valueOf(6));
        javaAttributeOverrideColumn.setSpecifiedScale(Integer.valueOf(7));
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)embeddableAddressType.getJavaPersistentType().getAttributeNamed("state").getMapping();
        javaBasicMapping.getColumn().setSpecifiedName("MY_STATE_COLUMN");
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        specifiedAttributeOverride = (AttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)specifiedAttributeOverride.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO_COLUMN", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"FOO_TABLE", (String)specifiedAttributeOverride.getColumn().getSpecifiedTable());
        OrmEmbeddedIdMappingTests.assertEquals((String)"COLUMN_DEF", (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        OrmEmbeddedIdMappingTests.assertEquals((int)5, (int)specifiedAttributeOverride.getColumn().getLength());
        OrmEmbeddedIdMappingTests.assertEquals((int)6, (int)specifiedAttributeOverride.getColumn().getPrecision());
        OrmEmbeddedIdMappingTests.assertEquals((int)7, (int)specifiedAttributeOverride.getColumn().getScale());
        virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"state", (String)virtualAttributeOverride.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"MY_STATE_COLUMN", (String)virtualAttributeOverride.getColumn().getSpecifiedName());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"zip", (String)virtualAttributeOverride.getName());
        persistentType.getAttributeNamed("address").convertToSpecified();
        OrmEmbeddedIdMapping ormMapping = (OrmEmbeddedIdMapping)persistentType.getAttributeNamed("address").getMapping();
        OrmAttributeOverrideContainer ormOverrideContainer = ormMapping.getAttributeOverrideContainer();
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)ormOverrideContainer.getOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)ormOverrideContainer.getVirtualOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)0, (int)ormOverrideContainer.getSpecifiedOverridesSize());
        ListIterator ormOverrides = ormOverrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAttributeOverride ormOverride = (OrmVirtualAttributeOverride)ormOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"id", (String)ormOverride.getName());
        ormOverride = (OrmVirtualAttributeOverride)ormOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)ormOverride.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)ormOverride.getColumn().getDefaultName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"AnnotationTestType", (String)ormOverride.getColumn().getDefaultTable());
        OrmEmbeddedIdMappingTests.assertEquals(null, (String)ormOverride.getColumn().getColumnDefinition());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)ormOverride.getColumn().isInsertable());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)ormOverride.getColumn().isUpdatable());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)ormOverride.getColumn().isUnique());
        OrmEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)ormOverride.getColumn().isNullable());
        OrmEmbeddedIdMappingTests.assertEquals((int)255, (int)ormOverride.getColumn().getLength());
        OrmEmbeddedIdMappingTests.assertEquals((int)0, (int)ormOverride.getColumn().getPrecision());
        OrmEmbeddedIdMappingTests.assertEquals((int)0, (int)ormOverride.getColumn().getScale());
        ormOverride = (OrmVirtualAttributeOverride)ormOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"state", (String)ormOverride.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"MY_STATE_COLUMN", (String)ormOverride.getColumn().getDefaultName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"AnnotationTestType", (String)ormOverride.getColumn().getDefaultTable());
        ormOverride = (OrmVirtualAttributeOverride)ormOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"zip", (String)ormOverride.getName());
        ((OrmVirtualAttributeOverride)ormOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)ormOverrideContainer.getOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)ormOverrideContainer.getSpecifiedOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)ormOverrideContainer.getVirtualOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((String)"id", (String)((OrmAttributeOverride)ormOverrideContainer.getSpecifiedOverrides().iterator().next()).getName());
        ormOverrides = ormOverrideContainer.getVirtualOverrides().iterator();
        ormOverride = (OrmVirtualAttributeOverride)ormOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)ormOverride.getName());
        ormOverride = (OrmVirtualAttributeOverride)ormOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"state", (String)ormOverride.getName());
        ormOverride = (OrmVirtualAttributeOverride)ormOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"zip", (String)ormOverride.getName());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)ormPersistentType.getVirtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next();
        JavaEmbeddedIdMapping embeddedIdMapping = (JavaEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedIdMapping.getAttributeOverrideContainer();
        OrmEmbeddedIdMappingTests.assertEquals((String)"address", (String)embeddedIdMapping.getName());
        OrmEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)1, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        AttributeOverride specifiedAttributeOverride = (AttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)specifiedAttributeOverride.getName());
        Column column = specifiedAttributeOverride.getColumn();
        OrmEmbeddedIdMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_COLUMN_NAME, (String)column.getSpecifiedName());
        this.ormXmlResource.saveIfNecessary();
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        JavaVirtualAttributeOverride virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        JavaVirtualColumn virtualColumn = virtualAttributeOverride.getColumn();
        OrmEmbeddedIdMappingTests.assertEquals((String)"id", (String)virtualColumn.getName());
        OrmEmbeddedIdMappingTests.assertNull((Object)virtualColumn.getSpecifiedName());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"state", (String)virtualAttributeOverride.getName());
        virtualColumn = virtualAttributeOverride.getColumn();
        OrmEmbeddedIdMappingTests.assertEquals((String)"A_STATE", (String)virtualColumn.getName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"A_STATE", (String)virtualColumn.getSpecifiedName());
        OrmEmbeddedIdMappingTests.assertEquals((String)"A_STATE", (String)virtualColumn.getDefaultName());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedIdMappingTests.assertEquals((String)"zip", (String)virtualAttributeOverride.getName());
        virtualColumn = virtualAttributeOverride.getColumn();
        OrmEmbeddedIdMappingTests.assertEquals((String)"zip", (String)virtualColumn.getName());
        OrmEmbeddedIdMappingTests.assertNull((Object)virtualColumn.getSpecifiedName());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEmbeddedIdMappingTests.assertEquals((int)3, (int)ormPersistentType.getVirtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        OrmEmbeddedIdMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertEquals((String)"address", (String)embeddedMapping.getName());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityEmbeddedIdMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedAttribute("embeddedId", "address");
        OrmEmbeddedIdMappingTests.assertEquals((int)2, (int)ormPersistentType.getVirtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmEmbeddedIdMapping ormEmbeddedIdMapping = (OrmEmbeddedIdMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedIdMappingTests.assertEquals((String)"address", (String)ormEmbeddedIdMapping.getName());
        OrmEmbeddedIdMappingTests.assertEquals((int)0, (int)ormEmbeddedIdMapping.getAttributeOverrideContainer().getSpecifiedOverridesSize());
    }
}

