/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTransientMapping;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTransient;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmTransientMappingTests
extends ContextModelTestCase {
    public OrmTransientMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityTransientMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Transient"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Transient");
            }
        });
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("transient", "transientMapping");
        OrmTransientMapping xmlTransientnMapping = (OrmTransientMapping)ormPersistentAttribute.getMapping();
        XmlTransient transientResource = (XmlTransient)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getTransients().get(0);
        OrmTransientMappingTests.assertEquals((String)"transientMapping", (String)xmlTransientnMapping.getName());
        OrmTransientMappingTests.assertEquals((String)"transientMapping", (String)transientResource.getName());
        transientResource.setName("newName");
        OrmTransientMappingTests.assertEquals((String)"newName", (String)xmlTransientnMapping.getName());
        OrmTransientMappingTests.assertEquals((String)"newName", (String)transientResource.getName());
        transientResource.setName(null);
        OrmTransientMappingTests.assertNull((Object)xmlTransientnMapping.getName());
        OrmTransientMappingTests.assertNull((Object)transientResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("transient", "transientMapping");
        OrmTransientMapping xmlTransientnMapping = (OrmTransientMapping)ormPersistentAttribute.getMapping();
        XmlTransient transientResource = (XmlTransient)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getTransients().get(0);
        OrmTransientMappingTests.assertEquals((String)"transientMapping", (String)xmlTransientnMapping.getName());
        OrmTransientMappingTests.assertEquals((String)"transientMapping", (String)transientResource.getName());
        xmlTransientnMapping.setName("newName");
        OrmTransientMappingTests.assertEquals((String)"newName", (String)xmlTransientnMapping.getName());
        OrmTransientMappingTests.assertEquals((String)"newName", (String)transientResource.getName());
        xmlTransientnMapping.setName(null);
        OrmTransientMappingTests.assertNull((Object)xmlTransientnMapping.getName());
        OrmTransientMappingTests.assertNull((Object)transientResource.getName());
    }

    public void testTransientMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addSpecifiedAttribute("transient", "foo");
        OrmTransientMappingTests.assertEquals((int)2, (int)ormPersistentType.getVirtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmTransientMapping ormTransientMapping = (OrmTransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertEquals((String)"foo", (String)ormTransientMapping.getName());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmTransientMappingTests.assertEquals((int)2, (int)ormPersistentType.getVirtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next();
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertEquals((String)"id", (String)transientMapping.getName());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmTransientMappingTests.assertEquals((int)2, (int)ormPersistentType.getVirtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmTransientMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        OrmTransientMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.convertToSpecified("transient");
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmTransientMapping ormTransientMapping = (OrmTransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormTransientMapping.getName());
        OrmTransientMappingTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addSpecifiedAttribute("transient", "id");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getVirtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmTransientMapping ormTransientMapping = (OrmTransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertEquals((String)"id", (String)ormTransientMapping.getName());
    }

    public void testTransientMorphToIdMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("transient", "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("id");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmTransientMappingTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToVersionMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("transient", "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("version");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmTransientMappingTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToTransientMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("transient", "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("transient");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmTransientMappingTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("transient", "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embedded");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmTransientMappingTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("transient", "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embeddedId");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmTransientMappingTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToOneToOneMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("transient", "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToOne");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmTransientMappingTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToOneToManyMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("transient", "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToMany");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmTransientMappingTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToManyToOneMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("transient", "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToOne");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmTransientMappingTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testTransientMorphToManyToManyMapping() throws Exception {
        this.createTestEntityTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("transient", "transient");
        TransientMapping transientMapping = (TransientMapping)ormPersistentAttribute.getMapping();
        OrmTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToMany");
        OrmTransientMappingTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmTransientMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        OrmTransientMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmTransientMappingTests.assertEquals((String)"transient", (String)ormPersistentAttribute.getMapping().getName());
    }
}

