/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.CollectionMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.EnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAttributeOverride;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.ElementCollection2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyClass2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyEnumerated2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyJoinColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyTemporal2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TemporalType;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaElementCollectionMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public static final String EMBEDDABLE_TYPE_NAME = "Address";
    public static final String FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME = "test.Address";

    private ICompilationUnit createTestEntityWithElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithGenericEmbeddableElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithGenericBasicElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<String> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithNonGenericElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidGenericMapElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map<Integer, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append(GenericJavaElementCollectionMapping2_0Tests.EMBEDDABLE_TYPE_NAME).append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append(GenericJavaElementCollectionMapping2_0Tests.EMBEDDABLE_TYPE_NAME).append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map<Address, PropertyInfo> parcels;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithEntityKeyElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map<Address, PropertyInfo> parcels;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddablePropertyInfo() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("PropertyInfo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private Integer parcelNumber;").append(CR);
                sb.append(CR);
                sb.append("    private Integer size;").append(CR);
                sb.append(CR);
                sb.append("    private java.math.BigDecimal tax;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PropertyInfo.java", sourceWriter);
    }

    private void createSelfReferentialElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR).append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Foo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.List<Foo> elementCollection;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Foo.java", sourceWriter);
    }

    public GenericJavaElementCollectionMapping2_0Tests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        GenericJavaElementCollectionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaElementCollectionMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        GenericJavaElementCollectionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        GenericJavaElementCollectionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        GenericJavaElementCollectionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        GenericJavaElementCollectionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        GenericJavaElementCollectionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        GenericJavaElementCollectionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        GenericJavaElementCollectionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation(0, "javax.persistence.AssociationOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        GenericJavaElementCollectionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testUpdateSpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ElementCollection2_0Annotation elementCollectionAnnotation = (ElementCollection2_0Annotation)resourceField.getAnnotation("javax.persistence.ElementCollection");
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedTargetClass());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionAnnotation.getTargetClass());
        elementCollectionAnnotation.setTargetClass("newTargetClass");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"newTargetClass", (String)elementCollectionMapping.getSpecifiedTargetClass());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"newTargetClass", (String)elementCollectionAnnotation.getTargetClass());
        elementCollectionAnnotation.setTargetClass(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedTargetClass());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionAnnotation.getTargetClass());
    }

    public void testModifySpecifiedTargetClass() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ElementCollection2_0Annotation elementCollection = (ElementCollection2_0Annotation)resourceField.getAnnotation("javax.persistence.ElementCollection");
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedTargetClass());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass("newTargetClass");
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"newTargetClass", (String)elementCollectionMapping.getSpecifiedTargetClass());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"newTargetClass", (String)elementCollection.getTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass(null);
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedTargetClass());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getTargetClass());
    }

    public void testDefaultTargetClass() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass("foo");
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaPersistentType addressPersistentType = addressClassRef.getJavaPersistentType();
        addressPersistentType.setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testDefaultTargetClassNonGenericCollection() throws Exception {
        this.createTestEntityWithNonGenericElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testDefaultTargetClassGenericCollection() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testDefaultTargetClassNonGenericMap() throws Exception {
        this.createTestEntityWithValidNonGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testDefaultTargetClassGenericMap() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testTargetClass() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass("foo");
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"foo", (String)elementCollectionMapping.getTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass(null);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getTargetClass());
    }

    protected Embeddable getResolvedTargetEmbeddable(ElementCollectionMapping2_0 mapping) {
        return (Embeddable)ReflectionTools.executeMethod((Object)mapping, (String)"getResolvedTargetEmbeddable");
    }

    public void testResolvedTargetEmbeddable() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)this.getResolvedTargetEmbeddable(elementCollectionMapping));
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaTypeMapping addressTypeMapping = addressClassRef.getJavaPersistentType().getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)addressTypeMapping, (Object)this.getResolvedTargetEmbeddable(elementCollectionMapping));
        elementCollectionMapping.setSpecifiedTargetClass("foo");
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)this.getResolvedTargetEmbeddable(elementCollectionMapping));
        elementCollectionMapping.setSpecifiedTargetClass(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)addressTypeMapping, (Object)this.getResolvedTargetEmbeddable(elementCollectionMapping));
        elementCollectionMapping.setSpecifiedTargetClass(null);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)addressTypeMapping, (Object)this.getResolvedTargetEmbeddable(elementCollectionMapping));
    }

    public void testResolvedTargetEmbeddableWithBasicType() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)this.getResolvedTargetEmbeddable(elementCollectionMapping));
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ElementCollection2_0Annotation elementCollection = (ElementCollection2_0Annotation)resourceField.getAnnotation("javax.persistence.ElementCollection");
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedFetch());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getFetch());
        elementCollection.setFetch(org.eclipse.jpt.jpa.core.resource.java.FetchType.EAGER);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.EAGER, (Object)elementCollectionMapping.getSpecifiedFetch());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.EAGER, (Object)elementCollection.getFetch());
        elementCollection.setFetch(org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)elementCollectionMapping.getSpecifiedFetch());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)elementCollection.getFetch());
        elementCollection.setFetch(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedFetch());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ElementCollection2_0Annotation elementCollection = (ElementCollection2_0Annotation)resourceField.getAnnotation("javax.persistence.ElementCollection");
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedFetch());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getFetch());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.EAGER, (Object)elementCollectionMapping.getSpecifiedFetch());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.EAGER, (Object)elementCollection.getFetch());
        elementCollectionMapping.setSpecifiedFetch(FetchType.LAZY);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)elementCollectionMapping.getSpecifiedFetch());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)elementCollection.getFetch());
        elementCollectionMapping.setSpecifiedFetch(null);
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedFetch());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getFetch());
    }

    public void testGetValueTypeEmbeddable() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)CollectionMapping.Type.EMBEDDABLE_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testGetValueTypeNone() throws Exception {
        this.createTestEntityWithNonGenericElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)CollectionMapping.Type.NO_TYPE, (Object)elementCollectionMapping.getValueType());
        elementCollectionMapping.setSpecifiedTargetClass(EMBEDDABLE_TYPE_NAME);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)CollectionMapping.Type.EMBEDDABLE_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testGetValueTypeBasic() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)CollectionMapping.Type.BASIC_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
        resourceField.addAnnotation("javax.persistence.MapKey");
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        MapKeyAnnotation mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)mapKey);
        mapKey.setName("myMapKey");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"myMapKey", (String)elementCollectionMapping.getSpecifiedMapKey());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        mapKey.setName(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)mapKey.getName());
        mapKey.setName("myMapKey");
        resourceField.removeAnnotation("javax.persistence.MapKey");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
    }

    public void testModifyMapKey() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
        elementCollectionMapping.setSpecifiedMapKey("myMapKey");
        MapKeyAnnotation mapKeyAnnotation = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"myMapKey", (String)elementCollectionMapping.getSpecifiedMapKey());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"myMapKey", (String)mapKeyAnnotation.getName());
        elementCollectionMapping.setSpecifiedMapKey(null);
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        mapKeyAnnotation = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)mapKeyAnnotation.getName());
        elementCollectionMapping.setNoMapKey(true);
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping2_0 = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        Iterator mapKeyNames = elementCollectionMapping2_0.getCandidateMapKeyNames().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping2_0 = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        Iterator mapKeyNames = elementCollectionMapping2_0.getCandidateMapKeyNames().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        elementCollectionMapping2_0.setSpecifiedTargetClass(EMBEDDABLE_TYPE_NAME);
        mapKeyNames = elementCollectionMapping2_0.getCandidateMapKeyNames().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        elementCollectionMapping2_0.setSpecifiedTargetClass("String");
        mapKeyNames = elementCollectionMapping2_0.getCandidateMapKeyNames().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
        resourceField.addAnnotation("javax.persistence.MapKeyClass");
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        MapKeyClass2_0Annotation mapKeyClass = (MapKeyClass2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)mapKeyClass);
        mapKeyClass.setValue("myMapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"myMapKeyClass", (String)elementCollectionMapping.getSpecifiedMapKeyClass());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"myMapKeyClass", (String)mapKeyClass.getValue());
        mapKeyClass.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)mapKeyClass.getValue());
        mapKeyClass.setValue("myMapKeyClass");
        resourceField.removeAnnotation("javax.persistence.MapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
        elementCollectionMapping.setSpecifiedMapKeyClass("String");
        MapKeyClass2_0Annotation mapKeyClass = (MapKeyClass2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"String", (String)elementCollectionMapping.getSpecifiedMapKeyClass());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"String", (String)mapKeyClass.getValue());
        elementCollectionMapping.setSpecifiedMapKeyClass(null);
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testDefaultMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)elementCollectionMapping.getDefaultMapKeyClass());
        elementCollectionMapping.setSpecifiedMapKeyClass("foo");
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)elementCollectionMapping.getDefaultMapKeyClass());
    }

    public void testDefaultMapKeyClassCollectionType() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getDefaultMapKeyClass());
    }

    public void testMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)elementCollectionMapping.getMapKeyClass());
        elementCollectionMapping.setSpecifiedMapKeyClass("foo");
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"foo", (String)elementCollectionMapping.getMapKeyClass());
        elementCollectionMapping.setSpecifiedMapKeyClass(null);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)elementCollectionMapping.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        Orderable2_0 orderable = (Orderable2_0)elementCollectionMapping.getOrderable();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        orderable.setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = orderable.getOrderColumn();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals(null, (String)orderColumn.getSpecifiedName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getDefaultName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)orderColumn.getTable());
        orderColumn.setSpecifiedName("FOO");
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)orderColumn.getSpecifiedName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getDefaultName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)orderColumn.getTable());
    }

    public void testGetValueColumn() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getValueColumn().getSpecifiedName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)elementCollectionMapping.getValueColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_id", (String)elementCollectionMapping.getValueColumn().getTable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ColumnAnnotation column = (ColumnAnnotation)resourceField.addAnnotation("javax.persistence.Column");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"foo", (String)elementCollectionMapping.getValueColumn().getSpecifiedName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"foo", (String)elementCollectionMapping.getValueColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)elementCollectionMapping.getValueColumn().getDefaultName());
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"addresses", (String)resourceField.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ReadOnlyAttributeOverride defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        Embeddable embeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)embeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"addresses", (String)resourceField.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)6, (int)attributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)6, (int)attributeOverrideContainer.getOverridesSize());
    }

    public void testVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("state.name");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)attributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ((AttributeOverride)attributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.abbr", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"zip", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverrides.next();
        ((VirtualAttributeOverride)virtualAttributeOverrides.next()).convertToSpecified();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        JavaPersistentType persistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentType.getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        ReadOnlyAttributeOverride virtualAttributeOverride = (ReadOnlyAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (ReadOnlyAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (ReadOnlyAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.abbr", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (ReadOnlyAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverrides.hasNext());
        JavaPersistentType addressPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        EmbeddedMapping nestedEmbeddedMapping = (EmbeddedMapping)addressPersistentType.getAttributeNamed("state").getMapping();
        AttributeOverrideContainer nestedAttributeOverrideContainer = nestedEmbeddedMapping.getAttributeOverrideContainer();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)2, (int)nestedAttributeOverrideContainer.getVirtualOverridesSize());
        virtualAttributeOverrides = nestedAttributeOverrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverride = (ReadOnlyAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (ReadOnlyAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"abbr", (String)virtualAttributeOverride.getName());
        JavaPersistentType statePersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        BasicMapping abbrMapping = (BasicMapping)statePersistentType.getAttributeNamed("abbr").getMapping();
        abbrMapping.getColumn().setSpecifiedName("BLAH");
        abbrMapping.getColumn().setSpecifiedTable("BLAH_TABLE");
        abbrMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        abbrMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        abbrMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        abbrMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        abbrMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        abbrMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        abbrMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        abbrMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        virtualAttributeOverride = ((EmbeddedMapping)addressPersistentType.getAttributeNamed("state").getMapping()).getAttributeOverrideContainer().getOverrideNamed("abbr");
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"abbr", (String)virtualAttributeOverride.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
    }

    public void testGetMapKeyColumn() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)elementCollectionMapping.getMapKeyColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)elementCollectionMapping.getMapKeyColumn().getTable());
        elementCollectionMapping.getCollectionTable().setSpecifiedName("MY_COLLECTION_TABLE");
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"MY_COLLECTION_TABLE", (String)elementCollectionMapping.getMapKeyColumn().getTable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"foo", (String)elementCollectionMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"foo", (String)elementCollectionMapping.getMapKeyColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)elementCollectionMapping.getMapKeyColumn().getDefaultName());
    }

    public void testMapKeyValueSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        ListIterator specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BLAH");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
    }

    public void testMapKeyValueVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcels", (String)resourceField.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        ReadOnlyAttributeOverride defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_parcels", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        Embeddable addressEmbeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)addressEmbeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcels", (String)resourceField.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_parcels", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_parcels", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        classRefs.next();
        Embeddable propertyInfoEmbeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping parcelNumberMapping = (BasicMapping)propertyInfoEmbeddable.getPersistentType().getAttributeNamed("parcelNumber").getMapping();
        parcelNumberMapping.getColumn().setSpecifiedName("FOO1");
        parcelNumberMapping.getColumn().setSpecifiedTable("BAR1");
        parcelNumberMapping.getColumn().setColumnDefinition("COLUMN_DEF1");
        parcelNumberMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        parcelNumberMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        parcelNumberMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        parcelNumberMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        parcelNumberMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        parcelNumberMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        parcelNumberMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcels", (String)resourceField.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO1", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR1", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"COLUMN_DEF1", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        parcelNumberMapping.getColumn().setSpecifiedName(null);
        parcelNumberMapping.getColumn().setSpecifiedTable(null);
        parcelNumberMapping.getColumn().setColumnDefinition(null);
        parcelNumberMapping.getColumn().setSpecifiedInsertable(null);
        parcelNumberMapping.getColumn().setSpecifiedUpdatable(null);
        parcelNumberMapping.getColumn().setSpecifiedUnique(null);
        parcelNumberMapping.getColumn().setSpecifiedNullable(null);
        parcelNumberMapping.getColumn().setSpecifiedLength(null);
        parcelNumberMapping.getColumn().setSpecifiedPrecision(null);
        parcelNumberMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_parcels", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        annotation = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("value.parcelNumber");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)valueAttributeOverrideContainer.getSpecifiedOverridesSize());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)mapKeyAttributeOverrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)2, (int)valueAttributeOverrideContainer.getSpecifiedOverridesSize());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)1, (int)mapKeyAttributeOverrideContainer.getSpecifiedOverridesSize());
    }

    public void testMapKeyValueAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)valueAttributeOverrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)5, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)5, (int)valueAttributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)5, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)6, (int)valueAttributeOverrideContainer.getOverridesSize());
    }

    public void testMapKeyValueVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)valueAttributeOverrideContainer.getVirtualOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)valueAttributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.city");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.parcelNumber");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)2, (int)valueAttributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.state.name");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("size");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)2, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)1, (int)valueAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        ((VirtualAttributeOverride)valueOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)mapKeyOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)valueOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)mapKeyOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator overrideAnnotations = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"value.parcelNumber", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"value.size", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"key.state.name", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)overrideAnnotations.hasNext());
        ((AttributeOverride)valueOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        ((AttributeOverride)mapKeyOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        overrideAnnotations = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"value.size", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"key.state.name", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)overrideAnnotations.hasNext());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcelNumber", (String)((VirtualAttributeOverride)valueOverrideContainer.getVirtualOverrides().iterator().next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)2, (int)valueOverrideContainer.getVirtualOverridesSize());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)((VirtualAttributeOverride)mapKeyOverrideContainer.getVirtualOverrides().iterator().next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)mapKeyOverrideContainer.getVirtualOverridesSize());
        ((AttributeOverride)valueOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        ((AttributeOverride)mapKeyOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        overrideAnnotations = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)overrideAnnotations.hasNext());
        ListIterator virtualAttributeOverrides = valueOverrideContainer.getVirtualOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcelNumber", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"size", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"tax", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)valueOverrideContainer.getVirtualOverridesSize());
        virtualAttributeOverrides = mapKeyOverrideContainer.getVirtualOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.abbr", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"zip", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)4, (int)mapKeyOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        ((VirtualAttributeOverride)valueAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)valueAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ListIterator specifiedOverrides = valueAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcelNumber", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"size", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        this.getJpaProject().synchronizeContextModel();
        ListIterator overrideAnnotations = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"value.size", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"value.parcelNumber", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"key.state.name", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)overrideAnnotations.hasNext());
        specifiedOverrides = valueAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"size", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcelNumber", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
        resourceField.moveAnnotation(3, 2, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        this.getJpaProject().synchronizeContextModel();
        overrideAnnotations = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"value.size", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"value.parcelNumber", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"key.state.name", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)overrideAnnotations.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)overrideAnnotations.hasNext());
        specifiedOverrides = valueAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"size", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"parcelNumber", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"city", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
    }

    public void testSelfReferentialElementCollection() throws Exception {
        this.createSelfReferentialElementCollection();
        this.addXmlClassRef("test.Foo");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("elementCollection").getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.getAllOverridableAttributeMappingNames().iterator().hasNext());
    }

    public void testSetSpecifiedMapKeyEnumerated() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getMapKeyConverter().getType());
        elementCollectionMapping.setMapKeyConverter(EnumeratedConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated");
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)enumerated);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals(null, (Object)enumerated.getValue());
        ((EnumeratedConverter)elementCollectionMapping.getMapKeyConverter()).setSpecifiedEnumType(EnumType.STRING);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING, (Object)enumerated.getValue());
        ((EnumeratedConverter)elementCollectionMapping.getMapKeyConverter()).setSpecifiedEnumType(null);
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)enumerated.getValue());
        elementCollectionMapping.setMapKeyConverter(null);
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
    }

    public void testGetSpecifiedMapKeyEnumeratedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getMapKeyConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyEnumerated");
        enumerated.setValue(org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)EnumType.STRING, (Object)((EnumeratedConverter)elementCollectionMapping.getMapKeyConverter()).getSpecifiedEnumType());
        enumerated.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)((EnumeratedConverter)elementCollectionMapping.getMapKeyConverter()).getSpecifiedEnumType());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertSame((Object)elementCollectionMapping, (Object)persistentAttribute.getMapping());
    }

    public void testSetMapKeyTemporal() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getMapKeyConverter().getType());
        elementCollectionMapping.setMapKeyConverter(TemporalConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyTemporal2_0Annotation temporal = (MapKeyTemporal2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyTemporal");
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)temporal);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals(null, (Object)temporal.getValue());
        ((TemporalConverter)elementCollectionMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        ((TemporalConverter)elementCollectionMapping.getMapKeyConverter()).setTemporalType(null);
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyTemporal"));
    }

    public void testGetMapKeyTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getMapKeyConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyTemporal2_0Annotation temporal = (MapKeyTemporal2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyTemporal");
        temporal.setValue(TemporalType.TIME);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((TemporalConverter)elementCollectionMapping.getMapKeyConverter()).getTemporalType());
        temporal.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaElementCollectionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyTemporal"));
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)((TemporalConverter)elementCollectionMapping.getMapKeyConverter()).getTemporalType());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertSame((Object)elementCollectionMapping, (Object)persistentAttribute.getMapping());
    }

    public void testSpecifiedMapKeyJoinColumns() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        ListIterator specifiedMapKeyJoinColumns = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyJoinColumn2_0Annotation joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
    }

    public void testSpecifiedMapKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)elementCollectionMapping.getSpecifiedMapKeyJoinColumnsSize());
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(0);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)1, (int)elementCollectionMapping.getSpecifiedMapKeyJoinColumnsSize());
        elementCollectionMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)0, (int)elementCollectionMapping.getSpecifiedMapKeyJoinColumnsSize());
    }

    public void testMapKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithEntityKeyElementCollectionMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)1, (int)elementCollectionMapping.getMapKeyJoinColumnsSize());
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(0);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)1, (int)elementCollectionMapping.getMapKeyJoinColumnsSize());
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(0);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)2, (int)elementCollectionMapping.getMapKeyJoinColumnsSize());
        elementCollectionMapping.removeSpecifiedMapKeyJoinColumn(0);
        elementCollectionMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)1, (int)elementCollectionMapping.getMapKeyJoinColumnsSize());
    }

    public void testAddSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("BAR");
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator joinColumnsIterator = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testAddSpecifiedMapKeyJoinColumn2() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator joinColumnsIterator = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testRemoveSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)resourceField.getAnnotationsSize("javax.persistence.MapKeyJoinColumn"));
        elementCollectionMapping.removeSpecifiedMapKeyJoinColumn(1);
        ListIterator joinColumnResources = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumnResources.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)joinColumnResources.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnResources.hasNext());
        ListIterator joinColumnsIterator = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        elementCollectionMapping.removeSpecifiedMapKeyJoinColumn(1);
        joinColumnResources = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumnResources.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumnsIterator = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        elementCollectionMapping.removeSpecifiedMapKeyJoinColumn(0);
        joinColumnResources = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumnsIterator = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.MapKeyJoinColumn"));
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator javaJoinColumns = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaJoinColumns));
        elementCollectionMapping.moveSpecifiedMapKeyJoinColumn(2, 0);
        ListIterator joinColumns = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        javaJoinColumns = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        elementCollectionMapping.moveSpecifiedMapKeyJoinColumn(0, 1);
        joinColumns = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        javaJoinColumns = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
    }

    public void testUpdateSpecifiedMapKeyJoinColumns() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ((MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn")).setName("FOO");
        ((MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(1, "javax.persistence.MapKeyJoinColumn")).setName("BAR");
        ((MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(2, "javax.persistence.MapKeyJoinColumn")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator joinColumnsIterator = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.moveAnnotation(2, 0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.moveAnnotation(0, 1, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testMapKeyJoinColumnIsDefault() throws Exception {
        this.createTestEntityWithEntityKeyElementCollectionMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        GenericJavaElementCollectionMapping2_0Tests.assertTrue((boolean)elementCollectionMapping.getDefaultMapKeyJoinColumn().isDefault());
        elementCollectionMapping.addSpecifiedMapKeyJoinColumn(0);
        JoinColumn specifiedJoinColumn = (JoinColumn)elementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator().next();
        GenericJavaElementCollectionMapping2_0Tests.assertFalse((boolean)specifiedJoinColumn.isDefault());
        GenericJavaElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionMapping.getDefaultMapKeyJoinColumn());
    }
}

