/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.AssociationOverride;
import org.eclipse.jpt.jpa.core.context.AssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.MappedSuperclass;
import org.eclipse.jpt.jpa.core.context.VirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaNamedQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.jpa2.context.Cacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.CacheableHolder2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.LockModeType2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.NamedQuery2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.SharedCacheMode;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.AssociationOverride2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.Cacheable2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.LockModeType_2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.NamedQuery2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaEntity2_0Tests
extends Generic2_0ContextModelTestCase {
    protected static final String SUB_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_SUB_TYPE_NAME = "test.AnnotationTestTypeChild";

    public GenericJavaEntity2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.OneToOne", "javax.persistence.ManyToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne");
                sb.append(CR);
                sb.append("    private int address2;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany");
                sb.append(CR);
                sb.append("    private int address3;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany");
                sb.append(CR);
                sb.append("    private int address4;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private ICompilationUnit createTestAbstractEntityTablePerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType", "javax.persistence.OneToOne", "javax.persistence.ManyToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)");
                sb.append("abstract");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne");
                sb.append(CR);
                sb.append("    private int address2;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany");
                sb.append(CR);
                sb.append("    private int address3;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany");
                sb.append(CR);
                sb.append("    private int address4;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append(GenericJavaEntity2_0Tests.SUB_TYPE_NAME).append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    private void createTestMappedSuperclassCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.MappedSuperclass");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@MappedSuperclass");
                sb.append(CR);
                sb.append("public class ").append("Customer ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestMappedSuperclassCustomerWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.MappedSuperclass");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@MappedSuperclass");
                sb.append(CR);
                sb.append("public class ").append("Customer ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestEntityLongTimeCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("LongTimeCustomer extends Customer ");
                sb.append("{}");
            }
        };
        this.javaProject.createCompilationUnit("test", "LongTimeCustomer.java", sourceWriter);
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OneToOne");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String street;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private ZipCode zipCode;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableZipCode() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("ZipCode").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String zip;").append(CR);
                sb.append(CR);
                sb.append("    private String plusfour;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "ZipCode.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithAssociationOverride() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.AssociationOverride", "javax.persistence.JoinTable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@AssociationOverride(name=\"a\", joinTable=@JoinTable)");
            }
        });
    }

    private LockModeType2_0 lockModeOf(NamedQuery2_0Annotation resourceQuery) {
        return resourceQuery == null ? null : LockModeType2_0.fromJavaResourceModel((LockModeType_2_0)resourceQuery.getLockMode());
    }

    public void testAddNamedQuery2_0() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        NamedQuery2_0 namedQuery1 = (NamedQuery2_0)entity.getQueryContainer().addNamedQuery(0);
        namedQuery1.setName("FOO");
        namedQuery1.setSpecifiedLockMode(LockModeType2_0.OPTIMISTIC);
        ListIterator javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        NamedQuery2_0Annotation queryAnnotation = (NamedQuery2_0Annotation)javaNamedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)queryAnnotation.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)this.lockModeOf(queryAnnotation));
        NamedQuery2_0 namedQuery2 = (NamedQuery2_0)entity.getQueryContainer().addNamedQuery(0);
        namedQuery2.setName("BAR");
        namedQuery2.setSpecifiedLockMode(LockModeType2_0.READ);
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        queryAnnotation = (NamedQuery2_0Annotation)javaNamedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)queryAnnotation.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.READ, (Object)this.lockModeOf(queryAnnotation));
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((NamedQuery2_0Annotation)javaNamedQueries.next()).getName());
        NamedQuery2_0 namedQuery3 = (NamedQuery2_0)entity.getQueryContainer().addNamedQuery(1);
        namedQuery3.setName("BAZ");
        namedQuery3.setSpecifiedLockMode(LockModeType2_0.WRITE);
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((NamedQuery2_0Annotation)javaNamedQueries.next()).getName());
        queryAnnotation = (NamedQuery2_0Annotation)javaNamedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)queryAnnotation.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.WRITE, (Object)this.lockModeOf(queryAnnotation));
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((NamedQuery2_0Annotation)javaNamedQueries.next()).getName());
        ListIterator namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        GenericJavaEntity2_0Tests.assertEquals((Object)namedQuery2, namedQueries.next());
        GenericJavaEntity2_0Tests.assertEquals((Object)namedQuery3, namedQueries.next());
        GenericJavaEntity2_0Tests.assertEquals((Object)namedQuery1, namedQueries.next());
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        entity.getQueryContainer().addNamedNativeQuery(0).setName("foo");
    }

    public void testRemoveNamedQuery2_0() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        entity.getQueryContainer().addNamedQuery(0).setName("FOO");
        NamedQuery2_0 namedQuery1 = (NamedQuery2_0)entity.getQueryContainer().addNamedQuery(1);
        namedQuery1.setName("BAR");
        namedQuery1.setSpecifiedLockMode(LockModeType2_0.READ);
        NamedQuery2_0 namedQuery2 = (NamedQuery2_0)entity.getQueryContainer().addNamedQuery(2);
        namedQuery2.setName("BAZ");
        namedQuery2.setSpecifiedLockMode(LockModeType2_0.OPTIMISTIC);
        ListIterator javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaNamedQueries));
        entity.getQueryContainer().removeNamedQuery(0);
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        GenericJavaEntity2_0Tests.assertEquals((int)2, (int)CollectionTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        NamedQuery2_0Annotation annotation1 = (NamedQuery2_0Annotation)javaNamedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)annotation1.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.READ, (Object)this.lockModeOf(annotation1));
        NamedQuery2_0Annotation annotation2 = (NamedQuery2_0Annotation)javaNamedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)annotation2.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)this.lockModeOf(annotation2));
        entity.getQueryContainer().removeNamedQuery(0);
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        GenericJavaEntity2_0Tests.assertEquals((int)1, (int)CollectionTools.size((Iterator)javaNamedQueries));
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        annotation2 = (NamedQuery2_0Annotation)javaNamedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)annotation2.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)this.lockModeOf(annotation2));
        entity.getQueryContainer().removeNamedQuery(0);
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)CollectionTools.size((Iterator)javaNamedQueries));
    }

    public void testMoveNamedQuery2_0() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        entity.getQueryContainer().addNamedQuery(0).setName("FOO");
        NamedQuery2_0 namedQuery1 = (NamedQuery2_0)entity.getQueryContainer().addNamedQuery(1);
        namedQuery1.setName("BAR");
        namedQuery1.setSpecifiedLockMode(LockModeType2_0.OPTIMISTIC);
        entity.getQueryContainer().addNamedQuery(2).setName("BAZ");
        ListIterator javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaNamedQueries));
        entity.getQueryContainer().moveNamedQuery(2, 0);
        ListIterator namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        namedQuery1 = (NamedQuery2_0)namedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)namedQuery1.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)namedQuery1.getLockMode());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        NamedQuery2_0Annotation annotation1 = (NamedQuery2_0Annotation)javaNamedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)annotation1.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)this.lockModeOf(annotation1));
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((NamedQuery2_0Annotation)javaNamedQueries.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((NamedQuery2_0Annotation)javaNamedQueries.next()).getName());
        entity.getQueryContainer().moveNamedQuery(0, 1);
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((JavaNamedQuery)namedQueries.next()).getName());
        namedQuery1 = (NamedQuery2_0)namedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)namedQuery1.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)namedQuery1.getLockMode());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        javaNamedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((NamedQuery2_0Annotation)javaNamedQueries.next()).getName());
        annotation1 = (NamedQuery2_0Annotation)javaNamedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)annotation1.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)this.lockModeOf(annotation1));
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((NamedQuery2_0Annotation)javaNamedQueries.next()).getName());
    }

    public void testUpdateNamedQueries2_0() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)entity.getPersistenceUnit().getQueriesSize());
        ((NamedQuery2_0Annotation)resourceType.addAnnotation(0, "javax.persistence.NamedQuery")).setName("FOO");
        ((NamedQuery2_0Annotation)resourceType.addAnnotation(1, "javax.persistence.NamedQuery")).setName("BAR");
        NamedQuery2_0Annotation annotation1 = (NamedQuery2_0Annotation)resourceType.addAnnotation(1, "javax.persistence.NamedQuery");
        annotation1.setName("BAZ");
        annotation1.setLockMode(LockModeType_2_0.OPTIMISTIC);
        this.getJpaProject().synchronizeContextModel();
        ListIterator namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        NamedQuery2_0 namedQuery1 = (NamedQuery2_0)namedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)namedQuery1.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)namedQuery1.getLockMode());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)namedQueries.hasNext());
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)entity.getPersistenceUnit().getQueriesSize());
        resourceType.moveAnnotation(2, 0, "javax.persistence.NamedQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        namedQuery1 = (NamedQuery2_0)namedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)namedQuery1.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)namedQuery1.getLockMode());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)namedQueries.hasNext());
        resourceType.moveAnnotation(0, 1, "javax.persistence.NamedQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        namedQuery1 = (NamedQuery2_0)namedQueries.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)namedQuery1.getName());
        GenericJavaEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)namedQuery1.getLockMode());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)namedQueries.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.NamedQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((JavaNamedQuery)namedQueries.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)namedQueries.hasNext());
        GenericJavaEntity2_0Tests.assertEquals((int)2, (int)entity.getPersistenceUnit().getQueriesSize());
        resourceType.removeAnnotation(1, "javax.persistence.NamedQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((JavaNamedQuery)namedQueries.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)namedQueries.hasNext());
        GenericJavaEntity2_0Tests.assertEquals((int)1, (int)entity.getPersistenceUnit().getQueriesSize());
        resourceType.removeAnnotation(0, "javax.persistence.NamedQuery");
        this.getJpaProject().synchronizeContextModel();
        namedQueries = entity.getQueryContainer().getNamedQueries().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)namedQueries.hasNext());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)entity.getPersistenceUnit().getQueriesSize());
    }

    public void testNamedQueries2_0Size() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)entity.getQueryContainer().getNamedQueriesSize());
        ((NamedQuery2_0Annotation)resourceType.addAnnotation(0, "javax.persistence.NamedQuery")).setName("FOO");
        ((NamedQuery2_0Annotation)resourceType.addAnnotation(1, "javax.persistence.NamedQuery")).setName("BAR");
        ((NamedQuery2_0Annotation)resourceType.addAnnotation(2, "javax.persistence.NamedQuery")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)entity.getQueryContainer().getNamedQueriesSize());
    }

    public void testAttributeMappingKeyAllowed() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = (Entity)this.getJavaPersistentType().getMapping();
        GenericJavaEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basic"));
        GenericJavaEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("id"));
        GenericJavaEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("elementCollection"));
        GenericJavaEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embedded"));
        GenericJavaEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embeddedId"));
        GenericJavaEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("version"));
        GenericJavaEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("transient"));
        GenericJavaEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToOne"));
        GenericJavaEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToOne"));
        GenericJavaEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToMany"));
        GenericJavaEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToMany"));
    }

    public void testOverridableAttributes() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getOverridableAttributeNames().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAttributes.hasNext());
        this.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributes = this.getJavaEntity().getOverridableAttributeNames().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testOverridableAttributeNames() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributeNames = this.getJavaEntity().getOverridableAttributeNames().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAttributeNames.hasNext());
        this.getJavaEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributeNames = this.getJavaEntity().getOverridableAttributeNames().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testAllOverridableAttributes() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributesTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAttributes.hasNext());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity abstractEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        overridableAttributes = abstractEntity.getAllOverridableAttributeNames().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAssociationsTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().getAllOverridableAssociationNames().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"address3", (String)((String)overridableAssociations.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"address4", (String)((String)overridableAssociations.next()));
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAssociations.hasNext());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity abstractEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        overridableAssociations = abstractEntity.getAllOverridableAssociationNames().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"address3", (String)((String)overridableAssociations.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"address4", (String)((String)overridableAssociations.next()));
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testAllOverridableAttributesMappedSuperclassInOrmXml() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributeNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributeNames = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((String)overridableAttributeNames.next()));
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceType.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAttributeOverrideContainer overrideContainer = javaEntity.getAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        GenericJavaEntity2_0Tests.assertNull((Object)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        MappedSuperclass mappedSuperclass = (MappedSuperclass)this.getJavaPersistentType().getMapping();
        BasicMapping idMapping = (BasicMapping)mappedSuperclass.getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.getColumn().setSpecifiedTable("BAR");
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        GenericJavaEntity2_0Tests.assertNull((Object)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTable());
        idMapping.getColumn().setSpecifiedName(null);
        idMapping.getColumn().setSpecifiedTable(null);
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        GenericJavaEntity2_0Tests.assertNull((Object)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride"));
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride.convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testVirtualAttributeOverridesEntityHierachy() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAttributeOverrideContainer overrideContainer = javaEntity.getAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        GenericJavaEntity2_0Tests.assertNull((Object)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        JavaEntity superclass = (JavaEntity)this.getJavaPersistentType().getMapping();
        BasicMapping idMapping = (BasicMapping)superclass.getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.getColumn().setSpecifiedTable("BAR");
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        GenericJavaEntity2_0Tests.assertNull((Object)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTable());
        idMapping.getColumn().setSpecifiedName(null);
        idMapping.getColumn().setSpecifiedTable(null);
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        GenericJavaEntity2_0Tests.assertNull((Object)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride"));
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride.convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)overrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEntity2_0Tests.assertEquals((int)2, (int)overrideContainer.getSpecifiedOverridesSize());
    }

    public void testVirtualAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        ListIterator attributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverrides.next();
        ((VirtualAttributeOverride)virtualAttributeOverrides.next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        ListIterator attributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)CollectionTools.size((Iterator)resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator()));
        ((AttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        ListIterator attributeOverrideResources = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrideResources.hasNext());
        ListIterator attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrideResources = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)attributeOverrideResources.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrideResources = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrideResources.hasNext());
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        GenericJavaEntity2_0Tests.assertNull((Object)resourceType.getAnnotation(0, "javax.persistence.AttributeOverride"));
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        ListIterator javaAttributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaAttributeOverrides));
        overrideContainer.moveSpecifiedOverride(2, 0);
        ListIterator attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((AttributeOverride)attributeOverrides.next()).getName());
        javaAttributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        overrideContainer.moveSpecifiedOverride(0, 1);
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((AttributeOverride)attributeOverrides.next()).getName());
        javaAttributeOverrides = resourceType.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)((AttributeOverrideAnnotation)javaAttributeOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        ((AttributeOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AttributeOverride")).setName("FOO");
        ((AttributeOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AttributeOverride")).setName("BAR");
        ((AttributeOverrideAnnotation)resourceType.addAnnotation(2, "javax.persistence.AttributeOverride")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.moveAnnotation(2, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.moveAnnotation(0, 1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AttributeOverride)attributeOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeOverrideContainer overrideContainer = this.getJavaEntity().getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = overrideContainer.getVirtualOverrides().iterator();
        JavaVirtualAttributeOverride virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        GenericJavaEntity2_0Tests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
        ((JavaVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        AttributeOverride specifiedAttributeOverride = (AttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverride.isVirtual());
        virtualAttributeOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (JavaVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        GenericJavaEntity2_0Tests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
    }

    public void testOverridableAssociations() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().getOverridableAssociationNames().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testOverridableAssociationNames() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociationNames = this.getJavaEntity().getOverridableAssociationNames().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociationNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAssociationNames = this.getJavaEntity().getAllOverridableAssociationNames().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)((String)overridableAssociationNames.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)((String)overridableAssociationNames.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"address3", (String)((String)overridableAssociationNames.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"address4", (String)((String)overridableAssociationNames.next()));
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociationsMappedSuperclassInOrmXml() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        Iterator overridableAssociations = this.getJavaEntity().getAllOverridableAssociationNames().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"address3", (String)((String)overridableAssociations.next()));
        GenericJavaEntity2_0Tests.assertEquals((String)"address4", (String)((String)overridableAssociations.next()));
        GenericJavaEntity2_0Tests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceType.moveAnnotation(1, 0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        JavaEntity javaEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaAssociationOverrideContainer overrideContainer = javaEntity.getAssociationOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        GenericJavaEntity2_0Tests.assertNull((Object)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride"));
        GenericJavaEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        GenericJavaEntity2_0Tests.assertNull((Object)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride"));
        GenericJavaEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getVirtualOverridesSize());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)resourceType.getName());
        GenericJavaEntity2_0Tests.assertNull((Object)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride"));
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride.convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAssociationOverridesSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)overrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("FOO");
        associationOverride = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEntity2_0Tests.assertEquals((int)2, (int)overrideContainer.getSpecifiedOverridesSize());
    }

    public void testVirtualAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        GenericJavaEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        GenericJavaEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        AssociationOverrideAnnotation annotation = (AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride");
        annotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEntity2_0Tests.assertEquals((int)5, (int)overrideContainer.getOverridesSize());
    }

    public void testAssociationOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        ListIterator associationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAssociationOverrides.next();
        ((VirtualAssociationOverride)virtualAssociationOverrides.next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        ListIterator associationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        GenericJavaEntity2_0Tests.assertEquals((int)2, (int)CollectionTools.size((Iterator)resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator()));
        ((AssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        ListIterator associationOverrideResources = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)associationOverrideResources.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)associationOverrideResources.hasNext());
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        ((AssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        associationOverrideResources = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)associationOverrideResources.hasNext());
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        GenericJavaEntity2_0Tests.assertNull((Object)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride"));
    }

    public void testMoveSpecifiedAssociationOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(FULLY_QUALIFIED_SUB_TYPE_NAME, JavaResourceAnnotatedElement.Kind.TYPE);
        ListIterator javaAssociationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((int)2, (int)CollectionTools.size((Iterator)javaAssociationOverrides));
        overrideContainer.moveSpecifiedOverride(1, 0);
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)((AssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        overrideContainer.moveSpecifiedOverride(0, 1);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)((AssociationOverride)associationOverrides.next()).getName());
        javaAssociationOverrides = resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)((AssociationOverrideAnnotation)javaAssociationOverrides.next()).getName());
    }

    public void testUpdateSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        ((AssociationOverrideAnnotation)resourceType.addAnnotation(0, "javax.persistence.AssociationOverride")).setName("FOO");
        ((AssociationOverrideAnnotation)resourceType.addAnnotation(1, "javax.persistence.AssociationOverride")).setName("BAR");
        ((AssociationOverrideAnnotation)resourceType.addAnnotation(2, "javax.persistence.AssociationOverride")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.moveAnnotation(2, 0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.moveAnnotation(0, 1, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.removeAnnotation(1, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericJavaEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        JavaVirtualAssociationOverride virtualAssociationOverride = (JavaVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericJavaEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (JavaVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)virtualAssociationOverride.getName());
        GenericJavaEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (JavaVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address3", (String)virtualAssociationOverride.getName());
        GenericJavaEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (JavaVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address4", (String)virtualAssociationOverride.getName());
        GenericJavaEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        GenericJavaEntity2_0Tests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
        ((JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverride.isVirtual());
        virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAssociationOverride = (JavaVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address2", (String)virtualAssociationOverride.getName());
        GenericJavaEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (JavaVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address3", (String)virtualAssociationOverride.getName());
        GenericJavaEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (JavaVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address4", (String)virtualAssociationOverride.getName());
        GenericJavaEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        GenericJavaEntity2_0Tests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestMappedSuperclassCustomer();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.LongTimeCustomer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        specifiedClassRefs.next();
        JavaPersistentType longTimeCustomerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType addressPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType zipCodePersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        AttributeOverrideContainer attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        GenericJavaEntity2_0Tests.assertEquals((int)6, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address.street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address.city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address.zipCode.zip", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTable());
        GenericJavaEntity2_0Tests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEntity2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTable("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (VirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        GenericJavaEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericJavaEntity2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEntity2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEntity2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEntity2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        AttributeOverride specifiedAttributeOverride = ((VirtualAttributeOverride)((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour")).convertToSpecified();
        specifiedAttributeOverride.getColumn().setSpecifiedName("BLAH_OVERRIDE");
        specifiedAttributeOverride.getColumn().setSpecifiedTable("BLAH_TABLE_OVERRIDE");
        specifiedAttributeOverride.getColumn().setColumnDefinition("COLUMN_DEFINITION_OVERRIDE");
        attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (VirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        GenericJavaEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericJavaEntity2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEntity2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        specifiedAttributeOverride = virtualAttributeOverride.convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.isVirtual());
        GenericJavaEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)specifiedAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedTable());
        GenericJavaEntity2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        GenericJavaEntity2_0Tests.assertEquals((int)255, (int)specifiedAttributeOverride.getColumn().getLength());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getPrecision());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getScale());
    }

    public void testNestedVirtualAttributeOverridesElementCollection() throws Exception {
        this.createTestMappedSuperclassCustomerWithElementCollection();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.LongTimeCustomer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        specifiedClassRefs.next();
        JavaPersistentType longTimeCustomerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType addressPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        JavaPersistentType zipCodePersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        AttributeOverrideContainer attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        GenericJavaEntity2_0Tests.assertEquals((int)6, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address.street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address.city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address.zipCode.zip", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTable());
        GenericJavaEntity2_0Tests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEntity2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTable("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (VirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        GenericJavaEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericJavaEntity2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEntity2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEntity2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEntity2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        AttributeOverride specifiedAttributeOverride = ((VirtualAttributeOverride)((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour")).convertToSpecified();
        specifiedAttributeOverride.getColumn().setSpecifiedName("BLAH_OVERRIDE");
        specifiedAttributeOverride.getColumn().setSpecifiedTable("BLAH_TABLE_OVERRIDE");
        specifiedAttributeOverride.getColumn().setColumnDefinition("COLUMN_DEFINITION_OVERRIDE");
        attributeOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (VirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        GenericJavaEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)virtualAttributeOverride.getColumn().getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericJavaEntity2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericJavaEntity2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        specifiedAttributeOverride = virtualAttributeOverride.convertToSpecified();
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.isVirtual());
        GenericJavaEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)specifiedAttributeOverride.getName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedTable());
        GenericJavaEntity2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        GenericJavaEntity2_0Tests.assertEquals((int)255, (int)specifiedAttributeOverride.getColumn().getLength());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getPrecision());
        GenericJavaEntity2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getScale());
    }

    public void testNestedVirtualAssociationOverrides() throws Exception {
        this.createTestMappedSuperclassCustomer();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.LongTimeCustomer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        specifiedClassRefs.next();
        JavaPersistentType longTimeCustomerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        AssociationOverrideContainer associationOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAssociationOverrideContainer();
        GenericJavaEntity2_0Tests.assertEquals((int)1, (int)associationOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAssociationOverrides = associationOverrideContainer.getVirtualOverrides().iterator();
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address.state", (String)virtualAssociationOverride.getName());
    }

    public void testNestedVirtualAssociationOverridesElementCollection() throws Exception {
        this.createTestMappedSuperclassCustomerWithElementCollection();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.LongTimeCustomer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        specifiedClassRefs.next();
        JavaPersistentType longTimeCustomerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        AssociationOverrideContainer associationOverrideContainer = ((Entity)longTimeCustomerPersistentType.getMapping()).getAssociationOverrideContainer();
        GenericJavaEntity2_0Tests.assertEquals((int)1, (int)associationOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAssociationOverrides = associationOverrideContainer.getVirtualOverrides().iterator();
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericJavaEntity2_0Tests.assertEquals((String)"address.state", (String)virtualAssociationOverride.getName());
    }

    public void testSetSpecifiedCacheable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableHolder2_0)this.getJavaEntity()).getCacheable();
        Cacheable2_0Annotation cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        GenericJavaEntity2_0Tests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        GenericJavaEntity2_0Tests.assertEquals(null, (Object)cacheableAnnotation);
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        GenericJavaEntity2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)cacheable.getSpecifiedCacheable());
        GenericJavaEntity2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(false)", cu);
        cacheable.setSpecifiedCacheable(Boolean.TRUE);
        cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        GenericJavaEntity2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        GenericJavaEntity2_0Tests.assertEquals(null, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        cacheable.setSpecifiedCacheable(null);
        cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        GenericJavaEntity2_0Tests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        GenericJavaEntity2_0Tests.assertEquals(null, (Object)cacheableAnnotation);
        this.assertSourceDoesNotContain("@Cacheable", cu);
    }

    public void testGetSpecifiedCacheable() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableHolder2_0)this.getJavaEntity()).getCacheable();
        Cacheable2_0Annotation cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        GenericJavaEntity2_0Tests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        GenericJavaEntity2_0Tests.assertEquals(null, (Object)cacheableAnnotation);
        this.getJavaPersistentType().getJavaResourceType().addAnnotation("javax.persistence.Cacheable");
        this.getJpaProject().synchronizeContextModel();
        cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        GenericJavaEntity2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        GenericJavaEntity2_0Tests.assertEquals(null, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        cacheableAnnotation.setValue(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEntity2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)cacheable.getSpecifiedCacheable());
        GenericJavaEntity2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(false)", cu);
        cacheableAnnotation.setValue(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEntity2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        GenericJavaEntity2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(true)", cu);
        cacheableAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaEntity2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        GenericJavaEntity2_0Tests.assertEquals(null, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        this.getJavaPersistentType().getJavaResourceType().removeAnnotation("javax.persistence.Cacheable");
        this.getJpaProject().synchronizeContextModel();
        cacheableAnnotation = (Cacheable2_0Annotation)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        GenericJavaEntity2_0Tests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        GenericJavaEntity2_0Tests.assertEquals(null, (Object)cacheableAnnotation);
        this.assertSourceDoesNotContain("@Cacheable", cu);
    }

    public void testIsDefaultCacheable() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableHolder2_0)this.getJavaEntity()).getCacheable();
        PersistenceUnit2_0 persistenceUnit2_0 = (PersistenceUnit2_0)this.getPersistenceUnit();
        GenericJavaEntity2_0Tests.assertEquals((Object)SharedCacheMode.UNSPECIFIED, (Object)persistenceUnit2_0.getSharedCacheMode());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.ALL);
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.NONE);
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.DISABLE_SELECTIVE);
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
    }

    public void testInheritedIsDefaultCacheable() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 subCacheable = ((CacheableHolder2_0)this.getJavaEntity()).getCacheable();
        Cacheable2_0 cacheable = ((CacheableHolder2_0)this.getJavaEntity().getParentEntity()).getCacheable();
        cacheable.setSpecifiedCacheable(Boolean.TRUE);
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        PersistenceUnit2_0 persistenceUnit2_0 = (PersistenceUnit2_0)this.getPersistenceUnit();
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.DISABLE_SELECTIVE);
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        cacheable.setSpecifiedCacheable(Boolean.TRUE);
        GenericJavaEntity2_0Tests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        GenericJavaEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
    }

    public void testAssociationOverrideJoinTableUpdate() throws Exception {
        this.createTestEntityWithAssociationOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverride associationOverride = (JavaAssociationOverride)this.getJavaEntity().getAssociationOverrideContainer().getSpecifiedOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertEquals((String)"a", (String)associationOverride.getName());
        AssociationOverride2_0Annotation annotation = (AssociationOverride2_0Annotation)this.getJavaPersistentType().getJavaResourceType().getAnnotation(0, "javax.persistence.AssociationOverride");
        annotation.getJoinTable().setName("FOO");
        annotation.getJoinTable().addInverseJoinColumn(0).setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        associationOverride = (JavaAssociationOverride)this.getJavaEntity().getAssociationOverrideContainer().getSpecifiedOverrides().iterator().next();
        GenericJavaEntity2_0Tests.assertEquals((String)"a", (String)associationOverride.getName());
        JavaJoinTable joinTable = ((JavaOverrideRelationship2_0)associationOverride.getRelationship()).getJoinTableStrategy().getJoinTable();
        GenericJavaEntity2_0Tests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedName());
        GenericJavaEntity2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinTable.getInverseJoinColumns().iterator().next()).getName());
    }
}

