/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaIdMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    private ICompilationUnit createTestEntityWithIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
            }
        });
    }

    public GenericJavaIdMapping2_0Tests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        GenericJavaIdMapping2_0Tests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        GenericJavaIdMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)((TemporalConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaIdMapping2_0Tests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        GenericJavaIdMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)((TemporalConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Access");
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        GenericJavaIdMapping2_0Tests.assertEquals((String)"FOO", (String)((VersionMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        GenericJavaIdMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)((TemporalConverter)((VersionMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        GenericJavaIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        GenericJavaIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        GenericJavaIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        GenericJavaIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        GenericJavaIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        GenericJavaIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        GenericJavaIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToElementCollectionMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.getGeneratorContainer().addTableGenerator();
        idMapping.getGeneratorContainer().addSequenceGenerator();
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaIdMapping2_0Tests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setMappingKey("elementCollection");
        GenericJavaIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ElementCollectionMapping2_0));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.TableGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.SequenceGenerator"));
        GenericJavaIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.GeneratedValue"));
    }
}

