/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.EnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAttributeOverride;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaManyToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyClass2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyEnumerated2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyJoinColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyTemporal2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TemporalType;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaManyToManyMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericJavaManyToManyMapping2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithValidManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidGenericMapManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<Integer, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Collection<AnnotationTestType> employees;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private String address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithEmbeddableKeyManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<Address, PropertyInfo> parcels;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithEntityKeyManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<Address, PropertyInfo> parcels;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityPropertyInfo() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PropertyInfo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private Integer parcelNumber;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private Integer size;").append(CR);
                sb.append(CR);
                sb.append("    private java.math.BigDecimal tax;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PropertyInfo.java", sourceWriter);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        GenericJavaManyToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaManyToManyMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        GenericJavaManyToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        GenericJavaManyToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        GenericJavaManyToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        GenericJavaManyToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        GenericJavaManyToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        GenericJavaManyToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        GenericJavaManyToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        GenericJavaManyToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToElementCollectionMapping() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setMappingKey("elementCollection");
        GenericJavaManyToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ElementCollectionMapping2_0));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"employees", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"employees", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
        resourceField.addAnnotation("javax.persistence.MapKey");
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        MapKeyAnnotation mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)mapKey);
        mapKey.setName("myMapKey");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        mapKey.setName(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)mapKey.getName());
        mapKey.setName("myMapKey");
        resourceField.removeAnnotation("javax.persistence.MapKey");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
    }

    public void testModifyMapKey() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
        manyToManyMapping.setSpecifiedMapKey("myMapKey");
        MapKeyAnnotation mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)manyToManyMapping.getSpecifiedMapKey());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        manyToManyMapping.setSpecifiedMapKey(null);
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)mapKey.getName());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping2_0 = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator mapKeyNames = manyToManyMapping2_0.getCandidateMapKeyNames().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"employees", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping2_0 = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator mapKeyNames = manyToManyMapping2_0.getCandidateMapKeyNames().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        manyToManyMapping2_0.setSpecifiedTargetEntity("Address");
        mapKeyNames = manyToManyMapping2_0.getCandidateMapKeyNames().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"employees", (String)((String)mapKeyNames.next()));
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        manyToManyMapping2_0.setSpecifiedTargetEntity("String");
        mapKeyNames = manyToManyMapping2_0.getCandidateMapKeyNames().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
        resourceField.addAnnotation("javax.persistence.MapKeyClass");
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        MapKeyClass2_0Annotation mapKeyClassAnnotation = (MapKeyClass2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)mapKeyClassAnnotation);
        mapKeyClassAnnotation.setValue("myMapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"myMapKeyClass", (String)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"myMapKeyClass", (String)mapKeyClassAnnotation.getValue());
        mapKeyClassAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)mapKeyClassAnnotation.getValue());
        mapKeyClassAnnotation.setValue("myMapKeyClass");
        resourceField.removeAnnotation("javax.persistence.MapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
        manyToManyMapping.setSpecifiedMapKeyClass("String");
        MapKeyClass2_0Annotation mapKeyClass = (MapKeyClass2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"String", (String)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"String", (String)mapKeyClass.getValue());
        manyToManyMapping.setSpecifiedMapKeyClass(null);
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testDefaultMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)manyToManyMapping.getDefaultMapKeyClass());
        manyToManyMapping.setSpecifiedMapKeyClass("foo");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)manyToManyMapping.getDefaultMapKeyClass());
    }

    public void testDefaultMapKeyClassCollectionType() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getDefaultMapKeyClass());
    }

    public void testMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)manyToManyMapping.getMapKeyClass());
        manyToManyMapping.setSpecifiedMapKeyClass("foo");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyClass());
        manyToManyMapping.setSpecifiedMapKeyClass(null);
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)manyToManyMapping.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        this.addXmlClassRef("test.PrintQueue");
        this.addXmlClassRef("test.PrintJob");
        JavaPersistentType printQueuePersistentType = (JavaPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintQueue");
        ManyToManyMapping jobsMapping = (ManyToManyMapping)printQueuePersistentType.getAttributeNamed("jobs").getMapping();
        JavaPersistentType printJobPersistentType = (JavaPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintJob");
        ManyToManyMapping queuesMapping = (ManyToManyMapping)printJobPersistentType.getAttributeNamed("queues").getMapping();
        Orderable2_0 jobsOrderable = (Orderable2_0)jobsMapping.getOrderable();
        OrderColumn2_0 jobsOrderColumn = jobsOrderable.getOrderColumn();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)jobsOrderable.isOrderColumnOrdering());
        GenericJavaManyToManyMapping2_0Tests.assertEquals(null, (String)jobsOrderColumn.getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)jobsOrderColumn.getDefaultName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderColumn.getTable());
        Orderable2_0 queuesOrderable = (Orderable2_0)queuesMapping.getOrderable();
        OrderColumn2_0 queuesOrderColumn = queuesOrderable.getOrderColumn();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)queuesOrderable.isOrderColumnOrdering());
        GenericJavaManyToManyMapping2_0Tests.assertEquals(null, (String)queuesOrderColumn.getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"queues_ORDER", (String)queuesOrderColumn.getDefaultName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderColumn.getTable());
        jobsOrderColumn.setSpecifiedName("FOO");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)jobsOrderColumn.getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)jobsOrderColumn.getDefaultName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderColumn.getTable());
        queuesOrderColumn.setSpecifiedName("BAR");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)queuesOrderColumn.getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"queues_ORDER", (String)queuesOrderColumn.getDefaultName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderColumn.getTable());
        ((Entity)printJobPersistentType.getMapping()).getTable().setSpecifiedName("MY_TABLE");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_TABLE_PrintQueue", (String)jobsOrderColumn.getTable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_TABLE_PrintQueue", (String)queuesOrderColumn.getTable());
        ((Entity)printQueuePersistentType.getMapping()).getTable().setSpecifiedName("OTHER_TABLE");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_TABLE_OTHER_TABLE", (String)jobsOrderColumn.getTable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_TABLE_OTHER_TABLE", (String)queuesOrderColumn.getTable());
        queuesMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)jobsOrderColumn.getTable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)queuesOrderColumn.getTable());
    }

    private void createTestEntityPrintQueue() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintQueue").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany(mappedBy=\"queues\")").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintJob> jobs;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintQueue.java", sourceWriter);
    }

    private void createTestEntityPrintJob() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintJob").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintQueue> queues;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintJob.java", sourceWriter);
    }

    public void testGetMapKeyColumn() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)manyToManyMapping.getMapKeyColumn().getTable());
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_PRIMARY_TABLE");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_PRIMARY_TABLE", (String)manyToManyMapping.getMapKeyColumn().getTable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testGetMapKeyColumnMappedByStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        manyToManyMapping.getRelationship().setStrategyToMappedBy();
        manyToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("employees");
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"Address_AnnotationTestType", (String)manyToManyMapping.getMapKeyColumn().getTable());
        PersistentType persistentType = this.getPersistenceUnit().getPersistentType("test.Address");
        ManyToManyMapping owningManyToManyMapping = (ManyToManyMapping)persistentType.getAttributeNamed("employees").getMapping();
        ((JoinTableRelationshipStrategy)owningManyToManyMapping.getRelationship().getStrategy()).getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)manyToManyMapping.getMapKeyColumn().getTable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testGetMapKeyColumnJoinTableStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)manyToManyMapping.getMapKeyColumn().getTable());
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)manyToManyMapping.getMapKeyColumn().getTable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testMapKeySpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        this.addXmlClassRef("test.PropertyInfo");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        ListIterator specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BLAH");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
    }

    public void testMapKeyValueVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"parcels", (String)resourceField.getName());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        ReadOnlyAttributeOverride defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_PropertyInfo", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        Embeddable addressEmbeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)addressEmbeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"parcels", (String)resourceField.getName());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_PropertyInfo", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)0, (int)mapKeyAttributeOverrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getSpecifiedOverridesSize());
    }

    public void testMapKeyValueAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.state.foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
    }

    public void testMapKeyValueVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.state.foo");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("size");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)2, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ListIterator specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
    }

    public void testSetSpecifiedMapKeyEnumerated() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getMapKeyConverter().getType());
        manyToManyMapping.setMapKeyConverter(EnumeratedConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated");
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)enumerated);
        GenericJavaManyToManyMapping2_0Tests.assertEquals(null, (Object)enumerated.getValue());
        ((EnumeratedConverter)manyToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(EnumType.STRING);
        GenericJavaManyToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING, (Object)enumerated.getValue());
        ((EnumeratedConverter)manyToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(null);
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)enumerated.getValue());
        manyToManyMapping.setMapKeyConverter(null);
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
    }

    public void testGetSpecifiedMapKeyEnumeratedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getMapKeyConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyEnumerated");
        enumerated.setValue(org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((Object)EnumType.STRING, (Object)((EnumeratedConverter)manyToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        enumerated.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)((EnumeratedConverter)manyToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertSame((Object)manyToManyMapping, (Object)persistentAttribute.getMapping());
    }

    public void testSetMapKeyTemporal() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getMapKeyConverter().getType());
        manyToManyMapping.setMapKeyConverter(TemporalConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyTemporal2_0Annotation temporal = (MapKeyTemporal2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyTemporal");
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)temporal);
        GenericJavaManyToManyMapping2_0Tests.assertEquals(null, (Object)temporal.getValue());
        ((TemporalConverter)manyToManyMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        GenericJavaManyToManyMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        ((TemporalConverter)manyToManyMapping.getMapKeyConverter()).setTemporalType(null);
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyTemporal"));
    }

    public void testGetMapKeyTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getMapKeyConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyTemporal2_0Annotation temporal = (MapKeyTemporal2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyTemporal");
        temporal.setValue(TemporalType.TIME);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((TemporalConverter)manyToManyMapping.getMapKeyConverter()).getTemporalType());
        temporal.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyTemporal"));
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)((TemporalConverter)manyToManyMapping.getMapKeyConverter()).getTemporalType());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)manyToManyMapping.isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertSame((Object)manyToManyMapping, (Object)persistentAttribute.getMapping());
    }

    public void testSpecifiedMapKeyJoinColumns() throws Exception {
        this.createTestEntityWithEntityKeyManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        ListIterator specifiedMapKeyJoinColumns = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyJoinColumn2_0Annotation joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
    }

    public void testSpecifiedMapKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithEntityKeyManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)0, (int)manyToManyMapping.getSpecifiedMapKeyJoinColumnsSize());
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(0);
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)1, (int)manyToManyMapping.getSpecifiedMapKeyJoinColumnsSize());
        manyToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)0, (int)manyToManyMapping.getSpecifiedMapKeyJoinColumnsSize());
    }

    public void testMapKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithEntityKeyManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)1, (int)manyToManyMapping.getMapKeyJoinColumnsSize());
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(0);
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)1, (int)manyToManyMapping.getMapKeyJoinColumnsSize());
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(0);
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)2, (int)manyToManyMapping.getMapKeyJoinColumnsSize());
        manyToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        manyToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)1, (int)manyToManyMapping.getMapKeyJoinColumnsSize());
    }

    public void testAddSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestEntityWithEntityKeyManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("BAR");
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator joinColumnsIterator = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testAddSpecifiedMapKeyJoinColumn2() throws Exception {
        this.createTestEntityWithEntityKeyManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator joinColumnsIterator = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testRemoveSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestEntityWithEntityKeyManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)3, (int)resourceField.getAnnotationsSize("javax.persistence.MapKeyJoinColumn"));
        manyToManyMapping.removeSpecifiedMapKeyJoinColumn(1);
        ListIterator joinColumnResources = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumnResources.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)joinColumnResources.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnResources.hasNext());
        ListIterator joinColumnsIterator = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        manyToManyMapping.removeSpecifiedMapKeyJoinColumn(1);
        joinColumnResources = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumnResources.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumnsIterator = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        manyToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        joinColumnResources = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumnsIterator = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.MapKeyJoinColumn"));
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithEntityKeyManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator javaJoinColumns = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaJoinColumns));
        manyToManyMapping.moveSpecifiedMapKeyJoinColumn(2, 0);
        ListIterator joinColumns = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        javaJoinColumns = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        manyToManyMapping.moveSpecifiedMapKeyJoinColumn(0, 1);
        joinColumns = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        javaJoinColumns = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
    }

    public void testUpdateSpecifiedMapKeyJoinColumns() throws Exception {
        this.createTestEntityWithEntityKeyManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ((MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn")).setName("FOO");
        ((MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(1, "javax.persistence.MapKeyJoinColumn")).setName("BAR");
        ((MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(2, "javax.persistence.MapKeyJoinColumn")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator joinColumnsIterator = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.moveAnnotation(2, 0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.moveAnnotation(0, 1, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testMapKeyJoinColumnIsDefault() throws Exception {
        this.createTestEntityWithEntityKeyManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaManyToManyMapping2_0Tests.assertTrue((boolean)manyToManyMapping.getDefaultMapKeyJoinColumn().isDefault());
        manyToManyMapping.addSpecifiedMapKeyJoinColumn(0);
        JoinColumn specifiedJoinColumn = (JoinColumn)manyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator().next();
        GenericJavaManyToManyMapping2_0Tests.assertFalse((boolean)specifiedJoinColumn.isDefault());
        GenericJavaManyToManyMapping2_0Tests.assertNull((Object)manyToManyMapping.getDefaultMapKeyJoinColumn());
    }
}

