/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.EnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAttributeOverride;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOrphanRemovable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOrphanRemovalHolder2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyClass2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyEnumerated2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyJoinColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyTemporal2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OneToMany2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TemporalType;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaOneToManyMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericJavaOneToManyMapping2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithValidOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidOneToManyMappingOrphanRemovalSpecified() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany(orphanRemoval=false)").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<Integer, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToOne");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private AnnotationTestType employee;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private String address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithEmbeddableKeyOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<Address, PropertyInfo> parcels;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithEntityKeyOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<Address, PropertyInfo> parcels;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityPropertyInfo() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PropertyInfo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private Integer parcelNumber;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private Integer size;").append(CR);
                sb.append(CR);
                sb.append("    private java.math.BigDecimal tax;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PropertyInfo.java", sourceWriter);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        oneToManyMapping.getOrderable().setSpecifiedOrderBy("asdf");
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("FOO");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OrderBy"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"employee", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"employee", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    private JavaOrphanRemovable2_0 getOrphanRemovalOf(OneToManyMapping2_0 oneToManyMapping) {
        return ((JavaOrphanRemovalHolder2_0)oneToManyMapping).getOrphanRemoval();
    }

    public void testDefaultOneToManyGetDefaultOrphanRemoval() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)this.getOrphanRemovalOf(oneToManyMapping).isDefaultOrphanRemoval());
    }

    public void testSpecifiedOneToManyGetDefaultOrphanRemoval() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)this.getOrphanRemovalOf(oneToManyMapping).isDefaultOrphanRemoval());
    }

    public void testGetOrphanRemoval() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mappingsOrphanRemoval.isOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)mappingsOrphanRemoval.isOrphanRemoval());
    }

    public void testGetSpecifiedOrphanRemoval() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        OneToMany2_0Annotation oneToMany = (OneToMany2_0Annotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        oneToMany.setOrphanRemoval(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testGetSpecifiedOrphanRemoval2() throws Exception {
        this.createTestEntityWithValidOneToManyMappingOrphanRemovalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testSetSpecifiedOrphanRemoval() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        OneToMany2_0Annotation oneToMany = (OneToMany2_0Annotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToMany.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(null);
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
    }

    public void testSetSpecifiedOrphanRemoval2() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        OneToMany2_0Annotation oneToMany = (OneToMany2_0Annotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToMany.getOrphanRemoval());
        oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(null);
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
    }

    public void testGetSpecifiedOrphanRemovalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        OneToMany2_0Annotation oneToMany = (OneToMany2_0Annotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        oneToMany.setOrphanRemoval(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        oneToMany.setOrphanRemoval(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericJavaOneToManyMapping2_0Tests.assertSame((Object)oneToManyMapping, (Object)persistentAttribute.getMapping());
        oneToMany.setOrphanRemoval(Boolean.FALSE);
        resourceField.setPrimaryAnnotation(null, EmptyIterable.instance());
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
        resourceField.addAnnotation("javax.persistence.MapKey");
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        MapKeyAnnotation mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)mapKey);
        mapKey.setName("myMapKey");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)oneToManyMapping.getSpecifiedMapKey());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        mapKey.setName(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mapKey.getName());
        mapKey.setName("myMapKey");
        resourceField.removeAnnotation("javax.persistence.MapKey");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
    }

    public void testModifyMapKey() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
        oneToManyMapping.setSpecifiedMapKey("myMapKey");
        MapKeyAnnotation mapKeyAnnotation = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)oneToManyMapping.getSpecifiedMapKey());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)mapKeyAnnotation.getName());
        oneToManyMapping.setSpecifiedMapKey(null);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        mapKeyAnnotation = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mapKeyAnnotation.getName());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping2_0 = (OneToManyMapping2_0)persistentAttribute.getMapping();
        Iterator mapKeyNames = oneToManyMapping2_0.getCandidateMapKeyNames().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"employee", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping2_0 = (OneToManyMapping2_0)persistentAttribute.getMapping();
        Iterator mapKeyNames = oneToManyMapping2_0.getCandidateMapKeyNames().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        oneToManyMapping2_0.setSpecifiedTargetEntity("Address");
        mapKeyNames = oneToManyMapping2_0.getCandidateMapKeyNames().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"employee", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        oneToManyMapping2_0.setSpecifiedTargetEntity("String");
        mapKeyNames = oneToManyMapping2_0.getCandidateMapKeyNames().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
        resourceField.addAnnotation("javax.persistence.MapKeyClass");
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        MapKeyClass2_0Annotation mapKeyClassAnnotation = (MapKeyClass2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)mapKeyClassAnnotation);
        mapKeyClassAnnotation.setValue("myMapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"myMapKeyClass", (String)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"myMapKeyClass", (String)mapKeyClassAnnotation.getValue());
        mapKeyClassAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mapKeyClassAnnotation.getValue());
        mapKeyClassAnnotation.setValue("myMapKeyClass");
        resourceField.removeAnnotation("javax.persistence.MapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
        oneToManyMapping.setSpecifiedMapKeyClass("String");
        MapKeyClass2_0Annotation mapKeyClass = (MapKeyClass2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"String", (String)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"String", (String)mapKeyClass.getValue());
        oneToManyMapping.setSpecifiedMapKeyClass(null);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testDefaultMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)oneToManyMapping.getDefaultMapKeyClass());
        oneToManyMapping.setSpecifiedMapKeyClass("foo");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)oneToManyMapping.getDefaultMapKeyClass());
    }

    public void testDefaultMapKeyClassCollectionType() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getDefaultMapKeyClass());
    }

    public void testMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)oneToManyMapping.getMapKeyClass());
        oneToManyMapping.setSpecifiedMapKeyClass("foo");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyClass());
        oneToManyMapping.setSpecifiedMapKeyClass(null);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)oneToManyMapping.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        this.addXmlClassRef("test.PrintQueue");
        this.addXmlClassRef("test.PrintJob");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)this.getJavaPersistentType().getAttributeNamed("jobs").getMapping();
        Orderable2_0 orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        OrderColumn2_0 orderColumn = orderable.getOrderColumn();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        GenericJavaOneToManyMapping2_0Tests.assertEquals(null, (String)orderColumn.getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"PrintJob", (String)orderColumn.getTable());
        orderColumn.setSpecifiedName("FOO");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)orderColumn.getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"PrintJob", (String)orderColumn.getTable());
        JavaPersistentType printJobPersistentType = (JavaPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintJob");
        ((Entity)printJobPersistentType.getMapping()).getTable().setSpecifiedName("MY_TABLE");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"MY_TABLE", (String)orderColumn.getTable());
    }

    private void createTestEntityPrintQueue() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OneToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintQueue").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany(mappedBy=\"queue\")").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintJob> jobs;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintQueue.java", sourceWriter);
    }

    private void createTestEntityPrintJob() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToOne");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintJob").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private PrintQueue queue;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintJob.java", sourceWriter);
    }

    public void testGetMapKeyColumnMappedByStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        oneToManyMapping.getRelationship().setStrategyToMappedBy();
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("employee");
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)oneToManyMapping.getMapKeyColumn().getTable());
        Entity addressEntity = this.getPersistenceUnit().getEntity("test.Address");
        addressEntity.getTable().setSpecifiedName("MY_PRIMARY_TABLE");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"MY_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTable());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testGetMapKeyColumnJoinTableStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)oneToManyMapping.getMapKeyColumn().getTable());
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_PRIMARY_TABLE");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"MY_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTable());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testTargetForeignKeyJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        ((JoinColumnRelationship)oneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        JoinColumn joinColumn = (JoinColumn)((JoinColumnRelationship)oneToManyMapping.getRelationship()).getJoinColumnStrategy().getSpecifiedJoinColumns().iterator().next();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)joinColumn.getDefaultTable());
        Entity addressEntity = this.getPersistenceUnit().getEntity("test.Address");
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
        joinColumn.setSpecifiedName("FOO");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
    }

    public void testGetMapKeyColumnJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        ((JoinColumnRelationship)oneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)oneToManyMapping.getMapKeyColumn().getTable());
        Entity addressEntity = this.getPersistenceUnit().getEntity("test.Address");
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTable());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getDefaultTable());
    }

    public void testOrderColumnDefaultsJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        ((JoinColumnRelationship)oneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        ((Orderable2_0)oneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = ((Orderable2_0)oneToManyMapping.getOrderable()).getOrderColumn();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)orderColumn.getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)orderColumn.getTable());
        Entity addressEntity = this.getPersistenceUnit().getEntity("test.Address");
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTable());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 mapping = (OneToManyMapping2_0)contextAttribute.getMapping();
        OneToManyRelationship2_0 rel = (OneToManyRelationship2_0)mapping.getRelationship();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinColumn();
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinTable();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 mapping = (OneToManyMapping2_0)contextAttribute.getMapping();
        OneToManyRelationship2_0 rel = (OneToManyRelationship2_0)mapping.getRelationship();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceField.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceField.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceField.removeAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testMapKeySpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        this.addXmlClassRef("test.PropertyInfo");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        ListIterator specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BLAH");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
    }

    public void testMapKeyValueVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"parcels", (String)resourceField.getName());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        ReadOnlyAttributeOverride defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_PropertyInfo", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        Embeddable addressEmbeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)addressEmbeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"parcels", (String)resourceField.getName());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_PropertyInfo", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)0, (int)mapKeyAttributeOverrideContainer.getSpecifiedOverridesSize());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getSpecifiedOverridesSize());
    }

    public void testMapKeyValueAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.state.foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
    }

    public void testMapKeyValueVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.state.foo");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("size");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)2, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ListIterator specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
    }

    public void testSetSpecifiedMapKeyEnumerated() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKeyConverter().getType());
        oneToManyMapping.setMapKeyConverter(EnumeratedConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated");
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)enumerated);
        GenericJavaOneToManyMapping2_0Tests.assertEquals(null, (Object)enumerated.getValue());
        ((EnumeratedConverter)oneToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(EnumType.STRING);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING, (Object)enumerated.getValue());
        ((EnumeratedConverter)oneToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(null);
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)enumerated.getValue());
        oneToManyMapping.setMapKeyConverter(null);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
    }

    public void testGetSpecifiedMapKeyEnumeratedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKeyConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyEnumerated");
        enumerated.setValue(org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)EnumType.STRING, (Object)((EnumeratedConverter)oneToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        enumerated.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)((EnumeratedConverter)oneToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertSame((Object)oneToManyMapping, (Object)persistentAttribute.getMapping());
    }

    public void testSetMapKeyTemporal() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKeyConverter().getType());
        oneToManyMapping.setMapKeyConverter(TemporalConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyTemporal2_0Annotation temporal = (MapKeyTemporal2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyTemporal");
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)temporal);
        GenericJavaOneToManyMapping2_0Tests.assertEquals(null, (Object)temporal.getValue());
        ((TemporalConverter)oneToManyMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        ((TemporalConverter)oneToManyMapping.getMapKeyConverter()).setTemporalType(null);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyTemporal"));
    }

    public void testGetMapKeyTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKeyConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyTemporal2_0Annotation temporal = (MapKeyTemporal2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyTemporal");
        temporal.setValue(TemporalType.TIME);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((TemporalConverter)oneToManyMapping.getMapKeyConverter()).getTemporalType());
        temporal.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyTemporal"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)((TemporalConverter)oneToManyMapping.getMapKeyConverter()).getTemporalType());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)oneToManyMapping.isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertSame((Object)oneToManyMapping, (Object)persistentAttribute.getMapping());
    }

    public void testSpecifiedMapKeyJoinColumns() throws Exception {
        this.createTestEntityWithEntityKeyOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        ListIterator specifiedMapKeyJoinColumns = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyJoinColumn2_0Annotation joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        joinColumn = (MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        joinColumn.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedMapKeyJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyJoinColumns = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyJoinColumns.hasNext());
    }

    public void testSpecifiedMapKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithEntityKeyOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)0, (int)oneToManyMapping.getSpecifiedMapKeyJoinColumnsSize());
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(0);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)1, (int)oneToManyMapping.getSpecifiedMapKeyJoinColumnsSize());
        oneToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)0, (int)oneToManyMapping.getSpecifiedMapKeyJoinColumnsSize());
    }

    public void testMapKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithEntityKeyOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)1, (int)oneToManyMapping.getMapKeyJoinColumnsSize());
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(0);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)1, (int)oneToManyMapping.getMapKeyJoinColumnsSize());
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(0);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)2, (int)oneToManyMapping.getMapKeyJoinColumnsSize());
        oneToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        oneToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)1, (int)oneToManyMapping.getMapKeyJoinColumnsSize());
    }

    public void testAddSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestEntityWithEntityKeyOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("BAR");
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator joinColumnsIterator = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testAddSpecifiedMapKeyJoinColumn2() throws Exception {
        this.createTestEntityWithEntityKeyOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator joinColumnsIterator = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testRemoveSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestEntityWithEntityKeyOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)3, (int)resourceField.getAnnotationsSize("javax.persistence.MapKeyJoinColumn"));
        oneToManyMapping.removeSpecifiedMapKeyJoinColumn(1);
        ListIterator joinColumnResources = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumnResources.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)joinColumnResources.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnResources.hasNext());
        ListIterator joinColumnsIterator = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        oneToManyMapping.removeSpecifiedMapKeyJoinColumn(1);
        joinColumnResources = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)joinColumnResources.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumnsIterator = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        oneToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        joinColumnResources = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumnsIterator = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.MapKeyJoinColumn"));
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithEntityKeyOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator javaJoinColumns = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaJoinColumns));
        oneToManyMapping.moveSpecifiedMapKeyJoinColumn(2, 0);
        ListIterator joinColumns = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        javaJoinColumns = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        oneToManyMapping.moveSpecifiedMapKeyJoinColumn(0, 1);
        joinColumns = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getSpecifiedName());
        javaJoinColumns = resourceField.getAnnotations("javax.persistence.MapKeyJoinColumn").iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((MapKeyJoinColumn2_0Annotation)javaJoinColumns.next()).getName());
    }

    public void testUpdateSpecifiedMapKeyJoinColumns() throws Exception {
        this.createTestEntityWithEntityKeyOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ((MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(0, "javax.persistence.MapKeyJoinColumn")).setName("FOO");
        ((MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(1, "javax.persistence.MapKeyJoinColumn")).setName("BAR");
        ((MapKeyJoinColumn2_0Annotation)resourceField.addAnnotation(2, "javax.persistence.MapKeyJoinColumn")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator joinColumnsIterator = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.moveAnnotation(2, 0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.moveAnnotation(0, 1, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.MapKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testMapKeyJoinColumnIsDefault() throws Exception {
        this.createTestEntityWithEntityKeyOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)oneToManyMapping.getDefaultMapKeyJoinColumn().isDefault());
        oneToManyMapping.addSpecifiedMapKeyJoinColumn(0);
        JoinColumn specifiedJoinColumn = (JoinColumn)oneToManyMapping.getSpecifiedMapKeyJoinColumns().iterator().next();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedJoinColumn.isDefault());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getDefaultMapKeyJoinColumn());
    }
}

