/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.internal.context.java.FieldAccessor;
import org.eclipse.jpt.jpa.core.internal.context.java.PropertyAccessor;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaPersistentType2_0Tests
extends Generic2_0ContextModelTestCase {
    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedMethod() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedFieldAndMethod() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedFieldPropertySpecified() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.Id", "javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Access(AccessType.PROPERTY)");
            }

            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Access(AccessType.FIELD)");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedPropertyFieldSpecified() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Access(AccessType.FIELD)");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Access(AccessType.PROPERTY)");
            }
        });
    }

    private ICompilationUnit createTestSubType() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestSubTypeWithFieldAnnotation() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestSubTypeWithMethodAnnotation() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestSubTypeNonPersistent() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }
        });
    }

    private ICompilationUnit createTestSubTypePersistentExtendsNonPersistent() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild2.java", "AnnotationTestTypeChild2", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestTypeChild ");
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public GenericJavaPersistentType2_0Tests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((String)"test.AnnotationTestType", (String)this.getJavaPersistentType().getName());
    }

    public void testGetAccessNothingAnnotated() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)this.getJavaPersistentType().getAccess());
    }

    public void testAccessField() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)this.getJavaPersistentType().getAccess());
    }

    public void testAccessProperty() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getJavaPersistentType().getAccess());
    }

    public void testAccessFieldAndMethodAnnotated() throws Exception {
        this.createTestEntityAnnotatedFieldAndMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)this.getJavaPersistentType().getAccess());
    }

    public void testAccessFieldAnnotatedPropertySpecified() throws Exception {
        this.createTestEntityAnnotatedFieldPropertySpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getJavaPersistentType().getAccess());
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute javaPersistentAttribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"name", (String)javaPersistentAttribute.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericJavaPersistentType2_0Tests.assertEquals((String)"basic", (String)javaPersistentAttribute.getMapping().getKey());
        javaPersistentAttribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id", (String)javaPersistentAttribute.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id", (String)javaPersistentAttribute.getMappingKey());
        GenericJavaPersistentType2_0Tests.assertFalse((boolean)attributes.hasNext());
    }

    public void testAccessPropertyAnnotatedFieldSpecified() throws Exception {
        this.createTestEntityAnnotatedPropertyFieldSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)this.getJavaPersistentType().getAccess());
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute javaPersistentAttribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id", (String)javaPersistentAttribute.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericJavaPersistentType2_0Tests.assertEquals((String)"basic", (String)javaPersistentAttribute.getMappingKey());
        javaPersistentAttribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"name", (String)javaPersistentAttribute.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericJavaPersistentType2_0Tests.assertEquals((String)"basic", (String)javaPersistentAttribute.getMappingKey());
        javaPersistentAttribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id", (String)javaPersistentAttribute.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id", (String)javaPersistentAttribute.getMappingKey());
        GenericJavaPersistentType2_0Tests.assertFalse((boolean)attributes.hasNext());
        attributes = this.getJavaPersistentType().getAttributes().iterator();
        ((JavaPersistentAttribute)attributes.next()).getResourceAttribute().setPrimaryAnnotation("javax.persistence.Transient", EmptyIterable.instance());
        attributes = this.getJavaPersistentType().getAttributes().iterator();
        javaPersistentAttribute = (JavaPersistentAttribute)attributes.next();
        javaPersistentAttribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"name", (String)javaPersistentAttribute.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericJavaPersistentType2_0Tests.assertEquals((String)"basic", (String)javaPersistentAttribute.getMappingKey());
        javaPersistentAttribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id", (String)javaPersistentAttribute.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id", (String)javaPersistentAttribute.getMappingKey());
        GenericJavaPersistentType2_0Tests.assertFalse((boolean)attributes.hasNext());
    }

    public void testAccessInheritance() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessInheritance2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessInheritance3() throws Exception {
        this.createTestEntityAnnotatedField();
        this.createTestSubTypeWithMethodAnnotation();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessInheritance4() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeWithFieldAnnotation();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessInheritancePersistenceUnitDefaultAccess() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.FIELD);
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlNoAccessNoAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntity();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlEntityAccessNoAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntity();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        entityPersistentType.setSpecifiedAccess(AccessType.FIELD);
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        entityPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlPersistenceUnitDefaultsAccessNoAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntity();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.FIELD);
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlEntityPropertyAccessAndFieldAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedField();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        entityPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlEntityFieldAccessAndPropertyAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedMethod();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        entityPersistentType.setSpecifiedAccess(AccessType.FIELD);
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlPersistenceUnitDefaultsAccessFieldAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedField();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlEntityMappingsAccessWithInheritance() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType childEntityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        this.createTestEntityAnnotatedMethod();
        this.createTestSubType();
        JavaPersistentType childJavaPersistentType = childEntityPersistentType.getJavaPersistentType();
        this.getEntityMappings().setSpecifiedAccess(AccessType.FIELD);
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)entityPersistentType.getJavaPersistentType().getAccess());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)childJavaPersistentType.getAccess());
    }

    public void testAccessXmlMetadataCompleteFieldAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedField();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessNoXmlAccessXmlMetdataCompletePropertyAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedMethod();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        GenericJavaPersistentType2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testSuperPersistentType() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeWithFieldAnnotation();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType rootJavaPersistentType = classRef.getJavaPersistentType();
        classRef = (ClassRef)classRefs.next();
        JavaPersistentType childJavaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentType2_0Tests.assertEquals((Object)rootJavaPersistentType, (Object)childJavaPersistentType.getSuperPersistentType());
        GenericJavaPersistentType2_0Tests.assertNull((Object)rootJavaPersistentType.getSuperPersistentType());
    }

    public void testSuperPersistentType2() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeWithFieldAnnotation();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        JavaPersistentType javaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        GenericJavaPersistentType2_0Tests.assertNotNull((Object)javaPersistentType.getSuperPersistentType());
    }

    public void testSuperPersistentType3() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeNonPersistent();
        this.createTestSubTypePersistentExtendsNonPersistent();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild2");
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType rootJavaPersistentType = classRef.getJavaPersistentType();
        classRef = (ClassRef)classRefs.next();
        JavaPersistentType childJavaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentType2_0Tests.assertEquals((Object)rootJavaPersistentType, (Object)childJavaPersistentType.getSuperPersistentType());
        GenericJavaPersistentType2_0Tests.assertNull((Object)rootJavaPersistentType.getSuperPersistentType());
    }

    public void testInheritanceHierarchy() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeNonPersistent();
        this.createTestSubTypePersistentExtendsNonPersistent();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild2");
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        JavaPersistentType rootJavaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaPersistentType childJavaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        Iterator inheritanceHierarchy = childJavaPersistentType.getInheritanceHierarchy().iterator();
        GenericJavaPersistentType2_0Tests.assertEquals((Object)childJavaPersistentType, inheritanceHierarchy.next());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)rootJavaPersistentType, inheritanceHierarchy.next());
    }

    public void testInheritanceHierarchy2() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeNonPersistent();
        this.createTestSubTypePersistentExtendsNonPersistent();
        this.addXmlClassRef("test.AnnotationTestTypeChild2");
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        JavaPersistentType childJavaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaPersistentType rootJavaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        Iterator inheritanceHierarchy = childJavaPersistentType.getInheritanceHierarchy().iterator();
        GenericJavaPersistentType2_0Tests.assertEquals((Object)childJavaPersistentType, inheritanceHierarchy.next());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)rootJavaPersistentType, inheritanceHierarchy.next());
    }

    public void testGetMapping() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMapping().getKey());
    }

    public void testGetMappingNull() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.getJavaPersistentType().getMapping().getKey());
    }

    public void testMappingKey() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testMappingKeyNull() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testSetMappingKey() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.getJavaPersistentType().getMappingKey());
        this.getJavaPersistentType().setMappingKey("entity");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        GenericJavaPersistentType2_0Tests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.Entity"));
        GenericJavaPersistentType2_0Tests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testSetMappingKey2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMappingKey());
        this.getJavaPersistentType().setMappingKey("embeddable");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        GenericJavaPersistentType2_0Tests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.Embeddable"));
        GenericJavaPersistentType2_0Tests.assertEquals((String)"embeddable", (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testSetMappingKeyNull() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMappingKey());
        this.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        GenericJavaPersistentType2_0Tests.assertNull((Object)resourceType.getAnnotation("javax.persistence.Entity"));
        GenericJavaPersistentType2_0Tests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testGetMappingKeyMappingChangeInResourceModel() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMappingKey());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        resourceType.setPrimaryAnnotation("javax.persistence.Embeddable", EmptyIterable.instance());
        this.getJpaProject().synchronizeContextModel();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"embeddable", (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testGetMappingKeyMappingChangeInResourceModel2() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.getJavaPersistentType().getMappingKey());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        resourceType.setPrimaryAnnotation("javax.persistence.Entity", EmptyIterable.instance());
        this.getJpaProject().synchronizeContextModel();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testIsMapped() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertTrue((boolean)this.getJavaPersistentType().isMapped());
        this.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        GenericJavaPersistentType2_0Tests.assertFalse((boolean)this.getJavaPersistentType().isMapped());
    }

    public void testAttributes() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentType2_0Tests.assertFalse((boolean)attributes.hasNext());
    }

    public void testAttributes2() throws Exception {
        this.createTestEntityAnnotatedFieldAndMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute attribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id", (String)attribute.getName());
        GenericJavaPersistentType2_0Tests.assertTrue((boolean)(attribute.getAccessor() instanceof FieldAccessor));
        attribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"name", (String)attribute.getName());
        GenericJavaPersistentType2_0Tests.assertTrue((boolean)(attribute.getAccessor() instanceof FieldAccessor));
        attribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id", (String)attribute.getName());
        GenericJavaPersistentType2_0Tests.assertTrue((boolean)(attribute.getAccessor() instanceof PropertyAccessor));
        GenericJavaPersistentType2_0Tests.assertFalse((boolean)attributes.hasNext());
    }

    public void testAttributesSize() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((int)1, (int)this.getJavaPersistentType().getAttributesSize());
    }

    public void testAttributesSize2() throws Exception {
        this.createTestEntityAnnotatedFieldAndMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentType2_0Tests.assertEquals((int)3, (int)this.getJavaPersistentType().getAttributesSize());
    }

    public void testAttributeNamed() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute attribute = this.getJavaPersistentType().getAttributeNamed("id");
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id", (String)attribute.getName());
        GenericJavaPersistentType2_0Tests.assertNull((Object)this.getJavaPersistentType().getAttributeNamed("name"));
        GenericJavaPersistentType2_0Tests.assertNull((Object)this.getJavaPersistentType().getAttributeNamed("foo"));
    }

    public void testAttributeNamed2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute attribute = this.getJavaPersistentType().getAttributeNamed("name");
        GenericJavaPersistentType2_0Tests.assertEquals((String)"name", (String)attribute.getName());
        GenericJavaPersistentType2_0Tests.assertNull((Object)this.getJavaPersistentType().getAttributeNamed("foo"));
    }

    public void testRenameAttribute() throws Exception {
        ICompilationUnit testType = this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute idAttribute = (JavaPersistentAttribute)attributes.next();
        JavaPersistentAttribute nameAttribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id", (String)idAttribute.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((String)"name", (String)nameAttribute.getName());
        IField idField = testType.findPrimaryType().getField("id");
        idField.rename("id2", false, null);
        attributes = this.getJavaPersistentType().getAttributes().iterator();
        JavaPersistentAttribute nameAttribute2 = (JavaPersistentAttribute)attributes.next();
        JavaPersistentAttribute id2Attribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentType2_0Tests.assertNotSame((Object)idAttribute, (Object)id2Attribute);
        GenericJavaPersistentType2_0Tests.assertEquals((String)"id2", (String)id2Attribute.getName());
        GenericJavaPersistentType2_0Tests.assertEquals((Object)nameAttribute, (Object)nameAttribute2);
        GenericJavaPersistentType2_0Tests.assertEquals((String)"name", (String)nameAttribute2.getName());
        GenericJavaPersistentType2_0Tests.assertFalse((boolean)attributes.hasNext());
    }

    public void testSuperPersistentTypeGeneric() throws Exception {
        this.createTestGenericEntity();
        this.createTestGenericMappedSuperclass();
        this.addXmlClassRef("test.Entity1");
        this.addXmlClassRef("test.Entity2");
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        GenericJavaPersistentType2_0Tests.assertEquals((String)"test.Entity1", (String)javaPersistentType.getName());
        GenericJavaPersistentType2_0Tests.assertNotNull((Object)javaPersistentType.getSuperPersistentType());
        GenericJavaPersistentType2_0Tests.assertEquals((String)"test.Entity2", (String)javaPersistentType.getSuperPersistentType().getName());
    }

    private void createTestGenericEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Entity1 ");
                sb.append("extends Entity2<Integer> {}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Entity1.java", sourceWriter);
    }

    private void createTestGenericMappedSuperclass() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.MappedSuperclass");
                sb.append(";");
                sb.append(CR);
                sb.append("@MappedSuperclass");
                sb.append(CR);
                sb.append("public class Entity2<K> {}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Entity2.java", sourceWriter);
    }
}

