/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaVersionMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    private ICompilationUnit createTestEntityWithVersionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
            }
        });
    }

    public GenericJavaVersionMapping2_0Tests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        GenericJavaVersionMapping2_0Tests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        GenericJavaVersionMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)((TemporalConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaVersionMapping2_0Tests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        GenericJavaVersionMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)((TemporalConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        GenericJavaVersionMapping2_0Tests.assertEquals((String)"FOO", (String)((IdMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        GenericJavaVersionMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)((TemporalConverter)((IdMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        GenericJavaVersionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        GenericJavaVersionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        GenericJavaVersionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        GenericJavaVersionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        GenericJavaVersionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        GenericJavaVersionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        GenericJavaVersionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testMorphToElementCollectionMapping() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(TemporalType.TIME);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaVersionMapping2_0Tests.assertFalse((boolean)versionMapping.isDefault());
        persistentAttribute.setMappingKey("elementCollection");
        GenericJavaVersionMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ElementCollectionMapping2_0));
        GenericJavaVersionMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Column"));
        GenericJavaVersionMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }
}

