/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.AssociationOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmAssociationOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmMappedSuperclass;
import org.eclipse.jpt.jpa.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.jpa2.context.Cacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.CacheableHolder2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.LockModeType2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmNamedQuery2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.SharedCacheMode;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.jpa.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.LockModeType_2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmEntity2_0Tests
extends Generic2_0ContextModelTestCase {
    protected static final String SUB_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_SUB_TYPE_NAME = "test.AnnotationTestTypeChild";

    public GenericOrmEntity2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.OneToOne", "javax.persistence.ManyToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne");
                sb.append(CR);
                sb.append("    private int address2;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany");
                sb.append(CR);
                sb.append("    private int address3;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany");
                sb.append(CR);
                sb.append("    private int address4;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private ICompilationUnit createTestAbstractEntityTablePerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "javax.persistence.InheritanceType", "javax.persistence.OneToOne", "javax.persistence.ManyToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)");
                sb.append("abstract");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("private String foo;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private int address;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne");
                sb.append(CR);
                sb.append("    private int address2;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany");
                sb.append(CR);
                sb.append("    private int address3;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany");
                sb.append(CR);
                sb.append("    private int address4;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append(GenericOrmEntity2_0Tests.SUB_TYPE_NAME).append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    private void createTestMappedSuperclassCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.MappedSuperclass");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@MappedSuperclass");
                sb.append(CR);
                sb.append("public class ").append("Customer ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestMappedSuperclassCustomerWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.MappedSuperclass");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@MappedSuperclass");
                sb.append(CR);
                sb.append("public class ").append("Customer ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestEntityLongTimeCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("LongTimeCustomer extends Customer ");
                sb.append("{}");
            }
        };
        this.javaProject.createCompilationUnit("test", "LongTimeCustomer.java", sourceWriter);
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OneToOne");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String street;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private ZipCode zipCode;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableZipCode() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("ZipCode").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String zip;").append(CR);
                sb.append(CR);
                sb.append("    private String plusfour;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "ZipCode.java", sourceWriter);
    }

    private LockModeType2_0 lockModeOf(XmlNamedQuery resourceQuery) {
        return resourceQuery == null ? null : LockModeType2_0.fromOrmResourceModel((LockModeType_2_0)resourceQuery.getLockMode());
    }

    public void testAddNamedQuery() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmNamedQuery2_0 namedQuery = (OrmNamedQuery2_0)ormEntity.getQueryContainer().addNamedQuery(0);
        namedQuery.setName("FOO");
        namedQuery.setSpecifiedLockMode(LockModeType2_0.OPTIMISTIC);
        XmlNamedQuery resourceQuery = (XmlNamedQuery)entityResource.getNamedQueries().get(0);
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)resourceQuery.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)this.lockModeOf(resourceQuery));
        OrmNamedQuery2_0 namedQuery2 = (OrmNamedQuery2_0)ormEntity.getQueryContainer().addNamedQuery(0);
        namedQuery2.setName("BAR");
        namedQuery2.setSpecifiedLockMode(LockModeType2_0.READ);
        resourceQuery = (XmlNamedQuery)entityResource.getNamedQueries().get(0);
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)resourceQuery.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.READ, (Object)this.lockModeOf(resourceQuery));
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(1)).getName());
        OrmNamedQuery2_0 namedQuery3 = (OrmNamedQuery2_0)ormEntity.getQueryContainer().addNamedQuery(1);
        namedQuery3.setName("BAZ");
        namedQuery3.setSpecifiedLockMode(LockModeType2_0.WRITE);
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(0)).getName());
        resourceQuery = (XmlNamedQuery)entityResource.getNamedQueries().get(1);
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)resourceQuery.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.WRITE, (Object)this.lockModeOf(resourceQuery));
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(2)).getName());
        ListIterator namedQueries = ormEntity.getQueryContainer().getNamedQueries().iterator();
        GenericOrmEntity2_0Tests.assertEquals((Object)namedQuery2, namedQueries.next());
        GenericOrmEntity2_0Tests.assertEquals((Object)namedQuery3, namedQueries.next());
        GenericOrmEntity2_0Tests.assertEquals((Object)namedQuery, namedQueries.next());
        namedQueries = ormEntity.getQueryContainer().getNamedQueries().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
    }

    public void testRemoveNamedQuery() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        ormEntity.getQueryContainer().addNamedQuery(0).setName("FOO");
        OrmNamedQuery2_0 namedQuery1 = (OrmNamedQuery2_0)ormEntity.getQueryContainer().addNamedQuery(1);
        namedQuery1.setName("BAR");
        namedQuery1.setSpecifiedLockMode(LockModeType2_0.READ);
        OrmNamedQuery2_0 namedQuery2 = (OrmNamedQuery2_0)ormEntity.getQueryContainer().addNamedQuery(2);
        namedQuery2.setName("BAZ");
        namedQuery2.setSpecifiedLockMode(LockModeType2_0.OPTIMISTIC);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)entityResource.getNamedQueries().size());
        ormEntity.getQueryContainer().removeNamedQuery(0);
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)entityResource.getNamedQueries().size());
        XmlNamedQuery xmlQuery0 = (XmlNamedQuery)entityResource.getNamedQueries().get(0);
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)xmlQuery0.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.READ, (Object)this.lockModeOf(xmlQuery0));
        XmlNamedQuery xmlQuery1 = (XmlNamedQuery)entityResource.getNamedQueries().get(1);
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)xmlQuery1.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)this.lockModeOf(xmlQuery1));
        ormEntity.getQueryContainer().removeNamedQuery(0);
        GenericOrmEntity2_0Tests.assertEquals((int)1, (int)entityResource.getNamedQueries().size());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(0)).getName());
        xmlQuery0 = (XmlNamedQuery)entityResource.getNamedQueries().get(0);
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)xmlQuery0.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)this.lockModeOf(xmlQuery0));
        ormEntity.getQueryContainer().removeNamedQuery(0);
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)entityResource.getNamedQueries().size());
    }

    public void testMoveNamedQuery() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        ormEntity.getQueryContainer().addNamedQuery(0).setName("FOO");
        OrmNamedQuery2_0 namedQuery1 = (OrmNamedQuery2_0)ormEntity.getQueryContainer().addNamedQuery(1);
        namedQuery1.setName("BAR");
        namedQuery1.setSpecifiedLockMode(LockModeType2_0.OPTIMISTIC);
        ormEntity.getQueryContainer().addNamedQuery(2).setName("BAZ");
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)entityResource.getNamedQueries().size());
        ormEntity.getQueryContainer().moveNamedQuery(2, 0);
        ListIterator namedQueries = ormEntity.getQueryContainer().getNamedQueries().iterator();
        namedQuery1 = (OrmNamedQuery2_0)namedQueries.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)namedQuery1.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)namedQuery1.getLockMode());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        XmlNamedQuery xmlQuery0 = (XmlNamedQuery)entityResource.getNamedQueries().get(0);
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)xmlQuery0.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)this.lockModeOf(xmlQuery0));
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(1)).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(2)).getName());
        ormEntity.getQueryContainer().moveNamedQuery(0, 1);
        namedQueries = ormEntity.getQueryContainer().getNamedQueries().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        namedQuery1 = (OrmNamedQuery2_0)namedQueries.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)namedQuery1.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)namedQuery1.getLockMode());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(0)).getName());
        XmlNamedQuery xmlQuery1 = (XmlNamedQuery)entityResource.getNamedQueries().get(1);
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)xmlQuery1.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)this.lockModeOf(xmlQuery1));
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((XmlNamedQuery)entityResource.getNamedQueries().get(2)).getName());
    }

    public void testUpdateNamedQueries() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)ormEntity.getPersistenceUnit().getQueriesSize());
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getNamedQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        entityResource.getNamedQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        entityResource.getNamedQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        ((XmlNamedQuery)entityResource.getNamedQueries().get(0)).setName("FOO");
        ((XmlNamedQuery)entityResource.getNamedQueries().get(1)).setName("BAR");
        XmlNamedQuery xmlQuery = (XmlNamedQuery)entityResource.getNamedQueries().get(2);
        xmlQuery.setName("BAZ");
        xmlQuery.setLockMode(LockModeType_2_0.OPTIMISTIC);
        ListIterator namedQueries = ormEntity.getQueryContainer().getNamedQueries().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        OrmNamedQuery2_0 namedQuery1 = (OrmNamedQuery2_0)namedQueries.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)namedQuery1.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)namedQuery1.getLockMode());
        GenericOrmEntity2_0Tests.assertFalse((boolean)namedQueries.hasNext());
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)ormEntity.getPersistenceUnit().getQueriesSize());
        entityResource.getNamedQueries().move(2, 0);
        namedQueries = ormEntity.getQueryContainer().getNamedQueries().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        namedQuery1 = (OrmNamedQuery2_0)namedQueries.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)namedQuery1.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)namedQuery1.getLockMode());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)namedQueries.hasNext());
        entityResource.getNamedQueries().move(0, 1);
        namedQueries = ormEntity.getQueryContainer().getNamedQueries().iterator();
        namedQuery1 = (OrmNamedQuery2_0)namedQueries.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)namedQuery1.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)namedQuery1.getLockMode());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)namedQueries.hasNext());
        entityResource.getNamedQueries().remove(1);
        namedQueries = ormEntity.getQueryContainer().getNamedQueries().iterator();
        namedQuery1 = (OrmNamedQuery2_0)namedQueries.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)namedQuery1.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)namedQuery1.getLockMode());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)namedQueries.hasNext());
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)ormEntity.getPersistenceUnit().getQueriesSize());
        entityResource.getNamedQueries().remove(1);
        namedQueries = ormEntity.getQueryContainer().getNamedQueries().iterator();
        namedQuery1 = (OrmNamedQuery2_0)namedQueries.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)namedQuery1.getName());
        GenericOrmEntity2_0Tests.assertEquals((Object)LockModeType2_0.OPTIMISTIC, (Object)namedQuery1.getLockMode());
        GenericOrmEntity2_0Tests.assertFalse((boolean)namedQueries.hasNext());
        GenericOrmEntity2_0Tests.assertEquals((int)1, (int)ormEntity.getPersistenceUnit().getQueriesSize());
        entityResource.getNamedQueries().remove(0);
        GenericOrmEntity2_0Tests.assertFalse((boolean)ormEntity.getQueryContainer().getNamedQueries().iterator().hasNext());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)ormEntity.getPersistenceUnit().getQueriesSize());
    }

    public void testAttributeMappingKeyAllowed() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        OrmEntity entity = (OrmEntity)ormPersistentType.getMapping();
        GenericOrmEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basic"));
        GenericOrmEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("id"));
        GenericOrmEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embedded"));
        GenericOrmEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embeddedId"));
        GenericOrmEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("version"));
        GenericOrmEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("transient"));
        GenericOrmEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToOne"));
        GenericOrmEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToOne"));
        GenericOrmEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToMany"));
        GenericOrmEntity2_0Tests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToMany"));
    }

    public void testOverridableAttributes() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)ormPersistentType.getMapping();
        Iterator overridableAttributes = entity.getOverridableAttributeNames().iterator();
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAttributes.hasNext());
        entity.setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributes = entity.getOverridableAttributeNames().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testOverridableAttributeNames() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)ormPersistentType.getMapping();
        Iterator overridableAttributeNames = entity.getOverridableAttributeNames().iterator();
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAttributeNames.hasNext());
        entity.setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        overridableAttributeNames = entity.getOverridableAttributeNames().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testAllOverridableAttributes() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator overridableAttributes = this.getJavaEntity().getAllOverridableAttributeNames().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAttributesTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        Iterator overridableAttributes = ormEntity.getAllOverridableAttributeNames().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAttributes.hasNext());
        OrmEntity abstractEntity = (OrmEntity)ormEntity.getParentEntity();
        overridableAttributes = abstractEntity.getAllOverridableAttributeNames().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributes.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributes.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)((String)overridableAttributes.next()));
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAttributes.hasNext());
    }

    public void testAllOverridableAssociationsTablePerClass() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        Iterator overridableAssociations = ormEntity.getAllOverridableAssociationNames().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"address3", (String)((String)overridableAssociations.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"address4", (String)((String)overridableAssociations.next()));
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAssociations.hasNext());
        OrmEntity abstractEntity = (OrmEntity)ormEntity.getParentEntity();
        overridableAssociations = abstractEntity.getAllOverridableAssociationNames().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"address3", (String)((String)overridableAssociations.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"address4", (String)((String)overridableAssociations.next()));
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testAllOverridableAttributeNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        Iterator overridableAttributeNames = ormEntity.getAllOverridableAttributeNames().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)((String)overridableAttributeNames.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((String)overridableAttributeNames.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)((String)overridableAttributeNames.next()));
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = entity.getAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAttributeOverrides().add(0, (Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).setName("FOO");
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        entityResource.getAttributeOverrides().add(1, (Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(1)).setName("BAR");
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        entityResource.getAttributeOverrides().add(0, (Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).setName("BAZ");
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        entityResource.getAttributeOverrides().move(1, 0);
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        entityResource.getAttributeOverrides().remove(0);
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        entityResource.getAttributeOverrides().remove(0);
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)specifiedAttributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        entityResource.getAttributeOverrides().remove(0);
        specifiedAttributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testDefaultAttributeOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)entityResource.getAttributeOverrides().size());
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        OrmMappedSuperclass mappedSuperclass = (OrmMappedSuperclass)ormEntity.getPersistentType().getSuperPersistentType().getMapping();
        mappedSuperclass.getPersistentType().getAttributeNamed("id").convertToSpecified();
        BasicMapping idMapping = (BasicMapping)mappedSuperclass.getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.getColumn().setSpecifiedTable("BAR");
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)entityResource.getAttributeOverrides().size());
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTable());
        idMapping.getColumn().setSpecifiedName(null);
        idMapping.getColumn().setSpecifiedTable(null);
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)entityResource.getAttributeOverrides().size());
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride.convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testDefaultAttributeOverridesEntityHierachy() throws Exception {
        this.createTestAbstractEntityTablePerClass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)entityResource.getAttributeOverrides().size());
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        OrmEntity superclass = (OrmEntity)ormEntity.getParentEntity();
        superclass.getPersistentType().getAttributeNamed("id").convertToSpecified();
        BasicMapping idMapping = (BasicMapping)superclass.getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.getColumn().setSpecifiedTable("BAR");
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)entityResource.getAttributeOverrides().size());
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)virtualAttributeOverride.getColumn().getTable());
        idMapping.getColumn().setSpecifiedName(null);
        idMapping.getColumn().setSpecifiedTable(null);
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)entityResource.getAttributeOverrides().size());
        virtualAttributeOverride = (VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)SUB_TYPE_NAME, (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride.convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)overrideContainer.getSpecifiedOverridesSize());
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).setName("FOO");
        entityResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).setName("BAR");
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)overrideContainer.getSpecifiedOverridesSize());
    }

    public void testDefaultAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getOverridesSize());
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getOverridesSize());
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAttributeOverrides().add(0, (Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).setName("bar");
        GenericOrmEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(1)).getName());
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)entityResource.getAttributeOverrides().size());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverrides.next();
        ((OrmVirtualAttributeOverride)virtualAttributeOverrides.next()).convertToSpecified();
        ((OrmVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(1)).getName());
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)entityResource.getAttributeOverrides().size());
    }

    public void testAttributeOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        ((OrmVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((OrmVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((OrmVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)entityResource.getAttributeOverrides().size());
        ((OrmAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(1)).getName());
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)entityResource.getAttributeOverrides().size());
        ListIterator attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((OrmAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).getName());
        GenericOrmEntity2_0Tests.assertEquals((int)1, (int)entityResource.getAttributeOverrides().size());
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((OrmAttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)entityResource.getAttributeOverrides().size());
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        ((OrmVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((OrmVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((OrmVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)entityResource.getAttributeOverrides().size());
        overrideContainer.moveSpecifiedOverride(2, 0);
        ListIterator attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(1)).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(2)).getName());
        overrideContainer.moveSpecifiedOverride(0, 1);
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(1)).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)((XmlAttributeOverride)entityResource.getAttributeOverrides().get(2)).getName());
    }

    public void testUpdateSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAttributeOverrides().add(0, (Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(0)).setName("FOO");
        entityResource.getAttributeOverrides().add(1, (Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(1)).setName("BAR");
        entityResource.getAttributeOverrides().add(2, (Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)entityResource.getAttributeOverrides().get(2)).setName("BAZ");
        ListIterator attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        entityResource.getAttributeOverrides().move(2, 0);
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        entityResource.getAttributeOverrides().move(0, 1);
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        entityResource.getAttributeOverrides().remove(1);
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        entityResource.getAttributeOverrides().remove(1);
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        entityResource.getAttributeOverrides().remove(0);
        attributeOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testAttributeOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAttributeOverrideContainer overrideContainer = ormEntity.getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = overrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAttributeOverride virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        GenericOrmEntity2_0Tests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
        ((OrmVirtualAttributeOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        AttributeOverride specifiedAttributeOverride = (AttributeOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAttributeOverride.isVirtual());
        virtualAttributeOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"foo", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)virtualAttributeOverride.isVirtual());
        GenericOrmEntity2_0Tests.assertFalse((boolean)virtualAttributeOverrides.hasNext());
    }

    public void testOverridableAssociationNames() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        OrmEntity entity = (OrmEntity)ormPersistentType.getMapping();
        Iterator overridableAssociationNames = entity.getOverridableAssociationNames().iterator();
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociationNames() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        Iterator overridableAssociationNames = ormEntity.getAllOverridableAssociationNames().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)((String)overridableAssociationNames.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)((String)overridableAssociationNames.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"address3", (String)((String)overridableAssociationNames.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"address4", (String)((String)overridableAssociationNames.next()));
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testAllOverridableAssociations() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        Iterator overridableAssociations = ormEntity.getAllOverridableAssociationNames().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)((String)overridableAssociations.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)((String)overridableAssociations.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"address3", (String)((String)overridableAssociations.next()));
        GenericOrmEntity2_0Tests.assertEquals((String)"address4", (String)((String)overridableAssociations.next()));
        GenericOrmEntity2_0Tests.assertFalse((boolean)overridableAssociations.hasNext());
    }

    public void testSpecifiedAssociationOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        ListIterator specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlAssociationOverride xmlAssociationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        entityResource.getAssociationOverrides().add(0, (Object)xmlAssociationOverride);
        xmlAssociationOverride.setName("FOO");
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        xmlAssociationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        entityResource.getAssociationOverrides().add(1, (Object)xmlAssociationOverride);
        xmlAssociationOverride.setName("BAR");
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        xmlAssociationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        entityResource.getAssociationOverrides().add(0, (Object)xmlAssociationOverride);
        xmlAssociationOverride.setName("BAZ");
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        entityResource.getAssociationOverrides().move(1, 0);
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        entityResource.getAssociationOverrides().remove(0);
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        entityResource.getAssociationOverrides().remove(0);
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        entityResource.getAssociationOverrides().remove(0);
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
    }

    public void testDefaultAssociationOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((String)FULLY_QUALIFIED_SUB_TYPE_NAME, (String)entityResource.getClassName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)entityResource.getAssociationOverrides().isEmpty());
        GenericOrmEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getVirtualOverridesSize());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride.convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAssociationOverridesSize() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)overrideContainer.getSpecifiedOverridesSize());
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        ((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).setName("FOO");
        entityResource.getAssociationOverrides().add(0, (Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        ((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).setName("BAR");
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)overrideContainer.getSpecifiedOverridesSize());
    }

    public void testDefaultAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        GenericOrmEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)3, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testAssociationOverridesSize() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        GenericOrmEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((int)4, (int)overrideContainer.getOverridesSize());
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add(0, (Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        ((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).setName("bar");
        GenericOrmEntity2_0Tests.assertEquals((int)5, (int)overrideContainer.getOverridesSize());
    }

    public void testAssociationOverrideSetVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(1)).getName());
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)entityResource.getAssociationOverrides().size());
    }

    public void testAssociationOverrideSetVirtual2() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAssociationOverrides.next();
        ((OrmVirtualAssociationOverride)virtualAssociationOverrides.next()).convertToSpecified();
        ((OrmVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(1)).getName());
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)entityResource.getAssociationOverrides().size());
    }

    public void testAssociationOverrideSetVirtualTrue() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        ((OrmVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((OrmVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)entityResource.getAssociationOverrides().size());
        ((OrmAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEntity2_0Tests.assertEquals((int)1, (int)entityResource.getAssociationOverrides().size());
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        ((OrmAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)entityResource.getAssociationOverrides().size());
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testMoveSpecifiedAssociationOverride() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        ((OrmVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((OrmVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals((int)2, (int)entityResource.getAssociationOverrides().size());
        overrideContainer.moveSpecifiedOverride(1, 0);
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(1)).getName());
        overrideContainer.moveSpecifiedOverride(0, 1);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(1)).getName());
    }

    public void testUpdateSpecifiedAssociationOverrides() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add(0, (Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        ((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).setName("FOO");
        entityResource.getAssociationOverrides().add(1, (Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        ((XmlAssociationOverride)entityResource.getAssociationOverrides().get(1)).setName("BAR");
        entityResource.getAssociationOverrides().add(2, (Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        ((XmlAssociationOverride)entityResource.getAssociationOverrides().get(2)).setName("BAZ");
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        entityResource.getAssociationOverrides().move(2, 0);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        entityResource.getAssociationOverrides().move(0, 1);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        entityResource.getAssociationOverrides().remove(1);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        entityResource.getAssociationOverrides().remove(1);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        entityResource.getAssociationOverrides().remove(0);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEntity2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAssociationOverride virtualAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)virtualAssociationOverride.getName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address3", (String)virtualAssociationOverride.getName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address4", (String)virtualAssociationOverride.getName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        GenericOrmEntity2_0Tests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
        ((OrmVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertFalse((boolean)specifiedAssociationOverride.isVirtual());
        virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address2", (String)virtualAssociationOverride.getName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address3", (String)virtualAssociationOverride.getName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address4", (String)virtualAssociationOverride.getName());
        GenericOrmEntity2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        GenericOrmEntity2_0Tests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestMappedSuperclassCustomer();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        OrmPersistentType longTimeCustomerPersistentType = this.getEntityMappings().addPersistentType("entity", "test.LongTimeCustomer");
        OrmPersistentType addressPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentType zipCodePersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.ZipCode");
        OrmAttributeOverrideContainer attributeOverrideContainer = ((OrmEntity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        GenericOrmEntity2_0Tests.assertEquals((int)6, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAttributeOverride virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address.street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address.city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address.zipCode.zip", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTable());
        GenericOrmEntity2_0Tests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEntity2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        zipCodePersistentType.getAttributeNamed("plusfour").convertToSpecified();
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTable("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        attributeOverrideContainer = ((OrmEntity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (OrmVirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        GenericOrmEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericOrmEntity2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEntity2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEntity2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEntity2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        addressPersistentType.getAttributeNamed("zipCode").convertToSpecified();
        OrmAttributeOverride specifiedAttributeOverride = ((OrmVirtualAttributeOverride)((OrmEmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour")).convertToSpecified();
        specifiedAttributeOverride.getColumn().setSpecifiedName("BLAH_OVERRIDE");
        specifiedAttributeOverride.getColumn().setSpecifiedTable("BLAH_TABLE_OVERRIDE");
        specifiedAttributeOverride.getColumn().setColumnDefinition("COLUMN_DEFINITION_OVERRIDE");
        attributeOverrideContainer = ((OrmEntity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (OrmVirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        GenericOrmEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericOrmEntity2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEntity2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        specifiedAttributeOverride = virtualAttributeOverride.convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.isVirtual());
        GenericOrmEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)specifiedAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedTable());
        GenericOrmEntity2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        GenericOrmEntity2_0Tests.assertEquals((int)255, (int)specifiedAttributeOverride.getColumn().getLength());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getPrecision());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getScale());
    }

    public void testNestedVirtualAttributeOverridesElementCollection() throws Exception {
        this.createTestMappedSuperclassCustomerWithElementCollection();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.Customer");
        OrmPersistentType longTimeCustomerPersistentType = this.getEntityMappings().addPersistentType("entity", "test.LongTimeCustomer");
        OrmPersistentType addressPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentType zipCodePersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.ZipCode");
        OrmAttributeOverrideContainer attributeOverrideContainer = ((OrmEntity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        GenericOrmEntity2_0Tests.assertEquals((int)6, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAttributeOverride virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"id", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address.street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address.city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address.zipCode.zip", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride = (OrmVirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"LongTimeCustomer", (String)virtualAttributeOverride.getColumn().getTable());
        GenericOrmEntity2_0Tests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEntity2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        zipCodePersistentType.getAttributeNamed("plusfour").convertToSpecified();
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTable("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        attributeOverrideContainer = ((OrmEntity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (OrmVirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        GenericOrmEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericOrmEntity2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEntity2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEntity2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEntity2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        addressPersistentType.getAttributeNamed("zipCode").convertToSpecified();
        OrmAttributeOverride specifiedAttributeOverride = ((OrmVirtualAttributeOverride)((OrmEmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour")).convertToSpecified();
        specifiedAttributeOverride.getColumn().setSpecifiedName("BLAH_OVERRIDE");
        specifiedAttributeOverride.getColumn().setSpecifiedTable("BLAH_TABLE_OVERRIDE");
        specifiedAttributeOverride.getColumn().setColumnDefinition("COLUMN_DEFINITION_OVERRIDE");
        attributeOverrideContainer = ((OrmEntity)longTimeCustomerPersistentType.getMapping()).getAttributeOverrideContainer();
        virtualAttributeOverride = (OrmVirtualAttributeOverride)attributeOverrideContainer.getOverrideNamed("address.zipCode.plusfour");
        GenericOrmEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericOrmEntity2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEntity2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        specifiedAttributeOverride = virtualAttributeOverride.convertToSpecified();
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.isVirtual());
        GenericOrmEntity2_0Tests.assertEquals((String)"address.zipCode.plusfour", (String)specifiedAttributeOverride.getName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedTable());
        GenericOrmEntity2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        GenericOrmEntity2_0Tests.assertEquals((int)255, (int)specifiedAttributeOverride.getColumn().getLength());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getPrecision());
        GenericOrmEntity2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getScale());
    }

    public void testNestedVirtualAssociationOverrides() throws Exception {
        this.createTestMappedSuperclassCustomer();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.Customer");
        OrmPersistentType longTimeCustomerPersistentType = this.getEntityMappings().addPersistentType("entity", "test.LongTimeCustomer");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.ZipCode");
        OrmAssociationOverrideContainer attributeOverrideContainer = ((OrmEntity)longTimeCustomerPersistentType.getMapping()).getAssociationOverrideContainer();
        GenericOrmEntity2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAssociationOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAssociationOverride virtualAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address.state", (String)virtualAssociationOverride.getName());
    }

    public void testNestedVirtualAssociationOverridesElementCollection() throws Exception {
        this.createTestMappedSuperclassCustomerWithElementCollection();
        this.createTestEntityLongTimeCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.Customer");
        OrmPersistentType longTimeCustomerPersistentType = this.getEntityMappings().addPersistentType("entity", "test.LongTimeCustomer");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.ZipCode");
        OrmAssociationOverrideContainer overrideContainer = ((OrmEntity)longTimeCustomerPersistentType.getMapping()).getAssociationOverrideContainer();
        GenericOrmEntity2_0Tests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAssociationOverride virtualAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEntity2_0Tests.assertEquals((String)"address.state", (String)virtualAssociationOverride.getName());
    }

    public void testSetSpecifiedCacheable() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableHolder2_0)ormPersistentType.getMapping()).getCacheable();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        GenericOrmEntity2_0Tests.assertEquals(null, (Object)entityResource.getCacheable());
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        GenericOrmEntity2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)cacheable.getSpecifiedCacheable());
        GenericOrmEntity2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)entityResource.getCacheable());
        cacheable.setSpecifiedCacheable(Boolean.TRUE);
        GenericOrmEntity2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        GenericOrmEntity2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)entityResource.getCacheable());
        cacheable.setSpecifiedCacheable(null);
        GenericOrmEntity2_0Tests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        GenericOrmEntity2_0Tests.assertEquals(null, (Object)entityResource.getCacheable());
    }

    public void testGetSpecifiedCacheable() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableHolder2_0)ormPersistentType.getMapping()).getCacheable();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        GenericOrmEntity2_0Tests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        GenericOrmEntity2_0Tests.assertEquals(null, (Object)entityResource.getCacheable());
        entityResource.setCacheable(Boolean.TRUE);
        GenericOrmEntity2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        GenericOrmEntity2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)entityResource.getCacheable());
        entityResource.setCacheable(Boolean.FALSE);
        GenericOrmEntity2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)cacheable.getSpecifiedCacheable());
        GenericOrmEntity2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)entityResource.getCacheable());
        entityResource.setCacheable(null);
        GenericOrmEntity2_0Tests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        GenericOrmEntity2_0Tests.assertEquals(null, (Object)entityResource.getCacheable());
    }

    public void testIsDefaultCacheable() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableHolder2_0)ormPersistentType.getMapping()).getCacheable();
        PersistenceUnit2_0 persistenceUnit2_0 = (PersistenceUnit2_0)this.getPersistenceUnit();
        GenericOrmEntity2_0Tests.assertEquals((Object)SharedCacheMode.UNSPECIFIED, (Object)persistenceUnit2_0.getSharedCacheMode());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.ALL);
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.NONE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.DISABLE_SELECTIVE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
    }

    public void testIsDefaultCacheableFromSuperType() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        OrmPersistentType subOrmPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        Cacheable2_0 subCacheable = ((CacheableHolder2_0)subOrmPersistentType.getMapping()).getCacheable();
        Cacheable2_0 cacheable = ((CacheableHolder2_0)ormPersistentType.getMapping()).getCacheable();
        cacheable.setSpecifiedCacheable(Boolean.TRUE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        PersistenceUnit2_0 persistenceUnit2_0 = (PersistenceUnit2_0)this.getPersistenceUnit();
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.DISABLE_SELECTIVE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        cacheable.setSpecifiedCacheable(Boolean.TRUE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
    }

    public void testIsDefaultCacheableFromJava() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        OrmPersistentType subOrmPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        Cacheable2_0 subCacheable = ((CacheableHolder2_0)subOrmPersistentType.getMapping()).getCacheable();
        Cacheable2_0 cacheable = ((CacheableHolder2_0)ormPersistentType.getMapping()).getCacheable();
        Cacheable2_0 javaCacheable = ((CacheableHolder2_0)ormPersistentType.getJavaPersistentType().getMapping()).getCacheable();
        javaCacheable.setSpecifiedCacheable(Boolean.TRUE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        PersistenceUnit2_0 persistenceUnit2_0 = (PersistenceUnit2_0)this.getPersistenceUnit();
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.DISABLE_SELECTIVE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        javaCacheable.setSpecifiedCacheable(Boolean.FALSE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        javaCacheable.setSpecifiedCacheable(Boolean.TRUE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode.DISABLE_SELECTIVE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        javaCacheable.setSpecifiedCacheable(Boolean.FALSE);
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        GenericOrmEntity2_0Tests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
    }

    public void testAssociationOverrideJoinTableUpdate() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity entity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlAssociationOverride resourceAssociationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        resourceEntity.getAssociationOverrides().add((Object)resourceAssociationOverride);
        resourceAssociationOverride.setName("a");
        OrmAssociationOverride associationOverride = (OrmAssociationOverride)entity.getAssociationOverrideContainer().getSpecifiedOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertEquals((String)"a", (String)associationOverride.getName());
        XmlJoinTable resourceJoinTable = OrmFactory.eINSTANCE.createXmlJoinTable();
        resourceAssociationOverride.setJoinTable(resourceJoinTable);
        resourceJoinTable.setName("FOO");
        XmlJoinColumn resourceJoinColumn = OrmFactory.eINSTANCE.createXmlJoinColumn();
        resourceJoinTable.getInverseJoinColumns().add((Object)resourceJoinColumn);
        resourceJoinColumn.setName("BAR");
        associationOverride = (OrmAssociationOverride)entity.getAssociationOverrideContainer().getSpecifiedOverrides().iterator().next();
        GenericOrmEntity2_0Tests.assertEquals((String)"a", (String)associationOverride.getName());
        OrmJoinTable joinTable = ((OrmOverrideRelationship2_0)associationOverride.getRelationship()).getJoinTableStrategy().getJoinTable();
        GenericOrmEntity2_0Tests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedName());
        GenericOrmEntity2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinTable.getInverseJoinColumns().iterator().next()).getName());
    }
}

