/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.Cascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrphanRemovalHolder2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOneToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmDerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOneToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOrphanRemovable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOrphanRemovalHolder2_0;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlDerivedId_2_0;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlMapsId_2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmOneToOneMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericOrmOneToOneMapping2_0Tests(String name) {
        super(name);
    }

    private void createTestEntityWithIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @Id").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.convertToSpecified();
        }
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.MapsId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.convertToSpecified();
        }
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private void createTestEntityWithOneToOneMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.convertToSpecified();
        }
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, orphanRemoval = true, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    public void testUpdateId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.TRUE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.FALSE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(null);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId("foo");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId("bar");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId("");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"", (String)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId(null);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("foo");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("bar");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"", (String)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName(null);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testUpdatePredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        OrmDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setId(Boolean.TRUE);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setMapsId("foo");
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setId(null);
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceMapping.setMapsId(null);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testSetPredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        OrmDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setIdDerivedIdentityStrategy();
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setMapsIdDerivedIdentityStrategy();
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setNullDerivedIdentityStrategy();
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getId());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = (OrmPersistentAttribute)contextType.getAttributeNamed("oneToOne");
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        resourceOneToOne.setId(Boolean.TRUE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceOneToOne.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceOneToOne.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("manyToOne");
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceManyToOne.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceManyToOne.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("oneToOne");
        resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)resourceOneToOne.getId());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceOneToOne.getMapsId());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addSpecifiedAttribute("oneToOne", "address");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        ReadOnlyPersistentAttribute persistentAttribute = (ReadOnlyPersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addSpecifiedAttribute("oneToOne", "address");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        ReadOnlyPersistentAttribute persistentAttribute = (ReadOnlyPersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    private OrmOrphanRemovable2_0 getOrphanRemovalOf(OneToOneMapping2_0 oneToOneMapping) {
        return ((OrmOrphanRemovalHolder2_0)oneToOneMapping).getOrphanRemoval();
    }

    public void testUpdateSpecifiedOrphanRemoval() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        OrmOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf((OneToOneMapping2_0)ormOneToOneMapping);
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToOneMapping2_0Tests.assertEquals(null, (Object)oneToOneResource.getOrphanRemoval());
        oneToOneResource.setOrphanRemoval(Boolean.TRUE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneResource.getOrphanRemoval());
        oneToOneResource.setOrphanRemoval(Boolean.FALSE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneResource.getOrphanRemoval());
    }

    public void testModifySpecifiedOrphanRemoval() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        OrmOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf((OneToOneMapping2_0)ormOneToOneMapping);
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertEquals(null, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericOrmOneToOneMapping2_0Tests.assertEquals(null, (Object)oneToOneResource.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneResource.getOrphanRemoval());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.FALSE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneResource.getOrphanRemoval());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testVirtualJoinTable() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        JavaOneToOneMapping2_0 javaOneToOneMapping = (JavaOneToOneMapping2_0)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        JavaOneToOneMapping2_0 virtualOneToOneMapping = (JavaOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        ((OneToOneRelationship2_0)javaOneToOneMapping.getRelationship()).setStrategyToJoinTable();
        JoinTable virtualJoinTable = ((OneToOneRelationship2_0)virtualOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmOneToOneMapping2_0Tests.assertEquals(null, (String)virtualJoinTable.getSpecifiedName());
        this.createTestTargetEntityAddress();
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)virtualJoinTable.getSpecifiedName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualJoinTable.getDefaultName());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)virtualJoinTable.getSpecifiedCatalog());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)virtualJoinTable.getSpecifiedSchema());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((int)0, (int)virtualJoinTable.getSpecifiedJoinColumnsSize());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((int)0, (int)virtualJoinTable.getSpecifiedInverseJoinColumnsSize());
        JoinColumn ormJoinColumn = virtualJoinTable.getDefaultJoinColumn();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinColumn.getDefaultTable());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_id", (String)ormJoinColumn.getDefaultName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"id", (String)ormJoinColumn.getDefaultReferencedColumnName());
        JoinColumn inverseOrmJoinColumn = virtualJoinTable.getDefaultInverseJoinColumn();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)inverseOrmJoinColumn.getDefaultTable());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"address_id", (String)inverseOrmJoinColumn.getDefaultName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"id", (String)inverseOrmJoinColumn.getDefaultReferencedColumnName());
        JavaJoinTable javaJoinTable = ((JavaOneToOneRelationship2_0)javaOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        javaJoinTable.setSpecifiedName("FOO");
        javaJoinTable.setSpecifiedCatalog("CATALOG");
        javaJoinTable.setSpecifiedSchema("SCHEMA");
        JavaJoinColumn javaJoinColumn = javaJoinTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("REFERENCED_NAME");
        JavaJoinColumn inverseJavaJoinColumn = javaJoinTable.addSpecifiedInverseJoinColumn(0);
        inverseJavaJoinColumn.setSpecifiedName("INVERSE_NAME");
        inverseJavaJoinColumn.setSpecifiedReferencedColumnName("INVERSE_REFERENCED_NAME");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"FOO", (String)virtualJoinTable.getSpecifiedName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"CATALOG", (String)virtualJoinTable.getSpecifiedCatalog());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"SCHEMA", (String)virtualJoinTable.getSpecifiedSchema());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((int)1, (int)virtualJoinTable.getSpecifiedJoinColumnsSize());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((int)1, (int)virtualJoinTable.getSpecifiedInverseJoinColumnsSize());
        ormJoinColumn = (JoinColumn)virtualJoinTable.getSpecifiedJoinColumns().iterator().next();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"NAME", (String)ormJoinColumn.getSpecifiedName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"REFERENCED_NAME", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        inverseOrmJoinColumn = (JoinColumn)virtualJoinTable.getSpecifiedInverseJoinColumns().iterator().next();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"INVERSE_NAME", (String)inverseOrmJoinColumn.getSpecifiedName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"INVERSE_REFERENCED_NAME", (String)inverseOrmJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "address");
        OrmOneToOneMapping2_0 ormOneToOneMapping = (OrmOneToOneMapping2_0)ormPersistentAttribute.getMapping();
        ((OneToOneRelationship2_0)ormOneToOneMapping.getRelationship()).setStrategyToJoinTable();
        OrmJoinTable ormJoinTable = ((OrmOneToOneRelationship2_0)ormOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        GenericOrmOneToOneMapping2_0Tests.assertEquals(null, (String)ormJoinTable.getDefaultName());
        this.createTestTargetEntityAddress();
        OrmPersistentType targetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)targetPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("FOO");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_FOO", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)ormPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("BAR");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        JavaOneToOneMapping2_0 javaOneToOneMapping = (JavaOneToOneMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("address").getMapping();
        ((OneToOneRelationship2_0)javaOneToOneMapping.getRelationship()).setStrategyToJoinTable();
        ((OneToOneRelationship2_0)javaOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute virtualAttribute = ormPersistentType.getAttributeNamed("address");
        OneToOneMapping2_0 virtualOneToOneMapping = (OneToOneMapping2_0)virtualAttribute.getMapping();
        JoinTable virtualJoinTable = ((OneToOneRelationship2_0)virtualOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)virtualAttribute.isVirtual());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"JAVA_JOIN_TABLE", (String)virtualJoinTable.getSpecifiedName());
        ((OneToOneRelationship2_0)javaOneToOneMapping.getRelationship()).getJoinTableStrategy().removeStrategy();
        virtualJoinTable = ((OneToOneRelationship2_0)virtualOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)virtualJoinTable);
        ((OneToOneRelationship2_0)javaOneToOneMapping.getRelationship()).setStrategyToJoinTable();
        virtualJoinTable = ((OneToOneRelationship2_0)virtualOneToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)virtualJoinTable.getName());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)virtualJoinTable.getSpecifiedName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"BAR_FOO", (String)virtualJoinTable.getDefaultName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE_NAME");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"ORM_TABLE_NAME_FOO", (String)virtualJoinTable.getDefaultName());
        ((OrmEntity)targetPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TARGET");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"ORM_TABLE_NAME_ORM_TARGET", (String)virtualJoinTable.getDefaultName());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        OrmOneToOneRelationship2_0 rel = (OrmOneToOneRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToMappedBy();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToPrimaryKeyJoinColumn();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinTable();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmOneToOneMapping2_0 contextMapping = (OrmOneToOneMapping2_0)contextAttribute.getMapping();
        OrmOneToOneRelationship2_0 rel = (OrmOneToOneRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getPrimaryKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getPrimaryKeyJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNotNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)resourceMapping.getJoinTable());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.getVirtualAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next();
        OneToOneMapping2_0 virtualOneToOneMapping = (OneToOneMapping2_0)virtualPersistentAttribute.getMapping();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"address", (String)virtualOneToOneMapping.getName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)virtualOneToOneMapping.getSpecifiedFetch());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualOneToOneMapping.getSpecifiedOptional());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"Address", (String)virtualOneToOneMapping.getSpecifiedTargetEntity());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)virtualOneToOneMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        JoinColumn virtualJoinColumn = (JoinColumn)virtualOneToOneMapping.getRelationship().getJoinColumnStrategy().getSpecifiedJoinColumns().iterator().next();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"MY_COLUMN", (String)virtualJoinColumn.getSpecifiedName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)virtualJoinColumn.getSpecifiedReferencedColumnName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)virtualJoinColumn.getSpecifiedUnique());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedNullable());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedInsertable());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedUpdatable());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualJoinColumn.getColumnDefinition());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"MY_TABLE", (String)virtualJoinColumn.getSpecifiedTable());
        Cascade2_0 cascade = (Cascade2_0)virtualOneToOneMapping.getCascade();
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)cascade.isAll());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)cascade.isMerge());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)cascade.isPersist());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)cascade.isRemove());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)cascade.isRefresh());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)cascade.isDetach());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)((OrphanRemovalHolder2_0)virtualOneToOneMapping).getOrphanRemoval().isOrphanRemoval());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmOneToOneMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.getVirtualAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)virtualPersistentAttribute.getMappingKey());
        GenericOrmOneToOneMapping2_0Tests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        virtualPersistentAttribute.convertToSpecified("oneToOne");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OneToOneMapping2_0 ormOneToOneMapping = (OneToOneMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getFetch());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((boolean)true, (boolean)ormOneToOneMapping.isOptional());
        GenericOrmOneToOneMapping2_0Tests.assertEquals((String)"test.Address", (String)ormOneToOneMapping.getTargetEntity());
        GenericOrmOneToOneMapping2_0Tests.assertNull((Object)ormOneToOneMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade2_0 cascade = (Cascade2_0)ormOneToOneMapping.getCascade();
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)cascade.isAll());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)cascade.isMerge());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)cascade.isPersist());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)cascade.isRemove());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)cascade.isRefresh());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)cascade.isDetach());
        GenericOrmOneToOneMapping2_0Tests.assertFalse((boolean)((OrmOrphanRemovalHolder2_0)ormOneToOneMapping).getOrphanRemoval().isOrphanRemoval());
    }
}

