/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyEnumerated2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.EnumType;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class MapKeyEnumerated2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public MapKeyEnumerated2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMapKeyEnumerated() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyEnumerated"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyEnumerated");
            }
        });
    }

    private ICompilationUnit createTestMapKeyEnumeratedWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKeyEnumerated", "javax.persistence.EnumType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyEnumerated(EnumType.ORDINAL)");
            }
        });
    }

    public void testMapKeyEnumerated() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyEnumerated();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated");
        MapKeyEnumerated2_0AnnotationTests.assertNotNull((Object)enumerated);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyEnumeratedWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated");
        MapKeyEnumerated2_0AnnotationTests.assertEquals((Object)EnumType.ORDINAL, (Object)enumerated.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyEnumerated();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated");
        enumerated.setValue(EnumType.STRING);
        this.assertSourceContains("@MapKeyEnumerated(STRING)", cu);
        enumerated.setValue(null);
        this.assertSourceDoesNotContain("@MapKeyEnumerated(", cu);
        this.assertSourceContains("@MapKeyEnumerated", cu);
    }
}

