/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.model;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.common.core.tests.internal.projects.TestFacetedProject;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.projects.TestPlatformProject;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaProjectManagerTests
extends TestCase {
    public static final String CR = System.getProperty("line.separator");
    protected TestFacetedProject testProject;

    public JpaProjectManagerTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.debug()) {
            this.printName();
        }
        this.testProject = this.buildTestProject();
    }

    private boolean debug() {
        Boolean debug = (Boolean)ReflectionTools.getStaticFieldValue(this.getGenericJpaProjectManagerClass(), (String)"DEBUG");
        return debug;
    }

    private Class<?> getGenericJpaProjectManagerClass() {
        return JptJpaCorePlugin.getJpaProjectManager().getClass();
    }

    private void printName() {
        String name = this.getName();
        System.out.println();
        System.out.println();
        this.printNameBorder(name);
        System.out.println(name);
        this.printNameBorder(name);
    }

    private void printNameBorder(String name) {
        int i = name.length();
        while (i-- > 0) {
            System.out.print('=');
        }
        System.out.println();
    }

    protected void tearDown() throws Exception {
        this.testProject.getProject().delete(true, true, null);
        this.testProject = null;
        super.tearDown();
    }

    private TestFacetedProject buildTestProject() throws Exception {
        TestJavaProject tjp = TestJavaProject.buildJavaProject((String)((Object)((Object)this)).getClass().getSimpleName(), (boolean)true);
        tjp.createCompilationUnit("test.pkg", "TestEntity.java", "@Entity public class TestEntity {}");
        tjp.createCompilationUnit("test.pkg", "TestEntity2.java", "@Entity public class TestEntity2 {}");
        return tjp;
    }

    private IFile getFile(TestPlatformProject p, String path) {
        return p.getProject().getFile((IPath)new Path(path));
    }

    public void testDEBUG() {
        this.verifyDEBUG(this.getGenericJpaProjectManagerClass());
    }

    private void verifyDEBUG(Class<?> clazz) {
        JpaProjectManagerTests.assertFalse((String)("Recompile with \"DEBUG = false\": " + clazz.getName()), (boolean)((Boolean)ReflectionTools.getStaticFieldValue(clazz, (String)"DEBUG")));
    }

    public void testJpaProjectManager() {
        JpaProjectManagerTests.assertNotNull((Object)JptJpaCorePlugin.getJpaProjectManager());
    }

    protected IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetInstallDataModelProvider());
        dataModel.setProperty("JpaFacetInstallDataModelProperties.CREATE_ORM_XML", (Object)Boolean.TRUE);
        return dataModel;
    }

    public void testProjectCloseReopen() throws Exception {
        this.testProject.installFacet("jpt.jpa", "1.0", (Object)this.buildJpaConfigDataModel());
        JpaProject jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        this.testProject.getProject().close(null);
        JpaProjectManagerTests.assertFalse((String)"Project is not closed", (boolean)this.testProject.getProject().isOpen());
        jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject());
        JpaProjectManagerTests.assertNull((String)"JpaProject is not null", (Object)jpaProject);
        this.testProject.getProject().open(null);
        JpaProjectManagerTests.assertTrue((boolean)this.testProject.getProject().isOpen());
        jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject());
        JpaProjectManagerTests.assertNotNull((String)"JpaProject is null", (Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)4, (int)jpaProject.getJpaFilesSize());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/test/pkg/TestEntity.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/test/pkg/TestEntity2.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/META-INF/persistence.xml")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/META-INF/orm.xml")));
    }

    public void testProjectDeleteReimport() throws Exception {
        this.testProject.installFacet("jpt.jpa", "1.0", (Object)this.buildJpaConfigDataModel());
        JpaProject jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)1, (int)JptJpaCorePlugin.getJpaProjectManager().getJpaProjectsSize());
        this.testProject.getProject().delete(false, true, null);
        jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject());
        JpaProjectManagerTests.assertNull((Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)0, (int)JptJpaCorePlugin.getJpaProjectManager().getJpaProjectsSize());
        JpaProjectManagerTests.assertEquals((int)0, (int)ResourcesPlugin.getWorkspace().getRoot().getProjects().length);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testProject.getProject().getName());
        project.create(null);
        JpaProjectManagerTests.assertEquals((int)1, (int)ResourcesPlugin.getWorkspace().getRoot().getProjects().length);
        project.open(null);
        JpaProjectManagerTests.assertTrue((boolean)project.isOpen());
        JpaProjectManagerTests.assertTrue((boolean)JpaFacet.isInstalled((IProject)project));
        jpaProject = JptJpaCorePlugin.getJpaProject((IProject)project);
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)4, (int)jpaProject.getJpaFilesSize());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/test/pkg/TestEntity.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/test/pkg/TestEntity2.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/META-INF/persistence.xml")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/META-INF/orm.xml")));
    }

    public void testFacetInstallUninstall() throws Exception {
        JpaProjectManagerTests.assertNull((Object)JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject()));
        this.testProject.installFacet("jpt.jpa", "1.0", (Object)this.buildJpaConfigDataModel());
        JpaProjectManagerTests.assertEquals((int)1, (int)JptJpaCorePlugin.getJpaProjectManager().getJpaProjectsSize());
        JpaProject jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)4, (int)jpaProject.getJpaFilesSize());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/test/pkg/TestEntity.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/test/pkg/TestEntity2.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/META-INF/persistence.xml")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/META-INF/orm.xml")));
        this.testProject.uninstallFacet("jpt.jpa", "1.0");
        JpaProjectManagerTests.assertEquals((int)0, (int)JptJpaCorePlugin.getJpaProjectManager().getJpaProjectsSize());
        jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject());
        JpaProjectManagerTests.assertNull((Object)jpaProject);
    }

    public void testEditFacetSettingsFileAddThenRemoveJpaFacet() throws Exception {
        JpaProjectManagerTests.assertNull((Object)JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject()));
        IFile facetSettingsFile = this.getFile((TestPlatformProject)this.testProject, ".settings/org.eclipse.wst.common.project.facet.core.xml");
        BufferedInputStream inStream = new BufferedInputStream(facetSettingsFile.getContents());
        int fileSize = ((InputStream)inStream).available();
        byte[] buf = new byte[fileSize];
        ((InputStream)inStream).read(buf);
        ((InputStream)inStream).close();
        String oldDocument = new String(buf);
        String oldString = "<installed facet=\"java\" version=\"1.5\"/>";
        String newString = String.valueOf(oldString) + CR + "  " + "<installed facet=\"jpt.jpa\" version=\"1.0\"/>";
        String newDocument = oldDocument.replaceAll(oldString, newString);
        facetSettingsFile.setContents((InputStream)new ByteArrayInputStream(newDocument.getBytes()), false, false, null);
        JpaProjectManagerTests.assertEquals((int)1, (int)JptJpaCorePlugin.getJpaProjectManager().getJpaProjectsSize());
        JpaProject jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)2, (int)jpaProject.getJpaFilesSize());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/test/pkg/TestEntity.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/test/pkg/TestEntity2.java")));
        facetSettingsFile.setContents((InputStream)new ByteArrayInputStream(oldDocument.getBytes()), false, false, null);
        JpaProjectManagerTests.assertEquals((int)0, (int)JptJpaCorePlugin.getJpaProjectManager().getJpaProjectsSize());
        jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject());
        JpaProjectManagerTests.assertNull((Object)jpaProject);
    }

    public void testEditFacetSettingsFileRemoveThenAddJpaFacet() throws Exception {
        this.testProject.installFacet("jpt.jpa", "1.0", (Object)this.buildJpaConfigDataModel());
        JpaProject jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        IFile facetSettingsFile = this.getFile((TestPlatformProject)this.testProject, ".settings/org.eclipse.wst.common.project.facet.core.xml");
        BufferedInputStream inStream = new BufferedInputStream(facetSettingsFile.getContents());
        int fileSize = ((InputStream)inStream).available();
        byte[] buf = new byte[fileSize];
        ((InputStream)inStream).read(buf);
        ((InputStream)inStream).close();
        String oldDocument = new String(buf);
        String oldString = "<installed facet=\"java\" version=\"1.5\"/>" + CR + "  " + "<installed facet=\"jpt.jpa\" version=\"1.0\"/>";
        String newString = "<installed facet=\"java\" version=\"1.5\"/>";
        String newDocument = oldDocument.replaceAll(oldString, newString);
        facetSettingsFile.setContents((InputStream)new ByteArrayInputStream(newDocument.getBytes()), false, false, null);
        JpaProjectManagerTests.assertEquals((int)0, (int)JptJpaCorePlugin.getJpaProjectManager().getJpaProjectsSize());
        jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject());
        JpaProjectManagerTests.assertNull((Object)jpaProject);
        facetSettingsFile.setContents((InputStream)new ByteArrayInputStream(oldDocument.getBytes()), false, false, null);
        JpaProjectManagerTests.assertEquals((int)1, (int)JptJpaCorePlugin.getJpaProjectManager().getJpaProjectsSize());
        jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.testProject.getProject());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject);
        JpaProjectManagerTests.assertEquals((int)4, (int)jpaProject.getJpaFilesSize());
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/test/pkg/TestEntity.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/test/pkg/TestEntity2.java")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/META-INF/persistence.xml")));
        JpaProjectManagerTests.assertNotNull((Object)jpaProject.getJpaFile(this.getFile((TestPlatformProject)this.testProject, "src/META-INF/orm.xml")));
    }
}

