/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorValueAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class DiscriminatorValueTests
extends JpaJavaResourceModelTestCase {
    public DiscriminatorValueTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestDiscriminatorValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.DiscriminatorValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@DiscriminatorValue");
            }
        });
    }

    private ICompilationUnit createTestDiscriminatorValueWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.DiscriminatorValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@DiscriminatorValue(value = \"discriminator\")");
            }
        });
    }

    public void testDiscriminatorValue() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        DiscriminatorValueAnnotation discriminatorValue = (DiscriminatorValueAnnotation)resourceType.getAnnotation("javax.persistence.DiscriminatorValue");
        DiscriminatorValueTests.assertNotNull((Object)discriminatorValue);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorValueWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        DiscriminatorValueAnnotation discriminatorValue = (DiscriminatorValueAnnotation)resourceType.getAnnotation("javax.persistence.DiscriminatorValue");
        DiscriminatorValueTests.assertEquals((String)"discriminator", (String)discriminatorValue.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        DiscriminatorValueAnnotation discriminatorValue = (DiscriminatorValueAnnotation)resourceType.getAnnotation("javax.persistence.DiscriminatorValue");
        discriminatorValue.setValue("foo");
        this.assertSourceContains("@DiscriminatorValue(\"foo\")", cu);
        discriminatorValue.setValue(null);
        this.assertSourceDoesNotContain("@DiscriminatorValue(", cu);
    }
}

