/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourcePackageInfoCompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceTypeCompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.NullAnnotationEditFormatter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.CommandExecutor;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.core.internal.GenericJpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.core.internal.JpaAnnotationProvider;

public class JavaResourceModelTestCase
extends AnnotationTestCase {
    private JavaElementChangeListener javaElementChangeListener;
    protected JavaResourceCompilationUnit javaResourceCompilationUnit;

    public JavaResourceModelTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.javaElementChangeListener = new JavaElementChangeListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        this.javaElementChangeListener = null;
    }

    void javaElementChanged(ElementChangedEvent event) {
        if (this.javaResourceCompilationUnit == null) {
            return;
        }
        this.syncWithJavaDelta(event.getDelta());
    }

    protected void syncWithJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.syncWithJavaDeltaChildren(delta);
                break;
            }
            case 5: {
                this.javaCompilationUnitChanged(delta);
                break;
            }
        }
    }

    protected void syncWithJavaDeltaChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.syncWithJavaDelta(child);
            ++n2;
        }
    }

    protected void javaCompilationUnitChanged(IJavaElementDelta delta) {
        if (this.deltaIsRelevant(delta)) {
            this.javaResourceCompilationUnit.synchronizeWithJavaSource();
        }
    }

    protected boolean deltaIsRelevant(IJavaElementDelta delta) {
        if (BitTools.onlyFlagIsSet((int)delta.getFlags(), (int)65536)) {
            return false;
        }
        return delta.getKind() == 4;
    }

    protected ICompilationUnit createAnnotationAndMembers(String packageName, String annotationName, String annotationBody) throws Exception {
        return this.javaProject.createCompilationUnit(packageName, String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " { " + annotationBody + " }");
    }

    protected ICompilationUnit createEnumAndMembers(String packageName, String enumName, String enumBody) throws Exception {
        return this.javaProject.createCompilationUnit(packageName, String.valueOf(enumName) + ".java", "public enum " + enumName + " { " + enumBody + " }");
    }

    protected JavaResourcePackage buildJavaResourcePackage(ICompilationUnit cu) {
        SourcePackageInfoCompilationUnit pkgCu = new SourcePackageInfoCompilationUnit(cu, this.buildAnnotationProvider(), NullAnnotationEditFormatter.instance(), CommandExecutor.Default.instance());
        this.javaResourceCompilationUnit = pkgCu;
        return pkgCu.getPackage();
    }

    protected JavaResourceType buildJavaResourceType(ICompilationUnit cu) {
        this.javaResourceCompilationUnit = this.buildJavaResourceCompilationUnit(cu);
        this.javaResourceCompilationUnit.resolveTypes();
        return this.hackJavaResourceType();
    }

    protected JavaResourceType hackJavaResourceType() {
        return (JavaResourceType)ReflectionTools.getFieldValue((Object)this.javaResourceCompilationUnit, (String)"primaryType");
    }

    protected JavaResourceCompilationUnit buildJavaResourceCompilationUnit(ICompilationUnit cu) {
        if (this.javaResourceCompilationUnit != null) {
            throw new IllegalStateException();
        }
        return new SourceTypeCompilationUnit(cu, this.buildAnnotationProvider(), NullAnnotationEditFormatter.instance(), CommandExecutor.Default.instance());
    }

    protected AnnotationProvider buildAnnotationProvider() {
        return new JpaAnnotationProvider(new JpaAnnotationDefinitionProvider[]{this.annotationDefinitionProvider()});
    }

    protected JpaAnnotationDefinitionProvider annotationDefinitionProvider() {
        return GenericJpaAnnotationDefinitionProvider.instance();
    }

    private class JavaElementChangeListener
    implements IElementChangedListener {
        JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            JavaResourceModelTestCase.this.javaElementChanged(event);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

