/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class NamedQueriesTests
extends JpaJavaResourceModelTestCase {
    private static final String QUERY_NAME = "myQuery";
    private static final String QUERY_QUERY = "SELECT name FROM Employee";

    public NamedQueriesTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestNamedQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedQueries", "javax.persistence.NamedQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQueries(@NamedQuery)");
            }
        });
    }

    private ICompilationUnit createTestNamedQueryWithName() throws Exception {
        return this.createTestNamedQueryWithStringElement("name", QUERY_NAME);
    }

    private ICompilationUnit createTestNamedQueryWithQuery() throws Exception {
        return this.createTestNamedQueryWithStringElement("query", QUERY_QUERY);
    }

    private ICompilationUnit createTestNamedQueryWithStringElement(final String elementName, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedQueries", "javax.persistence.NamedQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQueries(@NamedQuery(" + elementName + " = \"" + value + "\"))");
            }
        });
    }

    private ICompilationUnit createTestNamedQueryWithQueryHints() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedQueries", "javax.persistence.NamedQuery", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQueries(@NamedQuery(hints = {@QueryHint(name = \"BAR\", value = \"FOO\"), @QueryHint}))");
            }
        });
    }

    private ICompilationUnit createTestNamedQuery() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedQuery", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQuery(name = \"foo\", query = \"bar\", hints = @QueryHint(name = \"BAR\", value = \"FOO\"))");
            }
        });
    }

    public void testNamedQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueries();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        NamedQueriesTests.assertNotNull((Object)namedQuery);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        NamedQueriesTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        NamedQueriesTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
        namedQuery.setName("foo");
        NamedQueriesTests.assertEquals((String)"foo", (String)namedQuery.getName());
        this.assertSourceContains("@NamedQuery(name = \"foo\")", cu);
        namedQuery.setName(null);
        NamedQueriesTests.assertNull((Object)namedQuery.getName());
        this.assertSourceDoesNotContain("@NamedQuery(", cu);
    }

    public void testGetQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        NamedQueriesTests.assertEquals((String)QUERY_QUERY, (String)namedQuery.getQuery());
    }

    public void testSetQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        NamedQueriesTests.assertEquals((String)QUERY_QUERY, (String)namedQuery.getQuery());
        namedQuery.setQuery("foo");
        NamedQueriesTests.assertEquals((String)"foo", (String)namedQuery.getQuery());
        this.assertSourceContains("@NamedQuery(query = \"foo\")", cu);
        namedQuery.setQuery(null);
        NamedQueriesTests.assertNull((Object)namedQuery.getQuery());
        this.assertSourceDoesNotContain("@NamedQuery(", cu);
    }

    public void testHints() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueries();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        NamedQueriesTests.assertEquals((int)0, (int)namedQuery.getHintsSize());
    }

    public void testHints2() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueries();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        namedQuery.addHint(0);
        namedQuery.addHint(1);
        NamedQueriesTests.assertEquals((int)2, (int)namedQuery.getHintsSize());
    }

    public void testHints3() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        NamedQueriesTests.assertEquals((int)2, (int)namedQuery.getHintsSize());
    }

    public void testAddHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueries();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        namedQuery.addHint(0).setName("FOO");
        namedQuery.addHint(1);
        namedQuery.addHint(0).setName("BAR");
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((String)"FOO", (String)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertNull((Object)namedQuery.hintAt(2).getName());
        this.assertSourceContains("@NamedQuery(hints = {@QueryHint(name = \"BAR\"),@QueryHint(name = \"FOO\"), @QueryHint})", cu);
    }

    public void testRemoveHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        namedQuery.addHint(0).setName("BAZ");
        NamedQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedQueriesTests.assertEquals((int)3, (int)namedQuery.getHintsSize());
        namedQuery.removeHint(2);
        NamedQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertEquals((int)2, (int)namedQuery.getHintsSize());
        this.assertSourceContains("@NamedQueries(@NamedQuery(hints = {@QueryHint(name = \"BAZ\"), @QueryHint(name = \"BAR\", value = \"FOO\")}))", cu);
        namedQuery.removeHint(0);
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((int)1, (int)namedQuery.getHintsSize());
        this.assertSourceContains("@NamedQueries(@NamedQuery(hints = @QueryHint(name = \"BAR\", value = \"FOO\")))", cu);
        namedQuery.removeHint(0);
        NamedQueriesTests.assertEquals((int)0, (int)namedQuery.getHintsSize());
        this.assertSourceDoesNotContain("@NamedQuery(", cu);
    }

    public void testMoveHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        namedQuery.addHint(0).setName("BAZ");
        NamedQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedQueriesTests.assertEquals((int)3, (int)namedQuery.getHintsSize());
        namedQuery.moveHint(2, 0);
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertNull((Object)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(2).getName());
        NamedQueriesTests.assertEquals((int)3, (int)namedQuery.getHintsSize());
        this.assertSourceContains("@NamedQueries(@NamedQuery(hints = {@QueryHint(name = \"BAR\", value = \"FOO\"), @QueryHint, @QueryHint(name = \"BAZ\")}))", cu);
    }

    public void testMoveHint2() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        namedQuery.addHint(0).setName("BAZ");
        NamedQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedQueriesTests.assertEquals((int)3, (int)namedQuery.getHintsSize());
        namedQuery.moveHint(0, 2);
        NamedQueriesTests.assertNull((Object)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(2).getName());
        NamedQueriesTests.assertEquals((int)3, (int)namedQuery.getHintsSize());
        this.assertSourceContains("@NamedQueries(@NamedQuery(hints = {@QueryHint, @QueryHint(name = \"BAZ\"), @QueryHint(name = \"BAR\", value = \"FOO\")}))", cu);
    }

    public void testAddNamedQueryCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestNamedQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@NamedQueries({";
        String expected2 = "@NamedQuery(name = \"foo\", query = \"bar\", hints = @QueryHint(name = \"BAR\", value = \"FOO\")),";
        String expected3 = "@NamedQuery(name = \"BAR\") })";
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.addAnnotation(1, "javax.persistence.NamedQuery");
        namedQuery.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        NamedQueriesTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.NamedQuery"));
        NamedQueriesTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.NamedQueries"));
        NamedQueriesTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.NamedQuery"));
        NamedQueriesTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize("javax.persistence.NamedQuery"));
    }

    public void testAddNamedQueryToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestNamedQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@NamedQueries({";
        String expected2 = "@NamedQuery(name = \"foo\", query = \"bar\", hints = @QueryHint(name = \"BAR\", value = \"FOO\")),";
        String expected3 = "@NamedQuery(name = \"BAR\") })";
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.addAnnotation(1, "javax.persistence.NamedQuery");
        namedQuery.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected2 = "@NamedQuery(name = \"BAZ\"),";
        expected3 = "@NamedQuery(name = \"foo\", query = \"bar\", hints = @QueryHint(name = \"BAR\", value = \"FOO\")), @NamedQuery(name = \"BAR\") })";
        namedQuery = (NamedQueryAnnotation)resourceType.addAnnotation(0, "javax.persistence.NamedQuery");
        namedQuery.setName("BAZ");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        ListIterator namedQueries = resourceType.getAnnotations("javax.persistence.NamedQuery").iterator();
        NamedQueriesTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)namedQueries.next()).getName());
        NamedQueriesTests.assertEquals((String)"foo", (String)((NamedQueryAnnotation)namedQueries.next()).getName());
        NamedQueriesTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)namedQueries.next()).getName());
        NamedQueriesTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.NamedQuery"));
        NamedQueriesTests.assertNotNull((Object)resourceType.getAnnotation("javax.persistence.NamedQueries"));
        NamedQueriesTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.NamedQuery"));
        NamedQueriesTests.assertEquals((int)3, (int)resourceType.getAnnotationsSize("javax.persistence.NamedQuery"));
    }

    public void testRemoveNamedQueryCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestNamedQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@NamedQueries({";
        String expected2 = "@NamedQuery(name = \"foo\", query = \"bar\", hints = @QueryHint(name = \"BAR\", value = \"FOO\")),";
        String expected3 = "@NamedQuery(name = \"BAR\") })";
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.addAnnotation(1, "javax.persistence.NamedQuery");
        namedQuery.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected1 = "@NamedQuery(name = \"foo\", query = \"bar\", hints = @QueryHint(name = \"BAR\", value = \"FOO\"))";
        resourceType.removeAnnotation(1, "javax.persistence.NamedQuery");
        this.assertSourceContains(expected1, cu);
        this.assertSourceDoesNotContain("@NamedNativeQueries", cu);
    }
}

