/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class PrimaryKeyJoinColumnsTests
extends JpaJavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";
    private static final String COLUMN_REFERENCED_COLUMN_NAME = "MY_REF_COLUMN_NAME";

    public PrimaryKeyJoinColumnsTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn)");
            }
        });
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumnWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn(name = \"MY_COLUMN\"))");
            }
        });
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumnWithReferencedColumnName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn(referencedColumnName = \"MY_REF_COLUMN_NAME\"))");
            }
        });
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumnWithColumnDefinition() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn(columnDefinition = \"COLUMN_DEFINITION\"))");
            }
        });
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", referencedColumnName = \"REF_NAME\")");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnsTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getName());
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getReferencedColumnName());
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getName());
        column.setName("Foo");
        PrimaryKeyJoinColumnsTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn(name = \"Foo\"))", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnsTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("@PrimaryKeyJoinColumn(", cu);
    }

    public void testGetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumnWithReferencedColumnName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnsTests.assertEquals((String)COLUMN_REFERENCED_COLUMN_NAME, (String)column.getReferencedColumnName());
    }

    public void testSetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getReferencedColumnName());
        column.setReferencedColumnName("Foo");
        PrimaryKeyJoinColumnsTests.assertEquals((String)"Foo", (String)column.getReferencedColumnName());
        this.assertSourceContains("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn(referencedColumnName = \"Foo\"))", cu);
        column.setReferencedColumnName(null);
        this.assertSourceDoesNotContain("@PrimaryKeyJoinColumn(", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumnWithColumnDefinition();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnsTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnsTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        PrimaryKeyJoinColumnsTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@PrimaryKeyJoinColumns(@PrimaryKeyJoinColumn(columnDefinition = \"Foo\"))", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("@PrimaryKeyJoinColumn(", cu);
    }

    public void testAddPrimaryKeyJoinColumnCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        String expected1 = "@PrimaryKeyJoinColumns({";
        String expected2 = "@PrimaryKeyJoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", referencedColumnName = \"REF_NAME\"),";
        String expected3 = "@PrimaryKeyJoinColumn(name = \"FOO\") })";
        PrimaryKeyJoinColumnAnnotation joinColumn = (PrimaryKeyJoinColumnAnnotation)resourceField.addAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn");
        joinColumn.setName("FOO");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        PrimaryKeyJoinColumnsTests.assertEquals((int)2, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
    }

    public void testAddPrimaryKeyJoinColumnToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        String expected1 = "@PrimaryKeyJoinColumns({";
        String expected2 = "@PrimaryKeyJoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", referencedColumnName = \"REF_NAME\"),";
        String expected3 = "@PrimaryKeyJoinColumn(name = \"FOO\") })";
        PrimaryKeyJoinColumnAnnotation joinColumn = (PrimaryKeyJoinColumnAnnotation)resourceField.addAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn");
        joinColumn.setName("FOO");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected2 = "@PrimaryKeyJoinColumn(name = \"BAZ\"),";
        expected3 = "@PrimaryKeyJoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", referencedColumnName = \"REF_NAME\"), @PrimaryKeyJoinColumn(name = \"FOO\") })";
        joinColumn = (PrimaryKeyJoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        joinColumn.setName("BAZ");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        ListIterator pkJoinColumns = resourceField.getAnnotations("javax.persistence.PrimaryKeyJoinColumn").iterator();
        PrimaryKeyJoinColumnsTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        PrimaryKeyJoinColumnsTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        PrimaryKeyJoinColumnsTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        PrimaryKeyJoinColumnsTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        PrimaryKeyJoinColumnsTests.assertEquals((int)3, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
    }

    public void testRemovePrimaryKeyJoinColumnCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        String expected1 = "@PrimaryKeyJoinColumns({";
        String expected2 = "@PrimaryKeyJoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", referencedColumnName = \"REF_NAME\"),";
        String expected3 = "@PrimaryKeyJoinColumn(name = \"FOO\") })";
        PrimaryKeyJoinColumnAnnotation joinColumn = (PrimaryKeyJoinColumnAnnotation)resourceField.addAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn");
        joinColumn.setName("FOO");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected1 = "@PrimaryKeyJoinColumn(name = \"BAR\", columnDefinition = \"COLUMN_DEF\", referencedColumnName = \"REF_NAME\")";
        resourceField.removeAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn");
        this.assertSourceContains(expected1, cu);
        this.assertSourceDoesNotContain("@PrimaryKeyJoinColumns", cu);
    }
}

