/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.beans.Introspector;
import java.util.Iterator;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jaxb.core.context.JaxbEnum;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumConstant;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumMapping;
import org.eclipse.jpt.jaxb.core.resource.java.XmlEnumAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRootElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaEnumMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaEnumMappingTests(String name) {
        super(name);
    }

    protected void addXmlTypeMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlTypeAnnotation(declaration), name, value);
    }

    protected void addXmlTypeTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlTypeAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected void addXmlEnumTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlEnumAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected Annotation getXmlTypeAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlType");
    }

    protected Annotation getXmlEnumAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlEnum");
    }

    public void testModifySchemaTypeName() throws Exception {
        this.createEnumWithXmlType();
        JaxbEnum jaxbEnum = (JaxbEnum)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbEnumMapping enumMapping = jaxbEnum.getMapping();
        JavaResourceEnum resourceEnum = jaxbEnum.getJavaResourceType();
        String defaultXmlTypeName = Introspector.decapitalize("AnnotationTestType");
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getQName().getSpecifiedName());
        GenericJavaEnumMappingTests.assertEquals((String)defaultXmlTypeName, (String)enumMapping.getQName().getDefaultName());
        GenericJavaEnumMappingTests.assertEquals((String)defaultXmlTypeName, (String)enumMapping.getQName().getName());
        enumMapping.getQName().setSpecifiedName("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getName());
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getQName().getSpecifiedName());
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getQName().getName());
        enumMapping.getQName().setSpecifiedName(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaEnumMappingTests.assertNull((Object)xmlTypeAnnotation.getName());
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getQName().getSpecifiedName());
        GenericJavaEnumMappingTests.assertEquals((String)defaultXmlTypeName, (String)enumMapping.getQName().getName());
        resourceEnum.removeAnnotation("javax.xml.bind.annotation.XmlType");
        enumMapping.getQName().setSpecifiedName("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getName());
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getQName().getSpecifiedName());
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getQName().getName());
    }

    public void testUpdateSchemaTypeName() throws Exception {
        this.createEnumWithXmlType();
        JaxbEnum jaxbEnum = (JaxbEnum)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbEnumMapping enumMapping = jaxbEnum.getMapping();
        JavaResourceEnum resourceEnum = jaxbEnum.getJavaResourceType();
        String defaultXmlTypeName = Introspector.decapitalize("AnnotationTestType");
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getQName().getSpecifiedName());
        GenericJavaEnumMappingTests.assertEquals((String)defaultXmlTypeName, (String)enumMapping.getQName().getDefaultName());
        GenericJavaEnumMappingTests.assertEquals((String)defaultXmlTypeName, (String)enumMapping.getQName().getName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaEnumMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
                GenericJavaEnumMappingTests.this.addXmlTypeMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getQName().getSpecifiedName());
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaEnumMappingTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaEnumMappingTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getQName().getSpecifiedName());
        GenericJavaEnumMappingTests.assertEquals((String)defaultXmlTypeName, (String)enumMapping.getQName().getName());
    }

    public void testModifyNamespace() throws Exception {
        this.createEnumWithXmlType();
        JaxbEnum jaxbEnum = (JaxbEnum)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbEnumMapping enumMapping = jaxbEnum.getMapping();
        JavaResourceEnum resourceEnum = jaxbEnum.getJavaResourceType();
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getQName().getSpecifiedNamespace());
        GenericJavaEnumMappingTests.assertEquals((String)"", (String)enumMapping.getQName().getDefaultNamespace());
        GenericJavaEnumMappingTests.assertEquals((String)"", (String)enumMapping.getQName().getNamespace());
        enumMapping.getQName().setSpecifiedNamespace("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getNamespace());
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getQName().getSpecifiedNamespace());
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getQName().getNamespace());
        enumMapping.getQName().setSpecifiedNamespace(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaEnumMappingTests.assertNull((Object)xmlTypeAnnotation.getNamespace());
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getQName().getSpecifiedNamespace());
        GenericJavaEnumMappingTests.assertEquals((String)"", (String)enumMapping.getQName().getNamespace());
        resourceEnum.removeAnnotation("javax.xml.bind.annotation.XmlType");
        enumMapping.getQName().setSpecifiedNamespace("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getNamespace());
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getQName().getSpecifiedNamespace());
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getQName().getNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createEnumWithXmlType();
        JaxbEnum jaxbEnum = (JaxbEnum)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbEnumMapping enumMapping = jaxbEnum.getMapping();
        JavaResourceEnum resourceEnum = jaxbEnum.getJavaResourceType();
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getQName().getSpecifiedNamespace());
        GenericJavaEnumMappingTests.assertEquals((String)"", (String)enumMapping.getQName().getDefaultNamespace());
        GenericJavaEnumMappingTests.assertEquals((String)"", (String)enumMapping.getQName().getNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaEnumMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
                GenericJavaEnumMappingTests.this.addXmlTypeMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getQName().getSpecifiedNamespace());
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getQName().getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaEnumMappingTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaEnumMappingTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getQName().getSpecifiedNamespace());
        GenericJavaEnumMappingTests.assertEquals((String)"", (String)enumMapping.getQName().getNamespace());
    }

    public void testModifyXmlRootElement() throws Exception {
        this.createEnumWithXmlType();
        JaxbEnum jaxbEnum = (JaxbEnum)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbEnumMapping enumMapping = jaxbEnum.getMapping();
        JavaResourceEnum resourceEnum = jaxbEnum.getJavaResourceType();
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getXmlRootElement());
        enumMapping.addXmlRootElement().getQName().setSpecifiedName("foo");
        XmlRootElementAnnotation xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)xmlRootElementAnnotation.getName());
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getXmlRootElement().getQName().getName());
        enumMapping.removeXmlRootElement();
        xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaEnumMappingTests.assertNull((Object)xmlRootElementAnnotation);
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getXmlRootElement());
    }

    public void testUpdateXmlRootElement() throws Exception {
        this.createEnumWithXmlType();
        JaxbEnum jaxbEnum = (JaxbEnum)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbEnumMapping enumMapping = jaxbEnum.getMapping();
        JavaResourceEnum resourceEnum = jaxbEnum.getJavaResourceType();
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getXmlRootElement());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation annotation = GenericJavaEnumMappingTests.this.addNormalAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlRootElement");
                GenericJavaEnumMappingTests.this.addMemberValuePair(annotation, "name", "foo");
            }
        });
        GenericJavaEnumMappingTests.assertEquals((String)"foo", (String)enumMapping.getXmlRootElement().getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaEnumMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlRootElement");
            }
        });
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getXmlRootElement());
    }

    public void testModifyXmlEnumValue() throws Exception {
        this.createEnumWithXmlType();
        JaxbEnum jaxbEnum = (JaxbEnum)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbEnumMapping enumMapping = jaxbEnum.getMapping();
        JavaResourceEnum resourceEnum = jaxbEnum.getJavaResourceType();
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getSpecifiedXmlEnumValue());
        GenericJavaEnumMappingTests.assertEquals((String)"java.lang.String", (String)enumMapping.getXmlEnumValue());
        enumMapping.setSpecifiedXmlEnumValue("Integer");
        XmlEnumAnnotation xmlEnumAnnotation = (XmlEnumAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlEnum");
        GenericJavaEnumMappingTests.assertEquals((String)"Integer", (String)xmlEnumAnnotation.getValue());
        GenericJavaEnumMappingTests.assertEquals((String)"Integer", (String)enumMapping.getSpecifiedXmlEnumValue());
        GenericJavaEnumMappingTests.assertEquals((String)"Integer", (String)enumMapping.getXmlEnumValue());
        enumMapping.setSpecifiedXmlEnumValue(null);
        xmlEnumAnnotation = (XmlEnumAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlEnum");
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getSpecifiedXmlEnumValue());
        GenericJavaEnumMappingTests.assertEquals((String)"java.lang.String", (String)enumMapping.getXmlEnumValue());
        resourceEnum.addAnnotation("javax.xml.bind.annotation.XmlType");
        resourceEnum.removeAnnotation("javax.xml.bind.annotation.XmlEnum");
        enumMapping = ((JaxbEnum)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0)).getMapping();
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getSpecifiedXmlEnumValue());
        GenericJavaEnumMappingTests.assertEquals((String)"java.lang.String", (String)enumMapping.getXmlEnumValue());
    }

    public void testUpdateXmlEnumValue() throws Exception {
        this.createEnumWithXmlType();
        JaxbEnum jaxbEnum = (JaxbEnum)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbEnumMapping enumMapping = jaxbEnum.getMapping();
        JavaResourceEnum resourceEnum = jaxbEnum.getJavaResourceType();
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getSpecifiedXmlEnumValue());
        GenericJavaEnumMappingTests.assertEquals((String)"java.lang.String", (String)enumMapping.getXmlEnumValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaEnumMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlEnum");
                GenericJavaEnumMappingTests.this.addXmlEnumTypeMemberValuePair(declaration, "value", "String");
            }
        });
        GenericJavaEnumMappingTests.assertEquals((String)"String", (String)enumMapping.getSpecifiedXmlEnumValue());
        GenericJavaEnumMappingTests.assertEquals((String)"String", (String)enumMapping.getXmlEnumValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlEnumAnnotation = (NormalAnnotation)GenericJavaEnumMappingTests.this.getXmlEnumAnnotation(declaration);
                GenericJavaEnumMappingTests.this.values(xmlEnumAnnotation).remove(0);
            }
        });
        GenericJavaEnumMappingTests.assertNull((Object)enumMapping.getSpecifiedXmlEnumValue());
        GenericJavaEnumMappingTests.assertEquals((String)"java.lang.String", (String)enumMapping.getXmlEnumValue());
    }

    public void testUpdateEnumConstants() throws Exception {
        this.createEnumWithXmlType();
        JaxbEnum jaxbEnum = (JaxbEnum)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbEnumMapping enumMapping = jaxbEnum.getMapping();
        JavaResourceEnum resourceEnum = jaxbEnum.getJavaResourceType();
        GenericJavaEnumMappingTests.assertEquals((int)2, (int)enumMapping.getEnumConstantsSize());
        Iterator enumConstants = enumMapping.getEnumConstants().iterator();
        JaxbEnumConstant enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaEnumMappingTests.assertEquals((String)"SUNDAY", (String)enumConstant.getName());
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaEnumMappingTests.assertEquals((String)"MONDAY", (String)enumConstant.getName());
        GenericJavaEnumMappingTests.assertFalse((boolean)enumConstants.hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaEnumMappingTests.this.addEnumConstant((EnumDeclaration)declaration.getDeclaration(), "TUESDAY");
                GenericJavaEnumMappingTests.this.addEnumConstant((EnumDeclaration)declaration.getDeclaration(), "WEDNESDAY");
            }
        });
        GenericJavaEnumMappingTests.assertEquals((int)4, (int)enumMapping.getEnumConstantsSize());
        enumConstants = enumMapping.getEnumConstants().iterator();
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaEnumMappingTests.assertEquals((String)"SUNDAY", (String)enumConstant.getName());
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaEnumMappingTests.assertEquals((String)"MONDAY", (String)enumConstant.getName());
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaEnumMappingTests.assertEquals((String)"TUESDAY", (String)enumConstant.getName());
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaEnumMappingTests.assertEquals((String)"WEDNESDAY", (String)enumConstant.getName());
        GenericJavaEnumMappingTests.assertFalse((boolean)enumConstants.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaEnumMappingTests.this.removeEnumConstant((EnumDeclaration)declaration.getDeclaration(), "SUNDAY");
            }
        });
        GenericJavaEnumMappingTests.assertEquals((int)3, (int)enumMapping.getEnumConstantsSize());
        enumConstants = enumMapping.getEnumConstants().iterator();
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaEnumMappingTests.assertEquals((String)"MONDAY", (String)enumConstant.getName());
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaEnumMappingTests.assertEquals((String)"TUESDAY", (String)enumConstant.getName());
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaEnumMappingTests.assertEquals((String)"WEDNESDAY", (String)enumConstant.getName());
        GenericJavaEnumMappingTests.assertFalse((boolean)enumConstants.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaEnumMappingTests.this.removeEnumConstant((EnumDeclaration)declaration.getDeclaration(), "TUESDAY");
                GenericJavaEnumMappingTests.this.removeEnumConstant((EnumDeclaration)declaration.getDeclaration(), "MONDAY");
            }
        });
        GenericJavaEnumMappingTests.assertEquals((int)1, (int)enumMapping.getEnumConstantsSize());
        enumConstants = enumMapping.getEnumConstants().iterator();
        enumConstant = (JaxbEnumConstant)enumConstants.next();
        GenericJavaEnumMappingTests.assertEquals((String)"WEDNESDAY", (String)enumConstant.getName());
        GenericJavaEnumMappingTests.assertFalse((boolean)enumConstants.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaEnumMappingTests.this.removeEnumConstant((EnumDeclaration)declaration.getDeclaration(), "WEDNESDAY");
            }
        });
        GenericJavaEnumMappingTests.assertEquals((int)0, (int)enumMapping.getEnumConstantsSize());
        GenericJavaEnumMappingTests.assertFalse((boolean)enumMapping.getEnumConstants().iterator().hasNext());
    }
}

