/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElementMapping;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAttachmentRefAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAttributeAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDREFAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlListAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlAttributeMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlAttributeMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlAttribute() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlAttribute"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAttribute");
            }
        });
    }

    public void testModifyName() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedName());
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"id", (String)xmlAttributeMapping.getQName().getDefaultName());
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"id", (String)xmlAttributeMapping.getQName().getName());
        xmlAttributeMapping.getQName().setSpecifiedName("foo");
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeAnnotation.getName());
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeMapping.getQName().getSpecifiedName());
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"id", (String)xmlAttributeMapping.getQName().getDefaultName());
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeMapping.getQName().getName());
        xmlAttributeMapping.getQName().setSpecifiedName(null);
        xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeAnnotation.getName());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedName());
    }

    public void testUpdateName() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addXmlAttributeMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeMapping.getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlAttributeAnnotation = (NormalAnnotation)GenericJavaXmlAttributeMappingTests.this.getXmlAttributeAnnotation(declaration);
                GenericJavaXmlAttributeMappingTests.this.values(xmlAttributeAnnotation).remove(0);
            }
        });
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedName());
    }

    public void testModifyNamespace() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedNamespace());
        xmlAttributeMapping.getQName().setSpecifiedNamespace("foo");
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeAnnotation.getNamespace());
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeMapping.getQName().getNamespace());
        xmlAttributeMapping.getQName().setSpecifiedNamespace(null);
        xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeAnnotation.getNamespace());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addXmlAttributeMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeMapping.getQName().getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlAttributeAnnotation = (NormalAnnotation)GenericJavaXmlAttributeMappingTests.this.getXmlAttributeAnnotation(declaration);
                GenericJavaXmlAttributeMappingTests.this.values(xmlAttributeAnnotation).remove(0);
            }
        });
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedNamespace());
    }

    public void testModifyRequired() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getSpecifiedRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isDefaultRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isRequired());
        xmlAttributeMapping.setSpecifiedRequired(Boolean.TRUE);
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        GenericJavaXmlAttributeMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlAttributeAnnotation.getRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlAttributeMapping.getSpecifiedRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isDefaultRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)true, (boolean)xmlAttributeMapping.isRequired());
        xmlAttributeMapping.setSpecifiedRequired(null);
        xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeAnnotation.getName());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getSpecifiedRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isDefaultRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isRequired());
    }

    public void testUpdateRequired() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getSpecifiedRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isDefaultRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isRequired());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addXmlAttributeMemberValuePair(declaration, "required", true);
            }
        });
        GenericJavaXmlAttributeMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlAttributeMapping.getSpecifiedRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isDefaultRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)true, (boolean)xmlAttributeMapping.isRequired());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlAttributeAnnotation = (NormalAnnotation)GenericJavaXmlAttributeMappingTests.this.getXmlAttributeAnnotation(declaration);
                GenericJavaXmlAttributeMappingTests.this.values(xmlAttributeAnnotation).remove(0);
            }
        });
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getSpecifiedRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isDefaultRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isRequired());
    }

    public void testChangeMappingType() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping);
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-element");
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlElementMapping);
        GenericJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        persistentAttribute.setMappingKey("xml-attribute");
        xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping);
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        GenericJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
    }

    public void testModifyXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
        xmlAttributeMapping.addXmlJavaTypeAdapter();
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlJavaTypeAdapterAnnotation);
        xmlAttributeMapping.removeXmlJavaTypeAdapter();
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    }

    public void testUpdateXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlJavaTypeAdapterAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
    }

    public void testModifyXmlSchemaType() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlSchemaTypeAnnotation xmlSchemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlSchemaType());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlSchemaTypeAnnotation);
        xmlAttributeMapping.addXmlSchemaType();
        xmlSchemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlSchemaType());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlSchemaTypeAnnotation);
        xmlAttributeMapping.removeXmlSchemaType();
        xmlSchemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
    }

    public void testUpdateXmlSchemaType() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlSchemaTypeAnnotation xmlSchemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlSchemaType());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlSchemaTypeAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlSchemaType");
            }
        });
        xmlSchemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlSchemaType());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlSchemaTypeAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSchemaType");
            }
        });
        xmlSchemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlSchemaType());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlSchemaTypeAnnotation);
    }

    protected void addXmlAttributeMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlAttributeAnnotation(declaration), name, value);
    }

    protected void addXmlAttributeMemberValuePair(ModifiedDeclaration declaration, String name, boolean value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlAttributeAnnotation(declaration), name, value);
    }

    protected void addXmlAttributeTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlAttributeAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected Annotation getXmlAttributeAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlAttribute");
    }

    public void testModifyXmlList() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlListAnnotation xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlList());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlListAnnotation);
        xmlAttributeMapping.addXmlList();
        xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlList());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlListAnnotation);
        xmlAttributeMapping.removeXmlList();
        xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
    }

    public void testUpdateXmlList() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlListAnnotation xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlList());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlListAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlList");
            }
        });
        xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlList());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlListAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlList");
            }
        });
        xmlListAnnotation = (XmlListAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlList());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlListAnnotation);
    }

    public void testModifyXmlID() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDAnnotation xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlID());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlIDAnnotation);
        xmlAttributeMapping.addXmlID();
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlID());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlIDAnnotation);
        xmlAttributeMapping.removeXmlID();
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
    }

    public void testUpdateXmlID() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDAnnotation xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlID());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlIDAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlID");
            }
        });
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlID());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlIDAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlID");
            }
        });
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlID());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlIDAnnotation);
    }

    public void testModifyXmlIDREF() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDREFAnnotation xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlIDREF());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlIDREFAnnotation);
        xmlAttributeMapping.addXmlIDREF();
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlIDREF());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlIDREFAnnotation);
        xmlAttributeMapping.removeXmlIDREF();
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
    }

    public void testUpdateXmlIDREF() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDREFAnnotation xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlIDREF());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlIDREFAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlIDREF");
            }
        });
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlIDREF());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlIDREFAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlIDREF");
            }
        });
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlIDREF());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlIDREFAnnotation);
    }

    public void testModifyXmlAttachmentRef() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlAttachmentRefAnnotation xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlAttachmentRef());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttachmentRefAnnotation);
        xmlAttributeMapping.addXmlAttachmentRef();
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlAttachmentRef());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttachmentRefAnnotation);
        xmlAttributeMapping.removeXmlAttachmentRef();
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
    }

    public void testUpdateXmlAttachmentRef() throws Exception {
        this.createTypeWithXmlAttribute();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlAttachmentRefAnnotation xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlAttachmentRef());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttachmentRefAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttachmentRef");
            }
        });
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlAttachmentRef());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttachmentRefAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttachmentRef");
            }
        });
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlAttachmentRef());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttachmentRefAnnotation);
    }
}

