/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElementRef;
import org.eclipse.jpt.jaxb.core.context.XmlElementRefsMapping;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefsAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlMixedAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlElementRefsMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlElementRefsMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlElementRefs() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlElementRefs"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementRefs");
            }
        });
    }

    protected Annotation getXmlElementRefsAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElementRefs");
    }

    protected void addXmlElementRefsMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementRefsAnnotation(declaration), name, value);
    }

    protected void addXmlElementRefsMemberValuePair(ModifiedDeclaration declaration, String name, boolean value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementRefsAnnotation(declaration), name, value);
    }

    protected void addXmlElementRefsTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementRefsAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected NormalAnnotation newXmlElementRefAnnotation(AST ast, String name) {
        NormalAnnotation annotation = this.newNormalAnnotation(ast, "javax.xml.bind.annotation.XmlElementRef");
        this.addMemberValuePair(annotation, "name", name);
        return annotation;
    }

    protected void addXmlElementRef(ModifiedDeclaration declaration, int index, String name) {
        NormalAnnotation arrayElement = this.newXmlElementRefAnnotation(declaration.getAst(), name);
        this.addArrayElement(declaration, "javax.xml.bind.annotation.XmlElementRefs", index, "value", (Expression)arrayElement);
    }

    protected void moveXmlElementRef(ModifiedDeclaration declaration, int targetIndex, int sourceIndex) {
        this.moveArrayElement((NormalAnnotation)declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElementRefs"), "value", targetIndex, sourceIndex);
    }

    protected void removeXmlElementRef(ModifiedDeclaration declaration, int index) {
        this.removeArrayElement((NormalAnnotation)declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElementRefs"), "value", index);
    }

    public void testSyncXmlElementRefs() throws Exception {
        this.createTypeWithXmlElementRefs();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlElementRefsMapping mapping = (XmlElementRefsMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ListIterable xmlElementRefs = mapping.getXmlElementRefs().getXmlElementRefs();
        GenericJavaXmlElementRefsMappingTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)xmlElementRefs));
        GenericJavaXmlElementRefsMappingTests.assertEquals((int)0, (int)mapping.getXmlElementRefs().getXmlElementRefsSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefsMappingTests.this.addXmlElementRef(declaration, 0, "foo");
                GenericJavaXmlElementRefsMappingTests.this.addXmlElementRef(declaration, 1, "bar");
            }
        });
        xmlElementRefs = mapping.getXmlElementRefs().getXmlElementRefs();
        GenericJavaXmlElementRefsMappingTests.assertFalse((boolean)CollectionTools.isEmpty((Iterable)mapping.getXmlElementRefs().getXmlElementRefs()));
        GenericJavaXmlElementRefsMappingTests.assertEquals((int)2, (int)mapping.getXmlElementRefs().getXmlElementRefsSize());
        GenericJavaXmlElementRefsMappingTests.assertEquals((String)"foo", (String)((XmlElementRef)CollectionTools.get((Iterable)xmlElementRefs, (int)0)).getQName().getName());
        GenericJavaXmlElementRefsMappingTests.assertEquals((String)"bar", (String)((XmlElementRef)CollectionTools.get((Iterable)xmlElementRefs, (int)1)).getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefsMappingTests.this.moveXmlElementRef(declaration, 0, 1);
            }
        });
        xmlElementRefs = mapping.getXmlElementRefs().getXmlElementRefs();
        GenericJavaXmlElementRefsMappingTests.assertFalse((boolean)CollectionTools.isEmpty((Iterable)mapping.getXmlElementRefs().getXmlElementRefs()));
        GenericJavaXmlElementRefsMappingTests.assertEquals((int)2, (int)mapping.getXmlElementRefs().getXmlElementRefsSize());
        GenericJavaXmlElementRefsMappingTests.assertEquals((String)"bar", (String)((XmlElementRef)CollectionTools.get((Iterable)xmlElementRefs, (int)0)).getQName().getName());
        GenericJavaXmlElementRefsMappingTests.assertEquals((String)"foo", (String)((XmlElementRef)CollectionTools.get((Iterable)xmlElementRefs, (int)1)).getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefsMappingTests.this.removeXmlElementRef(declaration, 1);
                GenericJavaXmlElementRefsMappingTests.this.removeXmlElementRef(declaration, 0);
            }
        });
        xmlElementRefs = mapping.getXmlElementRefs().getXmlElementRefs();
        GenericJavaXmlElementRefsMappingTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)xmlElementRefs));
        GenericJavaXmlElementRefsMappingTests.assertEquals((int)0, (int)mapping.getXmlElementRefs().getXmlElementRefsSize());
    }

    public void testModifyXmlElementRefs() throws Exception {
        this.createTypeWithXmlElementRefs();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlElementRefsMapping mapping = (XmlElementRefsMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlElementRefsAnnotation annotation = (XmlElementRefsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs");
        ListIterable annotations = annotation.getXmlElementRefs();
        GenericJavaXmlElementRefsMappingTests.assertEquals((int)0, (int)annotation.getXmlElementRefsSize());
        GenericJavaXmlElementRefsMappingTests.assertEquals((int)0, (int)mapping.getXmlElementRefs().getXmlElementRefsSize());
        mapping.getXmlElementRefs().addXmlElementRef(0).getQName().setSpecifiedName("foo");
        mapping.getXmlElementRefs().addXmlElementRef(1).getQName().setSpecifiedName("baz");
        mapping.getXmlElementRefs().addXmlElementRef(1).getQName().setSpecifiedName("bar");
        annotations = annotation.getXmlElementRefs();
        GenericJavaXmlElementRefsMappingTests.assertEquals((int)3, (int)annotation.getXmlElementRefsSize());
        GenericJavaXmlElementRefsMappingTests.assertEquals((int)3, (int)mapping.getXmlElementRefs().getXmlElementRefsSize());
        GenericJavaXmlElementRefsMappingTests.assertEquals((String)"foo", (String)((XmlElementRefAnnotation)CollectionTools.get((Iterable)annotations, (int)0)).getName());
        GenericJavaXmlElementRefsMappingTests.assertEquals((String)"bar", (String)((XmlElementRefAnnotation)CollectionTools.get((Iterable)annotations, (int)1)).getName());
        GenericJavaXmlElementRefsMappingTests.assertEquals((String)"baz", (String)((XmlElementRefAnnotation)CollectionTools.get((Iterable)annotations, (int)2)).getName());
        mapping.getXmlElementRefs().moveXmlElementRef(1, 2);
        annotations = annotation.getXmlElementRefs();
        GenericJavaXmlElementRefsMappingTests.assertEquals((int)3, (int)annotation.getXmlElementRefsSize());
        GenericJavaXmlElementRefsMappingTests.assertEquals((int)3, (int)mapping.getXmlElementRefs().getXmlElementRefsSize());
        GenericJavaXmlElementRefsMappingTests.assertEquals((String)"foo", (String)((XmlElementRefAnnotation)CollectionTools.get((Iterable)annotations, (int)0)).getName());
        GenericJavaXmlElementRefsMappingTests.assertEquals((String)"baz", (String)((XmlElementRefAnnotation)CollectionTools.get((Iterable)annotations, (int)1)).getName());
        GenericJavaXmlElementRefsMappingTests.assertEquals((String)"bar", (String)((XmlElementRefAnnotation)CollectionTools.get((Iterable)annotations, (int)2)).getName());
        mapping.getXmlElementRefs().removeXmlElementRef(2);
        mapping.getXmlElementRefs().removeXmlElementRef(0);
        mapping.getXmlElementRefs().removeXmlElementRef(0);
        GenericJavaXmlElementRefsMappingTests.assertEquals((int)0, (int)annotation.getXmlElementRefsSize());
        GenericJavaXmlElementRefsMappingTests.assertEquals((int)0, (int)mapping.getXmlElementRefs().getXmlElementRefsSize());
    }

    public void testChangeMappingType() throws Exception {
        this.createTypeWithXmlElementRefs();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefsMapping mapping = (XmlElementRefsMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)mapping);
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs"));
        persistentAttribute.setMappingKey("xml-attribute");
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)xmlAttributeMapping);
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs"));
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-element-refs");
        mapping = (XmlElementRefsMapping)persistentAttribute.getMapping();
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)mapping);
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs"));
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
    }

    public void testModifyXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlElementRefs();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefsMapping mapping = (XmlElementRefsMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
        mapping.addXmlJavaTypeAdapter();
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)xmlJavaTypeAdapterAnnotation);
        mapping.removeXmlJavaTypeAdapter();
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
    }

    public void testUpdateXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlElementRefs();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefsMapping mapping = (XmlElementRefsMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefsMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)xmlJavaTypeAdapterAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefsMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)mapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
    }

    public void testModifyXmlElementWrapper() throws Exception {
        this.createTypeWithXmlElementRefs();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefsMapping mapping = (XmlElementRefsMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)mapping.getXmlElementWrapper());
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
        mapping.addXmlElementWrapper();
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)mapping.getXmlElementWrapper());
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)xmlElementWrapperAnnotation);
        mapping.removeXmlElementWrapper();
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
    }

    public void testUpdateXmlElementWrapper() throws Exception {
        this.createTypeWithXmlElementRefs();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefsMapping mapping = (XmlElementRefsMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)mapping.getXmlElementWrapper());
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefsMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElementWrapper");
            }
        });
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)mapping.getXmlElementWrapper());
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)xmlElementWrapperAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefsMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElementWrapper");
            }
        });
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)mapping.getXmlElementWrapper());
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
    }

    public void testModifyXmlMixed() throws Exception {
        this.createTypeWithXmlElementRefs();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefsMapping mapping = (XmlElementRefsMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlMixedAnnotation annotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)mapping.getXmlMixed());
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)annotation);
        mapping.addXmlMixed();
        annotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)mapping.getXmlMixed());
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)annotation);
        mapping.removeXmlMixed();
        annotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)mapping.getXmlMixed());
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)annotation);
    }

    public void testUpdateXmlMixed() throws Exception {
        this.createTypeWithXmlElementRefs();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementRefsMapping mapping = (XmlElementRefsMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlMixedAnnotation annotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)mapping.getXmlMixed());
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)annotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefsMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlMixed");
            }
        });
        annotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)mapping.getXmlMixed());
        GenericJavaXmlElementRefsMappingTests.assertNotNull((Object)annotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementRefsMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlMixed");
            }
        });
        annotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)mapping.getXmlMixed());
        GenericJavaXmlElementRefsMappingTests.assertNull((Object)annotation);
    }
}

