/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.XmlSeeAlso;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSeeAlsoAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlSeeAlsoTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlSeeAlsoTests(String name) {
        super(name);
    }

    private ICompilationUnit createAnnotatedPersistentClassWithXmlSeeAlso() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlSeeAlso"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType" + CR);
                sb.append("@XmlSeeAlso");
            }
        });
    }

    public void testModifyClasses() throws Exception {
        this.createAnnotatedPersistentClassWithXmlSeeAlso();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlSeeAlso contextXmlSeeAlso = classMapping.getXmlSeeAlso();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaXmlSeeAlsoTests.assertEquals((int)0, (int)contextXmlSeeAlso.getClassesSize());
        contextXmlSeeAlso.addClass(0, "foo");
        XmlSeeAlsoAnnotation annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaXmlSeeAlsoTests.assertEquals((int)1, (int)annotation.getClassesSize());
        GenericJavaXmlSeeAlsoTests.assertTrue((boolean)CollectionTools.contains((Iterable)annotation.getClasses(), (Object)"foo"));
        GenericJavaXmlSeeAlsoTests.assertFalse((boolean)CollectionTools.contains((Iterable)annotation.getClasses(), (Object)"bar"));
        contextXmlSeeAlso.addClass(0, "bar");
        annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaXmlSeeAlsoTests.assertEquals((int)2, (int)annotation.getClassesSize());
        GenericJavaXmlSeeAlsoTests.assertTrue((boolean)CollectionTools.contains((Iterable)annotation.getClasses(), (Object)"foo"));
        GenericJavaXmlSeeAlsoTests.assertTrue((boolean)CollectionTools.contains((Iterable)annotation.getClasses(), (Object)"bar"));
        contextXmlSeeAlso.removeClass(1);
        annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaXmlSeeAlsoTests.assertEquals((int)1, (int)annotation.getClassesSize());
        GenericJavaXmlSeeAlsoTests.assertFalse((boolean)CollectionTools.contains((Iterable)annotation.getClasses(), (Object)"foo"));
        GenericJavaXmlSeeAlsoTests.assertTrue((boolean)CollectionTools.contains((Iterable)annotation.getClasses(), (Object)"bar"));
        contextXmlSeeAlso.removeClass(0);
        annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaXmlSeeAlsoTests.assertEquals((int)0, (int)annotation.getClassesSize());
        GenericJavaXmlSeeAlsoTests.assertFalse((boolean)CollectionTools.contains((Iterable)annotation.getClasses(), (Object)"bar"));
        GenericJavaXmlSeeAlsoTests.assertFalse((boolean)CollectionTools.contains((Iterable)annotation.getClasses(), (Object)"foo"));
    }

    public void testUpdateClasses() throws Exception {
        this.createAnnotatedPersistentClassWithXmlSeeAlso();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        XmlSeeAlso contextXmlSeeAlso = classMapping.getXmlSeeAlso();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        GenericJavaXmlSeeAlsoTests.assertEquals((int)0, (int)contextXmlSeeAlso.getClassesSize());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSeeAlsoTests.this.addClass(declaration, 0, "foo");
            }
        });
        GenericJavaXmlSeeAlsoTests.assertEquals((int)1, (int)contextXmlSeeAlso.getClassesSize());
        GenericJavaXmlSeeAlsoTests.assertTrue((boolean)CollectionTools.contains((Iterable)contextXmlSeeAlso.getClasses(), (Object)"foo"));
        GenericJavaXmlSeeAlsoTests.assertFalse((boolean)CollectionTools.contains((Iterable)contextXmlSeeAlso.getClasses(), (Object)"bar"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSeeAlsoTests.this.addClass(declaration, 0, "bar");
            }
        });
        GenericJavaXmlSeeAlsoTests.assertEquals((int)2, (int)contextXmlSeeAlso.getClassesSize());
        GenericJavaXmlSeeAlsoTests.assertTrue((boolean)CollectionTools.contains((Iterable)contextXmlSeeAlso.getClasses(), (Object)"foo"));
        GenericJavaXmlSeeAlsoTests.assertTrue((boolean)CollectionTools.contains((Iterable)contextXmlSeeAlso.getClasses(), (Object)"bar"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSeeAlsoTests.this.removeClass(declaration, 1);
            }
        });
        GenericJavaXmlSeeAlsoTests.assertEquals((int)1, (int)contextXmlSeeAlso.getClassesSize());
        GenericJavaXmlSeeAlsoTests.assertFalse((boolean)CollectionTools.contains((Iterable)contextXmlSeeAlso.getClasses(), (Object)"foo"));
        GenericJavaXmlSeeAlsoTests.assertTrue((boolean)CollectionTools.contains((Iterable)contextXmlSeeAlso.getClasses(), (Object)"bar"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSeeAlsoTests.this.removeClass(declaration, 0);
            }
        });
        GenericJavaXmlSeeAlsoTests.assertEquals((int)0, (int)contextXmlSeeAlso.getClassesSize());
        GenericJavaXmlSeeAlsoTests.assertFalse((boolean)CollectionTools.contains((Iterable)contextXmlSeeAlso.getClasses(), (Object)"bar"));
        GenericJavaXmlSeeAlsoTests.assertFalse((boolean)CollectionTools.contains((Iterable)contextXmlSeeAlso.getClasses(), (Object)"foo"));
    }

    protected void addClass(ModifiedDeclaration declaration, int index, String clazz) {
        this.addArrayElement(declaration, "javax.xml.bind.annotation.XmlSeeAlso", index, "value", (Expression)this.newTypeLiteral(declaration.getAst(), clazz));
    }

    protected void removeClass(ModifiedDeclaration declaration, int index) {
        this.removeArrayElement((NormalAnnotation)this.getXmlSeeAlsoAnnotation(declaration), "value", index);
    }

    protected Annotation getXmlSeeAlsoAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlSeeAlso");
    }
}

