/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAnyElementAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlAnyElementAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_ANY_ELEMENT_VALUE = "String";

    public XmlAnyElementAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlAnyElement() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlAnyElement"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAnyElement");
            }
        });
    }

    private ICompilationUnit createTestXmlAnyElementWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlAnyElement"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAnyElement(" + booleanElement + " = true)");
            }
        });
    }

    private ICompilationUnit createTestXmlAnyElementWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlAnyElement"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAnyElement(value = String.class)");
            }
        });
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlAnyElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlAnyElementAnnotation xmlAnyElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        XmlAnyElementAnnotationTests.assertTrue((xmlAnyElementAnnotation != null ? 1 : 0) != 0);
        XmlAnyElementAnnotationTests.assertNull((Object)xmlAnyElementAnnotation.getLax());
        XmlAnyElementAnnotationTests.assertNull((Object)xmlAnyElementAnnotation.getValue());
    }

    public void testGetLax() throws Exception {
        ICompilationUnit cu = this.createTestXmlAnyElementWithBooleanElement("lax");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlAnyElementAnnotation xmlAnyElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        XmlAnyElementAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)xmlAnyElementAnnotation.getLax());
    }

    public void testSetLax() throws Exception {
        ICompilationUnit cu = this.createTestXmlAnyElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlAnyElementAnnotation xmlAnyElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        XmlAnyElementAnnotationTests.assertNotNull((Object)xmlAnyElementAnnotation);
        XmlAnyElementAnnotationTests.assertNull((Object)xmlAnyElementAnnotation.getLax());
        xmlAnyElementAnnotation.setLax(Boolean.FALSE);
        XmlAnyElementAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)xmlAnyElementAnnotation.getLax());
        this.assertSourceContains("@XmlAnyElement(lax = false)", cu);
        xmlAnyElementAnnotation.setLax(null);
        this.assertSourceContains("@XmlAnyElement", cu);
        this.assertSourceDoesNotContain("lax", cu);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlAnyElementWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlAnyElementAnnotation xmlAnyElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        XmlAnyElementAnnotationTests.assertTrue((xmlAnyElementAnnotation != null ? 1 : 0) != 0);
        XmlAnyElementAnnotationTests.assertEquals((String)XML_ANY_ELEMENT_VALUE, (String)xmlAnyElementAnnotation.getValue());
        XmlAnyElementAnnotationTests.assertEquals((String)"java.lang.String", (String)xmlAnyElementAnnotation.getFullyQualifiedValueClassName());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlAnyElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlAnyElementAnnotation xmlAnyElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        XmlAnyElementAnnotationTests.assertNull((Object)xmlAnyElementAnnotation.getValue());
        xmlAnyElementAnnotation.setValue(XML_ANY_ELEMENT_VALUE);
        XmlAnyElementAnnotationTests.assertEquals((String)XML_ANY_ELEMENT_VALUE, (String)xmlAnyElementAnnotation.getValue());
        this.assertSourceContains("@XmlAnyElement(String.class)", cu);
        xmlAnyElementAnnotation.setValue(null);
        XmlAnyElementAnnotationTests.assertNull((Object)xmlAnyElementAnnotation.getValue());
        this.assertSourceContains("@XmlAnyElement", cu);
        this.assertSourceDoesNotContain("@XmlAnyElement(value = String.class)", cu);
    }
}

