/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefsAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlElementRefsAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_ELEMENT_REF_NAME = "elementName";
    private static final String XML_ELEMENT_REF_NAMESPACE = "XmlElementRefNamespace";
    private static final String XML_ELEMENT_REF_TYPE = "String";

    public XmlElementRefsAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlElementRef() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementRef", "javax.xml.bind.annotation.XmlElementRefs"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementRefs(@XmlElementRef)");
            }
        });
    }

    private ICompilationUnit createTestXmlElementRefWithName() throws Exception {
        return this.createTestXmlElementRefWithStringElement("name", XML_ELEMENT_REF_NAME);
    }

    private ICompilationUnit createTestXmlElementRefWithNamespace() throws Exception {
        return this.createTestXmlElementRefWithStringElement("namespace", XML_ELEMENT_REF_NAMESPACE);
    }

    private ICompilationUnit createTestXmlElementRefWithStringElement(final String element, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementRef", "javax.xml.bind.annotation.XmlElementRefs"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementRefs(@XmlElementRef(" + element + " = \"" + value + "\"))");
            }
        });
    }

    private ICompilationUnit createTestXmlElementRefWithType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementRef", "javax.xml.bind.annotation.XmlElementRefs"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementRefs(@XmlElementRef(type = String.class))");
            }
        });
    }

    private ICompilationUnit createTestXmlElementRefWithAll() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementRef", "javax.xml.bind.annotation.XmlElementRefs"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementRefs(@XmlElementRef(name = \"elementName\", namespace = \"XmlElementRefNamespace\", type = String.class))");
            }
        });
    }

    private XmlElementRefAnnotation getXmlElementRefAnnotation(JavaResourceAttribute resourceAttribute) {
        XmlElementRefsAnnotation refsAnnotation = (XmlElementRefsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs");
        return refsAnnotation.xmlElementRefAt(0);
    }

    private XmlElementRefAnnotation addXmlElementRefAnnotation(int index, JavaResourceAttribute resourceAttribute) {
        XmlElementRefsAnnotation refsAnnotation = (XmlElementRefsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs");
        return refsAnnotation.addXmlElementRef(index);
    }

    private void removeXmlElementRefAnnotation(int index, JavaResourceAttribute resourceAttribute) {
        XmlElementRefsAnnotation refsAnnotation = (XmlElementRefsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs");
        refsAnnotation.removeXmlElementRef(index);
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRef();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = this.getXmlElementRefAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementRefsAnnotationTests.assertTrue((xmlElementRefAnnotation != null ? 1 : 0) != 0);
        XmlElementRefsAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getName());
        XmlElementRefsAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getNamespace());
        XmlElementRefsAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getType());
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRefWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = this.getXmlElementRefAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementRefsAnnotationTests.assertTrue((xmlElementRefAnnotation != null ? 1 : 0) != 0);
        XmlElementRefsAnnotationTests.assertEquals((String)XML_ELEMENT_REF_NAME, (String)xmlElementRefAnnotation.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRef();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = this.getXmlElementRefAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementRefsAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getName());
        xmlElementRefAnnotation.setName(XML_ELEMENT_REF_NAME);
        XmlElementRefsAnnotationTests.assertEquals((String)XML_ELEMENT_REF_NAME, (String)xmlElementRefAnnotation.getName());
        this.assertSourceContains("@XmlElementRefs(@XmlElementRef(name = \"elementName\"))", cu);
        xmlElementRefAnnotation.setName(null);
        XmlElementRefsAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getName());
        this.assertSourceContains("@XmlElementRefs(@XmlElementRef)", cu);
    }

    public void testGetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRefWithNamespace();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = this.getXmlElementRefAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementRefsAnnotationTests.assertTrue((xmlElementRefAnnotation != null ? 1 : 0) != 0);
        XmlElementRefsAnnotationTests.assertEquals((String)XML_ELEMENT_REF_NAMESPACE, (String)xmlElementRefAnnotation.getNamespace());
    }

    public void testSetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRef();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = this.getXmlElementRefAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementRefsAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getNamespace());
        xmlElementRefAnnotation.setNamespace(XML_ELEMENT_REF_NAMESPACE);
        XmlElementRefsAnnotationTests.assertEquals((String)XML_ELEMENT_REF_NAMESPACE, (String)xmlElementRefAnnotation.getNamespace());
        this.assertSourceContains("@XmlElementRefs(@XmlElementRef(namespace = \"XmlElementRefNamespace\"))", cu);
        xmlElementRefAnnotation.setNamespace(null);
        XmlElementRefsAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getNamespace());
        this.assertSourceContains("@XmlElementRefs(@XmlElementRef)", cu);
    }

    public void testGetType() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRefWithType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = this.getXmlElementRefAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementRefsAnnotationTests.assertTrue((xmlElementRefAnnotation != null ? 1 : 0) != 0);
        XmlElementRefsAnnotationTests.assertEquals((String)XML_ELEMENT_REF_TYPE, (String)xmlElementRefAnnotation.getType());
        XmlElementRefsAnnotationTests.assertEquals((String)"java.lang.String", (String)xmlElementRefAnnotation.getFullyQualifiedTypeName());
    }

    public void testSetType() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRef();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlElementRefAnnotation xmlElementRefAnnotation = this.getXmlElementRefAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlElementRefsAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getType());
        xmlElementRefAnnotation.setType(XML_ELEMENT_REF_TYPE);
        XmlElementRefsAnnotationTests.assertEquals((String)XML_ELEMENT_REF_TYPE, (String)xmlElementRefAnnotation.getType());
        this.assertSourceContains("@XmlElementRefs(@XmlElementRef(type = String.class))", cu);
        xmlElementRefAnnotation.setType(null);
        XmlElementRefsAnnotationTests.assertNull((Object)xmlElementRefAnnotation.getType());
        this.assertSourceContains("@XmlElementRefs(@XmlElementRef)", cu);
    }

    public void testAddXmlElementRef() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRefWithAll();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        this.addXmlElementRefAnnotation(1, (JavaResourceAttribute)resourceAttribute);
        XmlElementRefsAnnotation refsAnnotation = (XmlElementRefsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs");
        this.assertSourceContains("@XmlElementRefs({@XmlElementRef(name = \"elementName\", namespace = \"XmlElementRefNamespace\", type = String.class),@XmlElementRef})", cu);
        XmlElementRefsAnnotationTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef"));
        XmlElementRefsAnnotationTests.assertNotNull((Object)refsAnnotation);
        XmlElementRefsAnnotationTests.assertEquals((int)2, (int)refsAnnotation.getXmlElementRefsSize());
    }

    public void testAddXmlElementRefToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRefWithAll();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        this.addXmlElementRefAnnotation(1, (JavaResourceAttribute)resourceAttribute);
        XmlElementRefsAnnotation refsAnnotation = (XmlElementRefsAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRefs");
        this.assertSourceContains("@XmlElementRefs({@XmlElementRef(name = \"elementName\", namespace = \"XmlElementRefNamespace\", type = String.class),@XmlElementRef})", cu);
        this.addXmlElementRefAnnotation(0, (JavaResourceAttribute)resourceAttribute);
        this.assertSourceContains("@XmlElementRefs({@XmlElementRef,@XmlElementRef(name = \"elementName\", namespace = \"XmlElementRefNamespace\", type = String.class), @XmlElementRef})", cu);
        XmlElementRefsAnnotationTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementRef"));
        XmlElementRefsAnnotationTests.assertNotNull((Object)refsAnnotation);
        XmlElementRefsAnnotationTests.assertEquals((int)3, (int)refsAnnotation.getXmlElementRefsSize());
    }

    public void testRemoveXmlElementRef() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementRefWithAll();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        this.addXmlElementRefAnnotation(1, (JavaResourceAttribute)resourceAttribute);
        this.assertSourceContains("@XmlElementRefs({@XmlElementRef(name = \"elementName\", namespace = \"XmlElementRefNamespace\", type = String.class),@XmlElementRef})", cu);
        this.removeXmlElementRefAnnotation(1, (JavaResourceAttribute)resourceAttribute);
        this.assertSourceContains("@XmlElementRef(name = \"elementName\", namespace = \"XmlElementRefNamespace\", type = String.class)", cu);
    }
}

