/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.CollectionMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.EnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAttributeOverride;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.ElementCollection2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyClass2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyEnumerated2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyTemporal2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TemporalType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConvertAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0JavaElementCollectionMappingTests
extends EclipseLink2_0ContextModelTestCase {
    public static final String EMBEDDABLE_TYPE_NAME = "Address";
    public static final String FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME = "test.Address";

    private ICompilationUnit createTestEntityWithElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithElementCollectionMappingWithConvert() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "org.eclipse.persistence.annotations.Convert"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection").append(CR);
                sb.append("@Convert(\"class-instance\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithGenericEmbeddableElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithGenericBasicElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<String> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithNonGenericElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidGenericMapElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map<Integer, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append(EclipseLink2_0JavaElementCollectionMappingTests.EMBEDDABLE_TYPE_NAME).append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map<Address, PropertyInfo> parcels;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddablePropertyInfo() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("PropertyInfo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private Integer parcelNumber;").append(CR);
                sb.append(CR);
                sb.append("    private Integer size;").append(CR);
                sb.append(CR);
                sb.append("    private java.math.BigDecimal tax;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PropertyInfo.java", sourceWriter);
    }

    private void createSelfReferentialElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR).append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Foo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.List<Foo> elementCollection;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Foo.java", sourceWriter);
    }

    public EclipseLink2_0JavaElementCollectionMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        EclipseLink2_0JavaElementCollectionMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
    }

    public void testUpdateSpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ElementCollection2_0Annotation elementCollectionAnnotation = (ElementCollection2_0Annotation)resourceField.getAnnotation("javax.persistence.ElementCollection");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionAnnotation.getTargetClass());
        elementCollectionAnnotation.setTargetClass("newTargetClass");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"newTargetClass", (String)elementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"newTargetClass", (String)elementCollectionAnnotation.getTargetClass());
        elementCollectionAnnotation.setTargetClass(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionAnnotation.getTargetClass());
    }

    public void testModifySpecifiedTargetClass() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ElementCollection2_0Annotation elementCollection = (ElementCollection2_0Annotation)resourceField.getAnnotation("javax.persistence.ElementCollection");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass("newTargetClass");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"newTargetClass", (String)elementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"newTargetClass", (String)elementCollection.getTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getTargetClass());
    }

    public void testDefaultTargetClass() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass("foo");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaPersistentType addressPersistentType = addressClassRef.getJavaPersistentType();
        addressPersistentType.setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testDefaultTargetClassNonGenericCollection() throws Exception {
        this.createTestEntityWithNonGenericElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testDefaultTargetClassGenericCollection() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testDefaultTargetClassNonGenericMap() throws Exception {
        this.createTestEntityWithValidNonGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testDefaultTargetClassGenericMap() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getDefaultTargetClass());
    }

    public void testTargetClass() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass("foo");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)elementCollectionMapping.getTargetClass());
        elementCollectionMapping.setSpecifiedTargetClass(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME, (String)elementCollectionMapping.getTargetClass());
    }

    protected Embeddable getResolvedTargetEmbeddable(ElementCollectionMapping2_0 mapping) {
        return (Embeddable)ReflectionTools.executeMethod((Object)mapping, (String)"getResolvedTargetEmbeddable");
    }

    public void testResolvedTargetEmbeddable() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)this.getResolvedTargetEmbeddable(elementCollectionMapping));
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaTypeMapping addressTypeMapping = addressClassRef.getJavaPersistentType().getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)addressTypeMapping, (Object)this.getResolvedTargetEmbeddable(elementCollectionMapping));
        elementCollectionMapping.setSpecifiedTargetClass("foo");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)this.getResolvedTargetEmbeddable(elementCollectionMapping));
        elementCollectionMapping.setSpecifiedTargetClass(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)addressTypeMapping, (Object)this.getResolvedTargetEmbeddable(elementCollectionMapping));
        elementCollectionMapping.setSpecifiedTargetClass(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)addressTypeMapping, (Object)this.getResolvedTargetEmbeddable(elementCollectionMapping));
    }

    public void testResolvedTargetEmbeddableWithBasicType() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)this.getResolvedTargetEmbeddable(elementCollectionMapping));
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ElementCollection2_0Annotation elementCollection = (ElementCollection2_0Annotation)resourceField.getAnnotation("javax.persistence.ElementCollection");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getFetch());
        elementCollection.setFetch(org.eclipse.jpt.jpa.core.resource.java.FetchType.EAGER);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)FetchType.EAGER, (Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.EAGER, (Object)elementCollection.getFetch());
        elementCollection.setFetch(org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)FetchType.LAZY, (Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)elementCollection.getFetch());
        elementCollection.setFetch(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ElementCollection2_0Annotation elementCollection = (ElementCollection2_0Annotation)resourceField.getAnnotation("javax.persistence.ElementCollection");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getFetch());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)FetchType.EAGER, (Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.EAGER, (Object)elementCollection.getFetch());
        elementCollectionMapping.setSpecifiedFetch(FetchType.LAZY);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)FetchType.LAZY, (Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)elementCollection.getFetch());
        elementCollectionMapping.setSpecifiedFetch(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollection.getFetch());
    }

    public void testGetValueTypeEmbeddable() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.EMBEDDABLE_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testGetValueTypeNone() throws Exception {
        this.createTestEntityWithNonGenericElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.NO_TYPE, (Object)elementCollectionMapping.getValueType());
        elementCollectionMapping.setSpecifiedTargetClass(EMBEDDABLE_TYPE_NAME);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.EMBEDDABLE_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testGetValueTypeBasic() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.BASIC_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
        resourceField.addAnnotation("javax.persistence.MapKey");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        MapKeyAnnotation mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)mapKey);
        mapKey.setName("myMapKey");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"myMapKey", (String)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        mapKey.setName(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)mapKey.getName());
        mapKey.setName("myMapKey");
        resourceField.removeAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
    }

    public void testModifyMapKey() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
        elementCollectionMapping.setSpecifiedMapKey("myMapKey");
        MapKeyAnnotation mapKeyAnnotation = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"myMapKey", (String)elementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"myMapKey", (String)mapKeyAnnotation.getName());
        elementCollectionMapping.setSpecifiedMapKey(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKey());
        mapKeyAnnotation = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)mapKeyAnnotation.getName());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping2_0 = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        Iterator mapKeyNames = elementCollectionMapping2_0.getCandidateMapKeyNames().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping2_0 = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        Iterator mapKeyNames = elementCollectionMapping2_0.getCandidateMapKeyNames().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        elementCollectionMapping2_0.setSpecifiedTargetClass(EMBEDDABLE_TYPE_NAME);
        mapKeyNames = elementCollectionMapping2_0.getCandidateMapKeyNames().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        elementCollectionMapping2_0.setSpecifiedTargetClass("String");
        mapKeyNames = elementCollectionMapping2_0.getCandidateMapKeyNames().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
        resourceField.addAnnotation("javax.persistence.MapKeyClass");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        MapKeyClass2_0Annotation mapKeyClassAnnotation = (MapKeyClass2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)mapKeyClassAnnotation);
        mapKeyClassAnnotation.setValue("myMapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"myMapKeyClass", (String)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"myMapKeyClass", (String)mapKeyClassAnnotation.getValue());
        mapKeyClassAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)mapKeyClassAnnotation.getValue());
        mapKeyClassAnnotation.setValue("myMapKeyClass");
        resourceField.removeAnnotation("javax.persistence.MapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
        elementCollectionMapping.setSpecifiedMapKeyClass("String");
        MapKeyClass2_0Annotation mapKeyClass = (MapKeyClass2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"String", (String)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"String", (String)mapKeyClass.getValue());
        elementCollectionMapping.setSpecifiedMapKeyClass(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testDefaultMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"java.lang.Integer", (String)elementCollectionMapping.getDefaultMapKeyClass());
        elementCollectionMapping.setSpecifiedMapKeyClass("foo");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"java.lang.Integer", (String)elementCollectionMapping.getDefaultMapKeyClass());
    }

    public void testDefaultMapKeyClassCollectionType() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getDefaultMapKeyClass());
    }

    public void testMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"java.lang.Integer", (String)elementCollectionMapping.getMapKeyClass());
        elementCollectionMapping.setSpecifiedMapKeyClass("foo");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)elementCollectionMapping.getMapKeyClass());
        elementCollectionMapping.setSpecifiedMapKeyClass(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"java.lang.Integer", (String)elementCollectionMapping.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        Orderable2_0 orderable = (Orderable2_0)elementCollectionMapping.getOrderable();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        orderable.setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = orderable.getOrderColumn();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)orderColumn.getSpecifiedName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getDefaultName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)orderColumn.getTable());
        orderColumn.setSpecifiedName("FOO");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)orderColumn.getSpecifiedName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getDefaultName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)orderColumn.getTable());
    }

    public void testGetValueColumn() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getValueColumn().getSpecifiedName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"id", (String)elementCollectionMapping.getValueColumn().getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ColumnAnnotation column = (ColumnAnnotation)resourceField.addAnnotation("javax.persistence.Column");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)elementCollectionMapping.getValueColumn().getSpecifiedName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)elementCollectionMapping.getValueColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"id", (String)elementCollectionMapping.getValueColumn().getDefaultName());
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"addresses", (String)resourceField.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ReadOnlyAttributeOverride defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        Embeddable embeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)embeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"addresses", (String)resourceField.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)attributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)attributeOverrideContainer.getOverridesSize());
    }

    public void testVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("state.name");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)attributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ((AttributeOverride)attributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"zip", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverrides.next();
        ((VirtualAttributeOverride)virtualAttributeOverrides.next()).convertToSpecified();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithGenericEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.State");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        JavaPersistentType persistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentType.getAttributeNamed("addresses").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        ReadOnlyAttributeOverride virtualAttributeOverride = (ReadOnlyAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (ReadOnlyAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (ReadOnlyAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (ReadOnlyAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"zip", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverrides.hasNext());
        JavaPersistentType addressPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        EmbeddedMapping nestedEmbeddedMapping = (EmbeddedMapping)addressPersistentType.getAttributeNamed("state").getMapping();
        AttributeOverrideContainer nestedAttributeOverrideContainer = nestedEmbeddedMapping.getAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)nestedAttributeOverrideContainer.getVirtualOverridesSize());
        virtualAttributeOverrides = nestedAttributeOverrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverride = (ReadOnlyAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"name", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (ReadOnlyAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"abbr", (String)virtualAttributeOverride.getName());
        JavaPersistentType statePersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        BasicMapping abbrMapping = (BasicMapping)statePersistentType.getAttributeNamed("abbr").getMapping();
        abbrMapping.getColumn().setSpecifiedName("BLAH");
        abbrMapping.getColumn().setSpecifiedTable("BLAH_TABLE");
        abbrMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        abbrMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        abbrMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        abbrMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        abbrMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        abbrMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        abbrMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        abbrMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        virtualAttributeOverride = ((EmbeddedMapping)addressPersistentType.getAttributeNamed("state").getMapping()).getAttributeOverrideContainer().getOverrideNamed("abbr");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"abbr", (String)virtualAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
    }

    public void testGetMapKeyColumn() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"addresses_KEY", (String)elementCollectionMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)elementCollectionMapping.getMapKeyColumn().getTable());
        elementCollectionMapping.getCollectionTable().setSpecifiedName("MY_COLLECTION_TABLE");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"MY_COLLECTION_TABLE", (String)elementCollectionMapping.getMapKeyColumn().getTable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)elementCollectionMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)elementCollectionMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"addresses_KEY", (String)elementCollectionMapping.getMapKeyColumn().getDefaultName());
    }

    public void testMapKeyValueSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        ListIterator specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BLAH");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
    }

    public void testMapKeyValueVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcels", (String)resourceField.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        ReadOnlyAttributeOverride defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_parcels", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        Embeddable addressEmbeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)addressEmbeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcels", (String)resourceField.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_parcels", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_parcels", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        classRefs.next();
        Embeddable propertyInfoEmbeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping parcelNumberMapping = (BasicMapping)propertyInfoEmbeddable.getPersistentType().getAttributeNamed("parcelNumber").getMapping();
        parcelNumberMapping.getColumn().setSpecifiedName("FOO1");
        parcelNumberMapping.getColumn().setSpecifiedTable("BAR1");
        parcelNumberMapping.getColumn().setColumnDefinition("COLUMN_DEF1");
        parcelNumberMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        parcelNumberMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        parcelNumberMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        parcelNumberMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        parcelNumberMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        parcelNumberMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        parcelNumberMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcels", (String)resourceField.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"FOO1", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"BAR1", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"COLUMN_DEF1", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        parcelNumberMapping.getColumn().setSpecifiedName(null);
        parcelNumberMapping.getColumn().setSpecifiedTable(null);
        parcelNumberMapping.getColumn().setColumnDefinition(null);
        parcelNumberMapping.getColumn().setSpecifiedInsertable(null);
        parcelNumberMapping.getColumn().setSpecifiedUpdatable(null);
        parcelNumberMapping.getColumn().setSpecifiedUnique(null);
        parcelNumberMapping.getColumn().setSpecifiedNullable(null);
        parcelNumberMapping.getColumn().setSpecifiedLength(null);
        parcelNumberMapping.getColumn().setSpecifiedPrecision(null);
        parcelNumberMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_parcels", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        annotation = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("value.parcelNumber");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)valueAttributeOverrideContainer.getSpecifiedOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)0, (int)mapKeyAttributeOverrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)valueAttributeOverrideContainer.getSpecifiedOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)1, (int)mapKeyAttributeOverrideContainer.getSpecifiedOverridesSize());
    }

    public void testMapKeyValueAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)valueAttributeOverrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)valueAttributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)5, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)6, (int)valueAttributeOverrideContainer.getOverridesSize());
    }

    public void testMapKeyValueVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)valueAttributeOverrideContainer.getVirtualOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)valueAttributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.city");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.parcelNumber");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)valueAttributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.state.name");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("size");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)1, (int)valueAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        ((VirtualAttributeOverride)valueAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)valueAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.parcelNumber", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.size", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((AttributeOverride)valueAttributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        ((AttributeOverride)mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.size", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)((VirtualAttributeOverride)valueAttributeOverrideContainer.getVirtualOverrides().iterator().next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)2, (int)valueAttributeOverrideContainer.getVirtualOverridesSize());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((VirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        ((AttributeOverride)valueAttributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        ((AttributeOverride)mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = valueAttributeOverrideContainer.getVirtualOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"size", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"tax", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)3, (int)valueAttributeOverrideContainer.getVirtualOverridesSize());
        virtualAttributeOverrides = mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"zip", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddableKeyAndValueElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEmbeddablePropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        AttributeOverrideContainer valueAttributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        AttributeOverrideContainer mapKeyAttributeOverrideContainer = elementCollectionMapping.getMapKeyAttributeOverrideContainer();
        ((VirtualAttributeOverride)valueAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)valueAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ListIterator specifiedOverrides = valueAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"size", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.size", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.parcelNumber", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        specifiedOverrides = valueAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"size", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
        resourceField.moveAnnotation(3, 2, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.size", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"value.parcelNumber", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.state.name", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        specifiedOverrides = valueAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"size", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"parcelNumber", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"state.name", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"city", (String)((AttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
    }

    public void testSelfReferentialElementCollection() throws Exception {
        this.createSelfReferentialElementCollection();
        this.addXmlClassRef("test.Foo");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)this.getJavaPersistentType().getAttributeNamed("elementCollection").getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.getAllOverridableAttributeMappingNames().iterator().hasNext());
    }

    public void testSetSpecifiedMapKeyEnumerated() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getMapKeyConverter().getType());
        elementCollectionMapping.setMapKeyConverter(EnumeratedConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)enumerated);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (Object)enumerated.getValue());
        ((EnumeratedConverter)elementCollectionMapping.getMapKeyConverter()).setSpecifiedEnumType(EnumType.STRING);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING, (Object)enumerated.getValue());
        ((EnumeratedConverter)elementCollectionMapping.getMapKeyConverter()).setSpecifiedEnumType(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)enumerated.getValue());
        elementCollectionMapping.setMapKeyConverter(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
    }

    public void testGetSpecifiedMapKeyEnumeratedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getMapKeyConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyEnumerated");
        enumerated.setValue(org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)EnumType.STRING, (Object)((EnumeratedConverter)elementCollectionMapping.getMapKeyConverter()).getSpecifiedEnumType());
        enumerated.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)((EnumeratedConverter)elementCollectionMapping.getMapKeyConverter()).getSpecifiedEnumType());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        EclipseLink2_0JavaElementCollectionMappingTests.assertSame((Object)elementCollectionMapping, (Object)persistentAttribute.getMapping());
    }

    public void testSetMapKeyTemporal() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getMapKeyConverter().getType());
        elementCollectionMapping.setMapKeyConverter(TemporalConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyTemporal2_0Annotation temporal = (MapKeyTemporal2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyTemporal");
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)temporal);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(null, (Object)temporal.getValue());
        ((TemporalConverter)elementCollectionMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        ((TemporalConverter)elementCollectionMapping.getMapKeyConverter()).setTemporalType(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyTemporal"));
    }

    public void testGetMapKeyTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidGenericMapElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getMapKeyConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyTemporal2_0Annotation temporal = (MapKeyTemporal2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyTemporal");
        temporal.setValue(TemporalType.TIME);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((TemporalConverter)elementCollectionMapping.getMapKeyConverter()).getTemporalType());
        temporal.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyTemporal"));
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)((TemporalConverter)elementCollectionMapping.getMapKeyConverter()).getTemporalType());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        EclipseLink2_0JavaElementCollectionMappingTests.assertSame((Object)elementCollectionMapping, (Object)persistentAttribute.getMapping());
    }

    public void testGetConvert() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(EclipseLinkConvert.class, (Object)elementCollectionMapping.getConverter().getType());
    }

    public void testGetConvert2() throws Exception {
        this.createTestEntityWithElementCollectionMappingWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(EclipseLinkConvert.class, (Object)elementCollectionMapping.getConverter().getType());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"class-instance", (String)((EclipseLinkConvert)elementCollectionMapping.getConverter()).getConverterName());
    }

    public void testSetConvert() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getConverter().getType());
        elementCollectionMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)elementCollectionMapping.getConverter()).setSpecifiedConverterName("foo");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkConvertAnnotation eclipselinkConvert = (EclipseLinkConvertAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Convert");
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)eclipselinkConvert.getValue());
        elementCollectionMapping.setConverter(null);
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.Convert"));
    }

    public void testGetConvertUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkConvertAnnotation convert = (EclipseLinkConvertAnnotation)resourceField.addAnnotation("org.eclipse.persistence.annotations.Convert");
        convert.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals(EclipseLinkConvert.class, (Object)elementCollectionMapping.getConverter().getType());
        EclipseLink2_0JavaElementCollectionMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)elementCollectionMapping.getConverter()).getConverterName());
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaElementCollectionMappingTests.assertNull((Object)elementCollectionMapping.getConverter().getType());
        EclipseLink2_0JavaElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        EclipseLink2_0JavaElementCollectionMappingTests.assertSame((Object)elementCollectionMapping, (Object)persistentAttribute.getMapping());
    }
}

