/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkMappedSuperclass;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkReadOnly;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkChangeTrackingAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkCustomizerAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaMappedSuperclassTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestMappedSuperclassWithReadOnly() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "org.eclipse.persistence.annotations.ReadOnly"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("@ReadOnly").append(CR);
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassWithConvertAndCustomizerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "org.eclipse.persistence.annotations.Customizer"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("    @Customizer(Foo.class");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassWithChangeTracking() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "org.eclipse.persistence.annotations.ChangeTracking"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("    @ChangeTracking").append(CR);
            }
        });
    }

    public EclipseLinkJavaMappedSuperclassTests(String name) {
        super(name);
    }

    public void testGetReadOnly() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)readOnly.isReadOnly());
    }

    public void testGetSpecifiedReadOnly() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
    }

    public void testGetDefaultReadOnly() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)readOnly.isDefaultReadOnly());
    }

    public void testSetSpecifiedReadOnly() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)readOnly.isReadOnly());
        readOnly.setSpecifiedReadOnly(Boolean.FALSE);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)readOnly.getSpecifiedReadOnly());
        readOnly.setSpecifiedReadOnly(Boolean.TRUE);
        EclipseLinkJavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
        readOnly.setSpecifiedReadOnly(null);
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)readOnly.getSpecifiedReadOnly());
    }

    public void testSpecifiedReadOnlyUpdatesFromResourceModelChange() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.ReadOnly");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)readOnly.getSpecifiedReadOnly());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)readOnly.isDefaultReadOnly());
        resourceType.addAnnotation("org.eclipse.persistence.annotations.ReadOnly");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
    }

    public void testGetCustomizerClass() throws Exception {
        this.createTestMappedSuperclassWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkCustomizer customizer = ((EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping()).getCustomizer();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testSetCustomizerClass() throws Exception {
        this.createTestMappedSuperclassWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkCustomizer customizer = ((EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping()).getCustomizer();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        EclipseLinkCustomizerAnnotation customizerAnnotation = (EclipseLinkCustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
        customizer.setSpecifiedCustomizerClass(null);
        EclipseLinkJavaMappedSuperclassTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (EclipseLinkCustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaMappedSuperclassTests.assertEquals(null, (Object)customizerAnnotation);
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (EclipseLinkCustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
    }

    public void testGetCustomizerClassUpdatesFromResourceModelChange() throws Exception {
        this.createTestMappedSuperclassWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkCustomizer customizer = mappedSuperclass.getCustomizer();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        EclipseLinkCustomizerAnnotation customizerAnnotation = (EclipseLinkCustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        customizerAnnotation.setValue("Bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.Customizer");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaMappedSuperclassTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (EclipseLinkCustomizerAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Customizer");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaMappedSuperclassTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation.setValue("FooBar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"FooBar", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testGetChangeTracking() throws Exception {
        this.createTestMappedSuperclassWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkChangeTracking contextChangeTracking = mappedSuperclass.getChangeTracking();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        EclipseLinkChangeTrackingAnnotation resourceChangeTracking = (EclipseLinkChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.ATTRIBUTE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.OBJECT);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.DEFERRED);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.AUTO);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
    }

    public void testSetChangeTracking() throws Exception {
        this.createTestMappedSuperclassWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkChangeTracking contextChangeTracking = mappedSuperclass.getChangeTracking();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        EclipseLinkChangeTrackingAnnotation resourceChangeTracking = (EclipseLinkChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.AUTO);
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.ATTRIBUTE);
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.OBJECT);
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.DEFERRED);
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(null);
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking"));
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.AUTO);
        resourceChangeTracking = (EclipseLinkChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
    }
}

