/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkTypeConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaTypeConverterTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithConvertAndTypeConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @TypeConverter(name=\"foo\"");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndDataType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @TypeConverter(dataType=Foo.class");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndObjectType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @TypeConverter(objectType=Foo.class");
            }
        });
    }

    public EclipseLinkJavaTypeConverterTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithConvertAndTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkTypeConverter converter = (EclipseLinkTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"foo", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithConvertAndTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkTypeConverter converter = (EclipseLinkTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"foo", (String)converter.getName());
        converter.setName("bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"bar", (String)converter.getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkTypeConverterAnnotation converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
        converter.setName(null);
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (String)converter.getName());
        converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (String)converterAnnotation.getName());
        converter.setName("bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"bar", (String)converter.getName());
        converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
    }

    public void testGetNameUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkTypeConverter converter = (EclipseLinkTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"foo", (String)converter.getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkTypeConverterAnnotation converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        converterAnnotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"bar", (String)converter.getName());
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.addAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaTypeConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"FOO", (String)eclipseLinkConvert.getConverter().getName());
    }

    public void testGetDataType() throws Exception {
        this.createTestEntityWithConvertAndDataType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkTypeConverter converter = (EclipseLinkTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Foo", (String)converter.getDataType());
    }

    public void testSetDataType() throws Exception {
        this.createTestEntityWithConvertAndDataType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkTypeConverter converter = (EclipseLinkTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Foo", (String)converter.getDataType());
        converter.setDataType("Bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converter.getDataType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkTypeConverterAnnotation converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getDataType());
        converter.setDataType(null);
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (String)converter.getDataType());
        converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (String)converterAnnotation.getDataType());
        converter.setDataType("Bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converter.getDataType());
        converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getDataType());
    }

    public void testGetDataTypeUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndDataType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkTypeConverter converter = (EclipseLinkTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Foo", (String)converter.getDataType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkTypeConverterAnnotation converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        converterAnnotation.setDataType("Bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converter.getDataType());
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.addAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaTypeConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setDataType("FooBar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"FooBar", (String)((EclipseLinkTypeConverter)eclipseLinkConvert.getConverter()).getDataType());
    }

    public void testGetObjectType() throws Exception {
        this.createTestEntityWithConvertAndObjectType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkTypeConverter converter = (EclipseLinkTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Foo", (String)converter.getObjectType());
    }

    public void testSetObjectType() throws Exception {
        this.createTestEntityWithConvertAndObjectType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkTypeConverter converter = (EclipseLinkTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Foo", (String)converter.getObjectType());
        converter.setObjectType("Bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkTypeConverterAnnotation converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getObjectType());
        converter.setObjectType(null);
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (String)converter.getObjectType());
        converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (String)converterAnnotation.getObjectType());
        converter.setObjectType("Bar");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getObjectType());
    }

    public void testGetObjectTypeUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndObjectType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkConvert eclipseLinkConvert = (EclipseLinkConvert)basicMapping.getConverter();
        EclipseLinkTypeConverter converter = (EclipseLinkTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Foo", (String)converter.getObjectType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkTypeConverterAnnotation converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        converterAnnotation.setObjectType("Bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaTypeConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (EclipseLinkTypeConverterAnnotation)resourceField.addAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaTypeConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setObjectType("FooBar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaTypeConverterTests.assertEquals((String)"FooBar", (String)((EclipseLinkTypeConverter)eclipseLinkConvert.getConverter()).getObjectType());
    }
}

