/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkIdMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkOneToOneMapping;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink1_1ContextModelTestCase;

public class EclipseLink1_1OrmPersistentAttributeTests
extends EclipseLink1_1ContextModelTestCase {
    public EclipseLink1_1OrmPersistentAttributeTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTypeNullAttributeMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityIdMappingPropertyAccess() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append("    private Address address;");
            }
        });
    }

    public void testMakeSpecified() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getVirtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.convertToSpecified();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getVirtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next();
        ormPersistentAttribute.convertToSpecified();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.getVirtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.getSpecifiedAttributes().iterator();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"name", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeSpecifiedMappingKey() throws Exception {
        this.createTestTypeNullAttributeMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)3, (int)ormPersistentType.getVirtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertNull((Object)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute.convertToSpecified("oneToOne");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getVirtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof OrmEclipseLinkOneToOneMapping));
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next();
        ormPersistentAttribute.convertToSpecified("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getVirtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.getSpecifiedAttributes().iterator();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof OrmEclipseLinkIdMapping));
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeVirtual() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getVirtualAttributesSize());
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next()).convertToSpecified();
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next()).convertToSpecified();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.getVirtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute.convertToVirtual();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getVirtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        specifiedOrmPersistentAttribute.convertToVirtual();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getVirtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.getSpecifiedAttributesSize());
        ListIterator virtualAttributes = ormPersistentType.getVirtualAttributes().iterator();
        OrmReadOnlyPersistentAttribute virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)virtualAttribute.getName());
        virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"name", (String)virtualAttribute.getName());
    }

    public void testMakeVirtualNoUnderlyingJavaAttribute() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getVirtualAttributesSize());
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next()).convertToSpecified();
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next()).convertToSpecified();
        ((OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next()).getMapping().setName("noJavaAttribute");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getVirtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.getSpecifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        specifiedOrmPersistentAttribute.convertToVirtual();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getVirtualAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)((OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next()).getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"name", (String)((OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next()).getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMappingKey());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete2() throws Exception {
        this.createTestEntityOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
    }

    public void testGetJavaPersistentAttribute() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        JavaResourceAttribute javaResourceAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute();
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)(javaResourceAttribute instanceof JavaResourceField));
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourceAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals(javaPersistentType.getJavaResourceType().getFields().iterator().next(), (Object)javaResourceAttribute);
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ((OrmPersistentAttribute)ormPersistentAttribute).convertToVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        ListIterator attributes = ormPersistentType.getAttributes().iterator();
        OrmReadOnlyPersistentAttribute idFieldAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        OrmReadOnlyPersistentAttribute idPropertyAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)ormPersistentAttribute, (Object)idFieldAttribute);
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)ormPersistentAttribute, (Object)idPropertyAttribute);
        ormPersistentAttribute = idPropertyAttribute;
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)idFieldAttribute.getJavaPersistentAttribute().getAccess());
        javaResourceAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute();
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourceAttribute.getName());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals(javaPersistentType.getJavaResourceType().getMethods().iterator().next(), (Object)javaResourceAttribute);
        ormPersistentType.setSpecifiedAccess(null);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmPersistentAttribute ormPersistentAttribute2 = ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute2.getMapping().setName("id2");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName(null);
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
    }

    public void testGetJavaPersistentAttributeMixedAccess() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        ListIterator attributes = ormPersistentType.getAttributes().iterator();
        OrmReadOnlyPersistentAttribute ormFieldAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        OrmReadOnlyPersistentAttribute ormPropertyAttribute = (OrmReadOnlyPersistentAttribute)attributes.next();
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormFieldAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPropertyAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getOwningPersistentType().getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormFieldAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPropertyAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPropertyAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)ormFieldAttribute.getMappingKey());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"basic", (String)ormPropertyAttribute.getMappingKey());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((String)"id", (String)javaPersistentAttribute.getMappingKey());
        ormPropertyAttribute.convertToSpecified();
        ormPropertyAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPropertyAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPropertyAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPropertyAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((ormPropertyAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        ((OrmPersistentAttribute)ormPropertyAttribute).setSpecifiedAccess(AccessType.FIELD);
        ormPropertyAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPropertyAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPropertyAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPropertyAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((ormPropertyAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
    }

    public void testGetAccess() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD ? 1 : 0) != 0);
    }

    public void testGetAccessPropertyInJava() throws Exception {
        this.createTestEntityIdMappingPropertyAccess();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((ormPersistentAttribute.getJavaPersistentAttribute().getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink1_1OrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        EclipseLink1_1OrmPersistentAttributeTests.assertTrue((javaPersistentAttribute.getResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.METHOD ? 1 : 0) != 0);
    }
}

