/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink1_1ContextModelTestCase;

public class EclipseLink1_1OrmPersistentTypeTests
extends EclipseLink1_1ContextModelTestCase {
    public EclipseLink1_1OrmPersistentTypeTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    public void testGetAccessWithJavaAnnotations() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        EclipseLink1_1OrmPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getAccess());
        EclipseLink1_1OrmPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        EclipseLink1_1OrmPersistentTypeTests.assertEquals(null, (Object)javaPersistentType.getSpecifiedAccess());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentAttribute.convertToSpecified();
        EclipseLink1_1OrmPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getAccess());
        EclipseLink1_1OrmPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        EclipseLink1_1OrmPersistentTypeTests.assertEquals(null, (Object)javaPersistentType.getSpecifiedAccess());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink1_1OrmPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentType.getAccess());
        EclipseLink1_1OrmPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }
}

