/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.jpa.core.jpa2.context.CollectionTable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCollectionTable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmCollectionTable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlCollectionTable;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlElementCollection_2_0;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0OrmCollectionTableTests
extends EclipseLink2_0ContextModelTestCase {
    public EclipseLink2_0OrmCollectionTableTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityWithValidElementCollection() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection").append(CR);
                sb.append("    private Collection<String> projects;").append(CR);
                sb.append("@Id").append(CR);
            }
        });
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 elementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = elementCollectionMapping.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedName());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable());
        resourceElementCollection.setCollectionTable(OrmFactory.eINSTANCE.createXmlCollectionTable());
        resourceElementCollection.getCollectionTable().setName("FOO");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)ormCollectionTable.getSpecifiedName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)resourceElementCollection.getCollectionTable().getName());
        resourceElementCollection.getCollectionTable().setName(null);
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedName());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable().getName());
        resourceElementCollection.getCollectionTable().setName("FOO");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)ormCollectionTable.getSpecifiedName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)resourceElementCollection.getCollectionTable().getName());
        resourceElementCollection.setCollectionTable(null);
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedName());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 elementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = elementCollectionMapping.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedName());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable());
        ormCollectionTable.setSpecifiedName("foo");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"foo", (String)ormCollectionTable.getSpecifiedName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"foo", (String)resourceElementCollection.getCollectionTable().getName());
        ormCollectionTable.setSpecifiedName(null);
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedName());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable());
    }

    public void testVirtualCollectionTable() throws Exception {
        this.createTestEntityWithValidElementCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("projects");
        ElementCollectionMapping2_0 virtualElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        CollectionTable2_0 virtualCollectionTable = virtualElementCollectionMapping.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"AnnotationTestType_projects", (String)virtualCollectionTable.getName());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)virtualCollectionTable.getSpecifiedCatalog());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)virtualCollectionTable.getSpecifiedSchema());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((int)0, (int)virtualCollectionTable.getSpecifiedJoinColumnsSize());
        JoinColumn virtualJoinColumn = virtualCollectionTable.getDefaultJoinColumn();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"AnnotationTestType_id", (String)virtualJoinColumn.getDefaultName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"id", (String)virtualJoinColumn.getDefaultReferencedColumnName());
        JavaPersistentAttribute javaPersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute();
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)javaPersistentAttribute.getMapping();
        JavaCollectionTable2_0 javaCollectionTable = javaElementCollectionMapping.getCollectionTable();
        javaCollectionTable.setSpecifiedName("FOO");
        javaCollectionTable.setSpecifiedCatalog("CATALOG");
        javaCollectionTable.setSpecifiedSchema("SCHEMA");
        JavaJoinColumn javaJoinColumn = javaCollectionTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("REFERENCED_NAME");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)virtualCollectionTable.getSpecifiedName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"CATALOG", (String)virtualCollectionTable.getSpecifiedCatalog());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"SCHEMA", (String)virtualCollectionTable.getSpecifiedSchema());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((int)1, (int)virtualCollectionTable.getSpecifiedJoinColumnsSize());
        virtualJoinColumn = (JoinColumn)virtualCollectionTable.getSpecifiedJoinColumns().iterator().next();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"NAME", (String)virtualJoinColumn.getSpecifiedName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"REFERENCED_NAME", (String)virtualJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntityWithValidElementCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "projects");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"AnnotationTestType_projects", (String)ormCollectionTable.getDefaultName());
        ((JavaEntity)ormPersistentType.getJavaPersistentType().getMapping()).setSpecifiedName("Foo");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"Foo_projects", (String)ormCollectionTable.getDefaultName());
        ((OrmEntity)ormPersistentType.getMapping()).setSpecifiedName("Bar");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"Bar_projects", (String)ormCollectionTable.getDefaultName());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("projects").getMapping();
        javaElementCollectionMapping.getCollectionTable().setSpecifiedName("JAVA_COLLECTION_TABLE");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"Bar_projects", (String)ormCollectionTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"Bar_projects", (String)ormCollectionTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("projects");
        ElementCollectionMapping2_0 virtualElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute2.getMapping();
        CollectionTable2_0 virtualCollectionTable = virtualElementCollectionMapping.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertTrue((boolean)ormPersistentAttribute2.isVirtual());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"JAVA_COLLECTION_TABLE", (String)virtualCollectionTable.getSpecifiedName());
        javaElementCollectionMapping.getCollectionTable().setSpecifiedName(null);
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)virtualCollectionTable.getSpecifiedName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"Bar_projects", (String)virtualCollectionTable.getDefaultName());
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedSchema());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable());
        resourceElementCollection.setCollectionTable(OrmFactory.eINSTANCE.createXmlCollectionTable());
        resourceElementCollection.getCollectionTable().setSchema("FOO");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)ormCollectionTable.getSpecifiedSchema());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)resourceElementCollection.getCollectionTable().getSchema());
        resourceElementCollection.getCollectionTable().setSchema(null);
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedSchema());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable().getSchema());
        resourceElementCollection.getCollectionTable().setSchema("FOO");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)ormCollectionTable.getSpecifiedSchema());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)resourceElementCollection.getCollectionTable().getSchema());
        resourceElementCollection.setCollectionTable(null);
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedSchema());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable());
    }

    public void testModifySpecifiedSchema() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedSchema());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable());
        ormCollectionTable.setSpecifiedSchema("foo");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"foo", (String)ormCollectionTable.getSpecifiedSchema());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"foo", (String)resourceElementCollection.getCollectionTable().getSchema());
        ormCollectionTable.setSpecifiedSchema(null);
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedSchema());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable());
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedCatalog());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable());
        resourceElementCollection.setCollectionTable(OrmFactory.eINSTANCE.createXmlCollectionTable());
        resourceElementCollection.getCollectionTable().setCatalog("FOO");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)ormCollectionTable.getSpecifiedCatalog());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)resourceElementCollection.getCollectionTable().getCatalog());
        resourceElementCollection.getCollectionTable().setCatalog(null);
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedCatalog());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable().getCatalog());
        resourceElementCollection.getCollectionTable().setCatalog("FOO");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)ormCollectionTable.getSpecifiedCatalog());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)resourceElementCollection.getCollectionTable().getCatalog());
        resourceElementCollection.setCollectionTable(null);
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedCatalog());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable());
    }

    public void testModifySpecifiedCatalog() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedCatalog());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable());
        ormCollectionTable.setSpecifiedCatalog("foo");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"foo", (String)ormCollectionTable.getSpecifiedCatalog());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"foo", (String)resourceElementCollection.getCollectionTable().getCatalog());
        ormCollectionTable.setSpecifiedCatalog(null);
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)ormCollectionTable.getSpecifiedCatalog());
        EclipseLink2_0OrmCollectionTableTests.assertNull((Object)resourceElementCollection.getCollectionTable());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        OrmJoinColumn joinColumn = ormCollectionTable.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        XmlCollectionTable resourceCollectionTable = resourceElementCollection.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(0)).getName());
        OrmJoinColumn joinColumn2 = ormCollectionTable.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(0)).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(1)).getName());
        OrmJoinColumn joinColumn3 = ormCollectionTable.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(0)).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(1)).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(2)).getName());
        ListIterator joinColumns = ormCollectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((Object)joinColumn2, joinColumns.next());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((Object)joinColumn3, joinColumns.next());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = ormCollectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        ormCollectionTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        ormCollectionTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        ormCollectionTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        XmlCollectionTable resourceCollectionTable = resourceElementCollection.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((int)3, (int)resourceCollectionTable.getJoinColumns().size());
        ormCollectionTable.removeSpecifiedJoinColumn(0);
        EclipseLink2_0OrmCollectionTableTests.assertEquals((int)2, (int)resourceCollectionTable.getJoinColumns().size());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(0)).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(1)).getName());
        ormCollectionTable.removeSpecifiedJoinColumn(0);
        EclipseLink2_0OrmCollectionTableTests.assertEquals((int)1, (int)resourceCollectionTable.getJoinColumns().size());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(0)).getName());
        ormCollectionTable.removeSpecifiedJoinColumn(0);
        EclipseLink2_0OrmCollectionTableTests.assertEquals((int)0, (int)resourceCollectionTable.getJoinColumns().size());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        ormCollectionTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        ormCollectionTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        ormCollectionTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        XmlCollectionTable resourceCollectionTable = resourceElementCollection.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((int)3, (int)resourceCollectionTable.getJoinColumns().size());
        ormCollectionTable.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = ormCollectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(0)).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(1)).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(2)).getName());
        ormCollectionTable.moveSpecifiedJoinColumn(0, 1);
        joinColumns = ormCollectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(0)).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(1)).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(2)).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        resourceElementCollection.setCollectionTable(OrmFactory.eINSTANCE.createXmlCollectionTable());
        XmlCollectionTable resourceCollectionTable = resourceElementCollection.getCollectionTable();
        resourceCollectionTable.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        resourceCollectionTable.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        resourceCollectionTable.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        ((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(0)).setName("FOO");
        ((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(1)).setName("BAR");
        ((XmlJoinColumn)resourceCollectionTable.getJoinColumns().get(2)).setName("BAZ");
        ListIterator joinColumns = ormCollectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)joinColumns.hasNext());
        resourceCollectionTable.getJoinColumns().move(2, 0);
        joinColumns = ormCollectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)joinColumns.hasNext());
        resourceCollectionTable.getJoinColumns().move(0, 1);
        joinColumns = ormCollectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)joinColumns.hasNext());
        resourceCollectionTable.getJoinColumns().remove(1);
        joinColumns = ormCollectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)joinColumns.hasNext());
        resourceCollectionTable.getJoinColumns().remove(1);
        joinColumns = ormCollectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)joinColumns.hasNext());
        resourceCollectionTable.getJoinColumns().remove(0);
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)ormCollectionTable.getSpecifiedJoinColumns().iterator().hasNext());
    }

    public void testUniqueConstraints() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        resourceElementCollection.setCollectionTable(OrmFactory.eINSTANCE.createXmlCollectionTable());
        XmlCollectionTable resourceCollectionTable = resourceElementCollection.getCollectionTable();
        ListIterator uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        resourceCollectionTable.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        resourceCollectionTable.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"bar", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"foo", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        resourceElementCollection.setCollectionTable(OrmFactory.eINSTANCE.createXmlCollectionTable());
        XmlCollectionTable resourceCollectionTable = resourceElementCollection.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((int)0, (int)ormCollectionTable.getUniqueConstraintsSize());
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        resourceCollectionTable.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        resourceCollectionTable.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((int)2, (int)ormCollectionTable.getUniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        resourceElementCollection.setCollectionTable(OrmFactory.eINSTANCE.createXmlCollectionTable());
        XmlCollectionTable resourceCollectionTable = resourceElementCollection.getCollectionTable();
        ormCollectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormCollectionTable.addUniqueConstraint(0).addColumnName(0, "BAR");
        ormCollectionTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        ListIterator uniqueConstraints = resourceCollectionTable.getUniqueConstraints().listIterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        resourceElementCollection.setCollectionTable(OrmFactory.eINSTANCE.createXmlCollectionTable());
        XmlCollectionTable resourceCollectionTable = resourceElementCollection.getCollectionTable();
        ormCollectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormCollectionTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        ormCollectionTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        ListIterator uniqueConstraints = resourceCollectionTable.getUniqueConstraints().listIterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        resourceElementCollection.setCollectionTable(OrmFactory.eINSTANCE.createXmlCollectionTable());
        XmlCollectionTable resourceCollectionTable = resourceElementCollection.getCollectionTable();
        ormCollectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormCollectionTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        ormCollectionTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((int)3, (int)resourceCollectionTable.getUniqueConstraints().size());
        ormCollectionTable.removeUniqueConstraint(1);
        ListIterator uniqueConstraintResources = resourceCollectionTable.getUniqueConstraints().listIterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        ListIterator uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        ormCollectionTable.removeUniqueConstraint(1);
        uniqueConstraintResources = resourceCollectionTable.getUniqueConstraints().listIterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        ormCollectionTable.removeUniqueConstraint(0);
        uniqueConstraintResources = resourceCollectionTable.getUniqueConstraints().listIterator();
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        resourceElementCollection.setCollectionTable(OrmFactory.eINSTANCE.createXmlCollectionTable());
        XmlCollectionTable resourceCollectionTable = resourceElementCollection.getCollectionTable();
        ormCollectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormCollectionTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        ormCollectionTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        EclipseLink2_0OrmCollectionTableTests.assertEquals((int)3, (int)resourceCollectionTable.getUniqueConstraints().size());
        ormCollectionTable.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        ListIterator uniqueConstraintResources = resourceCollectionTable.getUniqueConstraints().listIterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        ormCollectionTable.moveUniqueConstraint(0, 1);
        uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        uniqueConstraintResources = resourceCollectionTable.getUniqueConstraints().listIterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 resourceElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        OrmCollectionTable2_0 ormCollectionTable = ormElementCollectionMapping.getCollectionTable();
        resourceElementCollection.setCollectionTable(OrmFactory.eINSTANCE.createXmlCollectionTable());
        XmlCollectionTable resourceCollectionTable = resourceElementCollection.getCollectionTable();
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        resourceCollectionTable.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"FOO");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        resourceCollectionTable.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAR");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        resourceCollectionTable.getUniqueConstraints().add(2, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAZ");
        ListIterator uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        resourceCollectionTable.getUniqueConstraints().move(2, 0);
        uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        resourceCollectionTable.getUniqueConstraints().move(0, 1);
        uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        resourceCollectionTable.getUniqueConstraints().remove(1);
        uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        resourceCollectionTable.getUniqueConstraints().remove(1);
        uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        resourceCollectionTable.getUniqueConstraints().remove(0);
        uniqueConstraints = ormCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsFromJava() throws Exception {
        this.createTestEntityWithValidElementCollection();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ElementCollectionMapping2_0 virtualElementCollectionMapping = (ElementCollectionMapping2_0)((OrmReadOnlyPersistentAttribute)ormPersistentType.getAttributes().iterator().next()).getMapping();
        CollectionTable2_0 virtualCollectionTable = virtualElementCollectionMapping.getCollectionTable();
        EclipseLink2_0OrmCollectionTableTests.assertTrue((boolean)((OrmReadOnlyPersistentAttribute)ormPersistentType.getAttributes().iterator().next()).isVirtual());
        ListIterator uniqueConstraints = virtualCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping2_0 = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)ormPersistentType.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 javaCollectionTable = javaElementCollectionMapping2_0.getCollectionTable();
        javaCollectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        javaCollectionTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        javaCollectionTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        uniqueConstraints = virtualCollectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0OrmCollectionTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0OrmCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.getAttributes().iterator().next()).convertToSpecified();
        virtualElementCollectionMapping = (OrmElementCollectionMapping2_0)((OrmReadOnlyPersistentAttribute)ormPersistentType.getAttributes().iterator().next()).getMapping();
        EclipseLink2_0OrmCollectionTableTests.assertEquals((int)0, (int)virtualElementCollectionMapping.getCollectionTable().getUniqueConstraintsSize());
    }
}

